module Database.TigerBeetle.Response.Transfer where

data CreateTransfersResult
  = Ok
  | LinkedEventFailed
  | LinkedEventChainOpen
  | ImportedEventExpected
  | ImportedEventNotExpected
  | TimestampMustBeZero
  | ImportedEventTimestampOutOfRange
  | ImportedEventTimestampMustNotAdvance
  | ReservedFlag
  | IdMustNotBeZero
  | IdMustNotBeIntMax
  | ExistsWithDifferentFlags
  | ExistsWithDifferentPendingId
  | ExistsWithDifferentTimeout
  | ExistsWithDifferentDebitAccountId
  | ExistsWithDifferentCreditAccountId
  | ExistsWithDifferentAmount
  | ExistsWithDifferentUserData128
  | ExistsWithDifferentUserData64
  | ExistsWithDifferentUserData32
  | ExistsWithDifferentLedger
  | ExistsWithDifferentCode
  | Exists
  | IdAlreadyFailed
  | FlagsAreMutuallyExclusive
  | DebitAccountIdMustNotBeZero
  | DebitAccountIdMustNotBeIntMax
  | CreditAccountIdMustNotBeZero
  | CreditAccountIdMustNotBeIntMax
  | AccountsMustBeDifferent
  | PendingIdMustBeZero
  | PendingIdMustNotBeZero
  | PendingIdMustNotBeIntMax
  | PendingIdMustBeDifferent
  | TimeoutReservedForPendingTransfer
  | ClosingTransferMustBePending
  | LedgerMustNotBeZero
  | CodeMustNotBeZero
  | DebitAccountNotFound
  | CreditAccountNotFound
  | AccountsMustHaveTheSameLedger
  | TransferMustHaveTheSameLedgerAsAccounts
  | PendingTransferNotFound
  | PendingTransferNotPending
  | PendingTransferHasDifferentDebitAccountId
  | PendingTransferHasDifferentCreditAccountId
  | PendingTransferHasDifferentLedger
  | PendingTransferHasDifferentCode
  | ExceedsPendingTransferAmount
  | PendingTransferHasDifferentAmount
  | PendingTransferAlreadyPosted
  | PendingTransferAlreadyVoided
  | PendingTransferExpired
  | ImportedEventTimestampMustNotRegress
  | ImportedEventTimestampMustPostdateDebitAccount
  | ImportedEventTimestampMustPostdateCreditAccount
  | ImportedEventTimeoutMustBeZero
  | DebitAccountAlreadyClosed
  | CreditAccountAlreadyClosed
  | OverflowsDebitsPending
  | OverflowsCreditsPending
  | OverflowsDebitsPosted
  | OverflowsCreditsPosted
  | OverflowsDebits
  | OverflowsCredits
  | OverflowsTimeout
  | ExceedsCredits
  | ExceedsDebits
  deriving (Eq, Show)
