module Stratosphere.QuickSight.Analysis.DecimalParameterProperty (
        DecimalParameterProperty(..), mkDecimalParameterProperty
    ) where
import qualified Data.Aeson as JSON
import qualified Stratosphere.Prelude as Prelude
import Stratosphere.Property
import Stratosphere.ResourceProperties
import Stratosphere.Value
data DecimalParameterProperty
  = -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimalparameter.html>
    DecimalParameterProperty {haddock_workaround_ :: (),
                              -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimalparameter.html#cfn-quicksight-analysis-decimalparameter-name>
                              name :: (Value Prelude.Text),
                              -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimalparameter.html#cfn-quicksight-analysis-decimalparameter-values>
                              values :: (ValueList Prelude.Double)}
  deriving stock (Prelude.Eq, Prelude.Show)
mkDecimalParameterProperty ::
  Value Prelude.Text
  -> ValueList Prelude.Double -> DecimalParameterProperty
mkDecimalParameterProperty name values
  = DecimalParameterProperty
      {haddock_workaround_ = (), name = name, values = values}
instance ToResourceProperties DecimalParameterProperty where
  toResourceProperties DecimalParameterProperty {..}
    = ResourceProperties
        {awsType = "AWS::QuickSight::Analysis.DecimalParameter",
         supportsTags = Prelude.False,
         properties = ["Name" JSON..= name, "Values" JSON..= values]}
instance JSON.ToJSON DecimalParameterProperty where
  toJSON DecimalParameterProperty {..}
    = JSON.object ["Name" JSON..= name, "Values" JSON..= values]
instance Property "Name" DecimalParameterProperty where
  type PropertyType "Name" DecimalParameterProperty = Value Prelude.Text
  set newValue DecimalParameterProperty {..}
    = DecimalParameterProperty {name = newValue, ..}
instance Property "Values" DecimalParameterProperty where
  type PropertyType "Values" DecimalParameterProperty = ValueList Prelude.Double
  set newValue DecimalParameterProperty {..}
    = DecimalParameterProperty {values = newValue, ..}