module Stratosphere.GuardDuty.MalwareProtectionPlan.S3BucketProperty (
        S3BucketProperty(..), mkS3BucketProperty
    ) where
import qualified Data.Aeson as JSON
import qualified Stratosphere.Prelude as Prelude
import Stratosphere.Property
import Stratosphere.ResourceProperties
import Stratosphere.Value
data S3BucketProperty
  = -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-guardduty-malwareprotectionplan-s3bucket.html>
    S3BucketProperty {haddock_workaround_ :: (),
                      -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-guardduty-malwareprotectionplan-s3bucket.html#cfn-guardduty-malwareprotectionplan-s3bucket-bucketname>
                      bucketName :: (Prelude.Maybe (Value Prelude.Text)),
                      -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-guardduty-malwareprotectionplan-s3bucket.html#cfn-guardduty-malwareprotectionplan-s3bucket-objectprefixes>
                      objectPrefixes :: (Prelude.Maybe (ValueList Prelude.Text))}
  deriving stock (Prelude.Eq, Prelude.Show)
mkS3BucketProperty :: S3BucketProperty
mkS3BucketProperty
  = S3BucketProperty
      {haddock_workaround_ = (), bucketName = Prelude.Nothing,
       objectPrefixes = Prelude.Nothing}
instance ToResourceProperties S3BucketProperty where
  toResourceProperties S3BucketProperty {..}
    = ResourceProperties
        {awsType = "AWS::GuardDuty::MalwareProtectionPlan.S3Bucket",
         supportsTags = Prelude.False,
         properties = Prelude.fromList
                        (Prelude.catMaybes
                           [(JSON..=) "BucketName" Prelude.<$> bucketName,
                            (JSON..=) "ObjectPrefixes" Prelude.<$> objectPrefixes])}
instance JSON.ToJSON S3BucketProperty where
  toJSON S3BucketProperty {..}
    = JSON.object
        (Prelude.fromList
           (Prelude.catMaybes
              [(JSON..=) "BucketName" Prelude.<$> bucketName,
               (JSON..=) "ObjectPrefixes" Prelude.<$> objectPrefixes]))
instance Property "BucketName" S3BucketProperty where
  type PropertyType "BucketName" S3BucketProperty = Value Prelude.Text
  set newValue S3BucketProperty {..}
    = S3BucketProperty {bucketName = Prelude.pure newValue, ..}
instance Property "ObjectPrefixes" S3BucketProperty where
  type PropertyType "ObjectPrefixes" S3BucketProperty = ValueList Prelude.Text
  set newValue S3BucketProperty {..}
    = S3BucketProperty {objectPrefixes = Prelude.pure newValue, ..}