module Stratosphere.GameLift.ContainerGroupDefinition.ContainerPortRangeProperty (
        ContainerPortRangeProperty(..), mkContainerPortRangeProperty
    ) where
import qualified Data.Aeson as JSON
import qualified Stratosphere.Prelude as Prelude
import Stratosphere.Property
import Stratosphere.ResourceProperties
import Stratosphere.Value
data ContainerPortRangeProperty
  = -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerportrange.html>
    ContainerPortRangeProperty {haddock_workaround_ :: (),
                                -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerportrange.html#cfn-gamelift-containergroupdefinition-containerportrange-fromport>
                                fromPort :: (Value Prelude.Integer),
                                -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerportrange.html#cfn-gamelift-containergroupdefinition-containerportrange-protocol>
                                protocol :: (Value Prelude.Text),
                                -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerportrange.html#cfn-gamelift-containergroupdefinition-containerportrange-toport>
                                toPort :: (Value Prelude.Integer)}
  deriving stock (Prelude.Eq, Prelude.Show)
mkContainerPortRangeProperty ::
  Value Prelude.Integer
  -> Value Prelude.Text
     -> Value Prelude.Integer -> ContainerPortRangeProperty
mkContainerPortRangeProperty fromPort protocol toPort
  = ContainerPortRangeProperty
      {haddock_workaround_ = (), fromPort = fromPort,
       protocol = protocol, toPort = toPort}
instance ToResourceProperties ContainerPortRangeProperty where
  toResourceProperties ContainerPortRangeProperty {..}
    = ResourceProperties
        {awsType = "AWS::GameLift::ContainerGroupDefinition.ContainerPortRange",
         supportsTags = Prelude.False,
         properties = ["FromPort" JSON..= fromPort,
                       "Protocol" JSON..= protocol, "ToPort" JSON..= toPort]}
instance JSON.ToJSON ContainerPortRangeProperty where
  toJSON ContainerPortRangeProperty {..}
    = JSON.object
        ["FromPort" JSON..= fromPort, "Protocol" JSON..= protocol,
         "ToPort" JSON..= toPort]
instance Property "FromPort" ContainerPortRangeProperty where
  type PropertyType "FromPort" ContainerPortRangeProperty = Value Prelude.Integer
  set newValue ContainerPortRangeProperty {..}
    = ContainerPortRangeProperty {fromPort = newValue, ..}
instance Property "Protocol" ContainerPortRangeProperty where
  type PropertyType "Protocol" ContainerPortRangeProperty = Value Prelude.Text
  set newValue ContainerPortRangeProperty {..}
    = ContainerPortRangeProperty {protocol = newValue, ..}
instance Property "ToPort" ContainerPortRangeProperty where
  type PropertyType "ToPort" ContainerPortRangeProperty = Value Prelude.Integer
  set newValue ContainerPortRangeProperty {..}
    = ContainerPortRangeProperty {toPort = newValue, ..}