module Stratosphere.EFS.FileSystem.LifecyclePolicyProperty (
        LifecyclePolicyProperty(..), mkLifecyclePolicyProperty
    ) where
import qualified Data.Aeson as JSON
import qualified Stratosphere.Prelude as Prelude
import Stratosphere.Property
import Stratosphere.ResourceProperties
import Stratosphere.Value
data LifecyclePolicyProperty
  = -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-lifecyclepolicy.html>
    LifecyclePolicyProperty {haddock_workaround_ :: (),
                             -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-lifecyclepolicy.html#cfn-efs-filesystem-lifecyclepolicy-transitiontoarchive>
                             transitionToArchive :: (Prelude.Maybe (Value Prelude.Text)),
                             -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-lifecyclepolicy.html#cfn-efs-filesystem-lifecyclepolicy-transitiontoia>
                             transitionToIA :: (Prelude.Maybe (Value Prelude.Text)),
                             -- | See: <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-lifecyclepolicy.html#cfn-efs-filesystem-lifecyclepolicy-transitiontoprimarystorageclass>
                             transitionToPrimaryStorageClass :: (Prelude.Maybe (Value Prelude.Text))}
  deriving stock (Prelude.Eq, Prelude.Show)
mkLifecyclePolicyProperty :: LifecyclePolicyProperty
mkLifecyclePolicyProperty
  = LifecyclePolicyProperty
      {haddock_workaround_ = (), transitionToArchive = Prelude.Nothing,
       transitionToIA = Prelude.Nothing,
       transitionToPrimaryStorageClass = Prelude.Nothing}
instance ToResourceProperties LifecyclePolicyProperty where
  toResourceProperties LifecyclePolicyProperty {..}
    = ResourceProperties
        {awsType = "AWS::EFS::FileSystem.LifecyclePolicy",
         supportsTags = Prelude.False,
         properties = Prelude.fromList
                        (Prelude.catMaybes
                           [(JSON..=) "TransitionToArchive" Prelude.<$> transitionToArchive,
                            (JSON..=) "TransitionToIA" Prelude.<$> transitionToIA,
                            (JSON..=) "TransitionToPrimaryStorageClass"
                              Prelude.<$> transitionToPrimaryStorageClass])}
instance JSON.ToJSON LifecyclePolicyProperty where
  toJSON LifecyclePolicyProperty {..}
    = JSON.object
        (Prelude.fromList
           (Prelude.catMaybes
              [(JSON..=) "TransitionToArchive" Prelude.<$> transitionToArchive,
               (JSON..=) "TransitionToIA" Prelude.<$> transitionToIA,
               (JSON..=) "TransitionToPrimaryStorageClass"
                 Prelude.<$> transitionToPrimaryStorageClass]))
instance Property "TransitionToArchive" LifecyclePolicyProperty where
  type PropertyType "TransitionToArchive" LifecyclePolicyProperty = Value Prelude.Text
  set newValue LifecyclePolicyProperty {..}
    = LifecyclePolicyProperty
        {transitionToArchive = Prelude.pure newValue, ..}
instance Property "TransitionToIA" LifecyclePolicyProperty where
  type PropertyType "TransitionToIA" LifecyclePolicyProperty = Value Prelude.Text
  set newValue LifecyclePolicyProperty {..}
    = LifecyclePolicyProperty
        {transitionToIA = Prelude.pure newValue, ..}
instance Property "TransitionToPrimaryStorageClass" LifecyclePolicyProperty where
  type PropertyType "TransitionToPrimaryStorageClass" LifecyclePolicyProperty = Value Prelude.Text
  set newValue LifecyclePolicyProperty {..}
    = LifecyclePolicyProperty
        {transitionToPrimaryStorageClass = Prelude.pure newValue, ..}