module Graphics.MSDF.Atlas.CLI where

import Data.Text (Text)

type Inputs = [Input] -- grouped together with `-and`

data Input = Input
  { font :: FilePath
  , variation :: [(Text, Int)] -- optional variations, switching to varfont
  , range :: Maybe Range
  , fontscale :: Maybe Float
  , fontname :: Maybe Text
  }
  deriving (Eq, Show)

data Range
  = Charset FilePath
  | Chars SetSpec
  | Glyphs SetSpec
  | Allglyphs
  deriving (Eq, Show)

data SetSpec
  = Single Char
  | Range Char Char
  | String [Char]
  deriving (Eq, Show)

data Format
  = PNG
  | BMP
  | TIFF
  | RGBA
  | FL32
  | TEXT
  | TEXTFLOAT
  | BIN
  | BINFLOAT
  | BINFLOATLE
  deriving (Eq, Ord, Show, Enum, Bounded)

data Dimensions
  = Fixed Int Int
  | Auto Constraint
  deriving (Eq, Show)

data Constraint
  = PoTS
  | PoTR
  | Square
  | Square2
  | Square4 -- default
  deriving (Eq, Show)

data Uniform
  = UniformCols Int
  | UniformCell Int Int
  | UniformCellConstraint Constraint
  | UniformOrigin OriginConstraint
  deriving (Eq, Show)

data OriginConstraint
  = Off
  | On
  | Horizontal
  | Vertical
  deriving (Eq, Show)

type Outputs = [Output]

data Output
  = ImageOut FilePath
  | JSON FilePath
  | CSV FilePath
  | ARFont FilePath
  | ShadronPreview FilePath Text
  deriving (Eq, Show)

data Glyph = Glyph
  { size :: Maybe Float -- pixels per em
  , minsize :: Maybe Float
  , emrange :: Maybe Float
  , pxrange :: Maybe Int
  , aemrange :: Maybe (Float, Float)
  , pxalign :: OriginConstraint
  , empadding :: Maybe Float
  , pxpadding :: Maybe Int
  , outerempadding :: Maybe Float
  , outerpxpadding :: Maybe Int
  , aempadding :: Maybe (LBTR Float)
  , apxpadding :: Maybe (LBTR Int)
  , aouterempadding :: Maybe (LBTR Float)
  , aouterpxpadding :: Maybe (LBTR Int)
  }
  deriving (Eq, Show)

data LBTR a = LBTR
  { left, bottom, right, top :: a
  }
  deriving (Eq, Show)
