module KB.Text.Shape.FFI.Enums.Language where

import Prelude hiding (id, error)
import Foreign

import Data.Map (Map)
import Data.Map.Strict qualified as Map

#include "kb_text_shape.h"

newtype Language = Language Word32
  deriving (Eq, Ord)
  deriving newtype (Storable)

instance Show Language where
  showsPrec d l@(Language lv) =
    case Map.lookup l languageNames of
      Just name -> showString name
      Nothing -> showParen (d > 10) $ showString "Language " . showsPrec 11 lv

pattern LANGUAGE_DONT_KNOW :: Language
pattern LANGUAGE_DONT_KNOW = Language (#const KBTS_LANGUAGE_DONT_KNOW)

pattern LANGUAGE_A_HMAO :: Language
pattern LANGUAGE_A_HMAO = Language (#const KBTS_LANGUAGE_A_HMAO)

pattern LANGUAGE_AARI :: Language
pattern LANGUAGE_AARI = Language (#const KBTS_LANGUAGE_AARI)

pattern LANGUAGE_ABAZA :: Language
pattern LANGUAGE_ABAZA = Language (#const KBTS_LANGUAGE_ABAZA)

pattern LANGUAGE_ABKHAZIAN :: Language
pattern LANGUAGE_ABKHAZIAN = Language (#const KBTS_LANGUAGE_ABKHAZIAN)

pattern LANGUAGE_ACHI :: Language
pattern LANGUAGE_ACHI = Language (#const KBTS_LANGUAGE_ACHI)

pattern LANGUAGE_ACHOLI :: Language
pattern LANGUAGE_ACHOLI = Language (#const KBTS_LANGUAGE_ACHOLI)

pattern LANGUAGE_ADYGHE :: Language
pattern LANGUAGE_ADYGHE = Language (#const KBTS_LANGUAGE_ADYGHE)

pattern LANGUAGE_AFAR :: Language
pattern LANGUAGE_AFAR = Language (#const KBTS_LANGUAGE_AFAR)

pattern LANGUAGE_AFRIKAANS :: Language
pattern LANGUAGE_AFRIKAANS = Language (#const KBTS_LANGUAGE_AFRIKAANS)

pattern LANGUAGE_AGAW :: Language
pattern LANGUAGE_AGAW = Language (#const KBTS_LANGUAGE_AGAW)

pattern LANGUAGE_AITON :: Language
pattern LANGUAGE_AITON = Language (#const KBTS_LANGUAGE_AITON)

pattern LANGUAGE_AKAN :: Language
pattern LANGUAGE_AKAN = Language (#const KBTS_LANGUAGE_AKAN)

pattern LANGUAGE_ALBANIAN :: Language
pattern LANGUAGE_ALBANIAN = Language (#const KBTS_LANGUAGE_ALBANIAN)

pattern LANGUAGE_ALSATIAN :: Language
pattern LANGUAGE_ALSATIAN = Language (#const KBTS_LANGUAGE_ALSATIAN)

pattern LANGUAGE_ALTAI :: Language
pattern LANGUAGE_ALTAI = Language (#const KBTS_LANGUAGE_ALTAI)

pattern LANGUAGE_ALUO :: Language
pattern LANGUAGE_ALUO = Language (#const KBTS_LANGUAGE_ALUO)

pattern LANGUAGE_AMERICAN_PHONETIC :: Language
pattern LANGUAGE_AMERICAN_PHONETIC = Language (#const KBTS_LANGUAGE_AMERICAN_PHONETIC)

pattern LANGUAGE_AMHARIC :: Language
pattern LANGUAGE_AMHARIC = Language (#const KBTS_LANGUAGE_AMHARIC)

pattern LANGUAGE_ANGLO_SAXON :: Language
pattern LANGUAGE_ANGLO_SAXON = Language (#const KBTS_LANGUAGE_ANGLO_SAXON)

pattern LANGUAGE_ARABIC :: Language
pattern LANGUAGE_ARABIC = Language (#const KBTS_LANGUAGE_ARABIC)

pattern LANGUAGE_ARAGONESE :: Language
pattern LANGUAGE_ARAGONESE = Language (#const KBTS_LANGUAGE_ARAGONESE)

pattern LANGUAGE_ARAKANESE :: Language
pattern LANGUAGE_ARAKANESE = Language (#const KBTS_LANGUAGE_ARAKANESE)

pattern LANGUAGE_ARAKWAL :: Language
pattern LANGUAGE_ARAKWAL = Language (#const KBTS_LANGUAGE_ARAKWAL)

pattern LANGUAGE_ARMENIAN :: Language
pattern LANGUAGE_ARMENIAN = Language (#const KBTS_LANGUAGE_ARMENIAN)

pattern LANGUAGE_ARMENIAN_EAST :: Language
pattern LANGUAGE_ARMENIAN_EAST = Language (#const KBTS_LANGUAGE_ARMENIAN_EAST)

pattern LANGUAGE_AROMANIAN :: Language
pattern LANGUAGE_AROMANIAN = Language (#const KBTS_LANGUAGE_AROMANIAN)

pattern LANGUAGE_ARPITAN :: Language
pattern LANGUAGE_ARPITAN = Language (#const KBTS_LANGUAGE_ARPITAN)

pattern LANGUAGE_ASSAMESE :: Language
pattern LANGUAGE_ASSAMESE = Language (#const KBTS_LANGUAGE_ASSAMESE)

pattern LANGUAGE_ASTURIAN :: Language
pattern LANGUAGE_ASTURIAN = Language (#const KBTS_LANGUAGE_ASTURIAN)

pattern LANGUAGE_ATHAPASKAN :: Language
pattern LANGUAGE_ATHAPASKAN = Language (#const KBTS_LANGUAGE_ATHAPASKAN)

pattern LANGUAGE_ATSINA :: Language
pattern LANGUAGE_ATSINA = Language (#const KBTS_LANGUAGE_ATSINA)

pattern LANGUAGE_AVAR :: Language
pattern LANGUAGE_AVAR = Language (#const KBTS_LANGUAGE_AVAR)

pattern LANGUAGE_AVATIME :: Language
pattern LANGUAGE_AVATIME = Language (#const KBTS_LANGUAGE_AVATIME)

pattern LANGUAGE_AWADHI :: Language
pattern LANGUAGE_AWADHI = Language (#const KBTS_LANGUAGE_AWADHI)

pattern LANGUAGE_AYMARA :: Language
pattern LANGUAGE_AYMARA = Language (#const KBTS_LANGUAGE_AYMARA)

pattern LANGUAGE_AZERBAIDJANI :: Language
pattern LANGUAGE_AZERBAIDJANI = Language (#const KBTS_LANGUAGE_AZERBAIDJANI)

pattern LANGUAGE_BADAGA :: Language
pattern LANGUAGE_BADAGA = Language (#const KBTS_LANGUAGE_BADAGA)

pattern LANGUAGE_BAGHELKHANDI :: Language
pattern LANGUAGE_BAGHELKHANDI = Language (#const KBTS_LANGUAGE_BAGHELKHANDI)

pattern LANGUAGE_BAGRI :: Language
pattern LANGUAGE_BAGRI = Language (#const KBTS_LANGUAGE_BAGRI)

pattern LANGUAGE_BALANTE :: Language
pattern LANGUAGE_BALANTE = Language (#const KBTS_LANGUAGE_BALANTE)

pattern LANGUAGE_BALINESE :: Language
pattern LANGUAGE_BALINESE = Language (#const KBTS_LANGUAGE_BALINESE)

pattern LANGUAGE_BALKAR :: Language
pattern LANGUAGE_BALKAR = Language (#const KBTS_LANGUAGE_BALKAR)

pattern LANGUAGE_BALTI :: Language
pattern LANGUAGE_BALTI = Language (#const KBTS_LANGUAGE_BALTI)

pattern LANGUAGE_BALUCHI :: Language
pattern LANGUAGE_BALUCHI = Language (#const KBTS_LANGUAGE_BALUCHI)

pattern LANGUAGE_BAMBARA :: Language
pattern LANGUAGE_BAMBARA = Language (#const KBTS_LANGUAGE_BAMBARA)

pattern LANGUAGE_BAMILEKE :: Language
pattern LANGUAGE_BAMILEKE = Language (#const KBTS_LANGUAGE_BAMILEKE)

pattern LANGUAGE_BANDA :: Language
pattern LANGUAGE_BANDA = Language (#const KBTS_LANGUAGE_BANDA)

pattern LANGUAGE_BANDJALANG :: Language
pattern LANGUAGE_BANDJALANG = Language (#const KBTS_LANGUAGE_BANDJALANG)

pattern LANGUAGE_BANGLA :: Language
pattern LANGUAGE_BANGLA = Language (#const KBTS_LANGUAGE_BANGLA)

pattern LANGUAGE_BASHKIR :: Language
pattern LANGUAGE_BASHKIR = Language (#const KBTS_LANGUAGE_BASHKIR)

pattern LANGUAGE_BASQUE :: Language
pattern LANGUAGE_BASQUE = Language (#const KBTS_LANGUAGE_BASQUE)

pattern LANGUAGE_BATAK :: Language
pattern LANGUAGE_BATAK = Language (#const KBTS_LANGUAGE_BATAK)

pattern LANGUAGE_BATAK_ALAS_KLUET :: Language
pattern LANGUAGE_BATAK_ALAS_KLUET = Language (#const KBTS_LANGUAGE_BATAK_ALAS_KLUET)

pattern LANGUAGE_BATAK_ANGKOLA :: Language
pattern LANGUAGE_BATAK_ANGKOLA = Language (#const KBTS_LANGUAGE_BATAK_ANGKOLA)

pattern LANGUAGE_BATAK_DAIRI :: Language
pattern LANGUAGE_BATAK_DAIRI = Language (#const KBTS_LANGUAGE_BATAK_DAIRI)

pattern LANGUAGE_BATAK_KARO :: Language
pattern LANGUAGE_BATAK_KARO = Language (#const KBTS_LANGUAGE_BATAK_KARO)

pattern LANGUAGE_BATAK_MANDAILING :: Language
pattern LANGUAGE_BATAK_MANDAILING = Language (#const KBTS_LANGUAGE_BATAK_MANDAILING)

pattern LANGUAGE_BATAK_SIMALUNGUN :: Language
pattern LANGUAGE_BATAK_SIMALUNGUN = Language (#const KBTS_LANGUAGE_BATAK_SIMALUNGUN)

pattern LANGUAGE_BATAK_TOBA :: Language
pattern LANGUAGE_BATAK_TOBA = Language (#const KBTS_LANGUAGE_BATAK_TOBA)

pattern LANGUAGE_BAULE :: Language
pattern LANGUAGE_BAULE = Language (#const KBTS_LANGUAGE_BAULE)

pattern LANGUAGE_BAVARIAN :: Language
pattern LANGUAGE_BAVARIAN = Language (#const KBTS_LANGUAGE_BAVARIAN)

pattern LANGUAGE_BELARUSIAN :: Language
pattern LANGUAGE_BELARUSIAN = Language (#const KBTS_LANGUAGE_BELARUSIAN)

pattern LANGUAGE_BEMBA :: Language
pattern LANGUAGE_BEMBA = Language (#const KBTS_LANGUAGE_BEMBA)

pattern LANGUAGE_BENCH :: Language
pattern LANGUAGE_BENCH = Language (#const KBTS_LANGUAGE_BENCH)

pattern LANGUAGE_BERBER :: Language
pattern LANGUAGE_BERBER = Language (#const KBTS_LANGUAGE_BERBER)

pattern LANGUAGE_BETI :: Language
pattern LANGUAGE_BETI = Language (#const KBTS_LANGUAGE_BETI)

pattern LANGUAGE_BETTE_KURUMA :: Language
pattern LANGUAGE_BETTE_KURUMA = Language (#const KBTS_LANGUAGE_BETTE_KURUMA)

pattern LANGUAGE_BHILI :: Language
pattern LANGUAGE_BHILI = Language (#const KBTS_LANGUAGE_BHILI)

pattern LANGUAGE_BHOJPURI :: Language
pattern LANGUAGE_BHOJPURI = Language (#const KBTS_LANGUAGE_BHOJPURI)

pattern LANGUAGE_BHUTANESE :: Language
pattern LANGUAGE_BHUTANESE = Language (#const KBTS_LANGUAGE_BHUTANESE)

pattern LANGUAGE_BIBLE_CREE :: Language
pattern LANGUAGE_BIBLE_CREE = Language (#const KBTS_LANGUAGE_BIBLE_CREE)

pattern LANGUAGE_BIKOL :: Language
pattern LANGUAGE_BIKOL = Language (#const KBTS_LANGUAGE_BIKOL)

pattern LANGUAGE_BILEN :: Language
pattern LANGUAGE_BILEN = Language (#const KBTS_LANGUAGE_BILEN)

pattern LANGUAGE_BISHNUPRIYA_MANIPURI :: Language
pattern LANGUAGE_BISHNUPRIYA_MANIPURI = Language (#const KBTS_LANGUAGE_BISHNUPRIYA_MANIPURI)

pattern LANGUAGE_BISLAMA :: Language
pattern LANGUAGE_BISLAMA = Language (#const KBTS_LANGUAGE_BISLAMA)

pattern LANGUAGE_BLACKFOOT :: Language
pattern LANGUAGE_BLACKFOOT = Language (#const KBTS_LANGUAGE_BLACKFOOT)

pattern LANGUAGE_BODO :: Language
pattern LANGUAGE_BODO = Language (#const KBTS_LANGUAGE_BODO)

pattern LANGUAGE_BOSNIAN :: Language
pattern LANGUAGE_BOSNIAN = Language (#const KBTS_LANGUAGE_BOSNIAN)

pattern LANGUAGE_BOUYEI :: Language
pattern LANGUAGE_BOUYEI = Language (#const KBTS_LANGUAGE_BOUYEI)

pattern LANGUAGE_BRAHUI :: Language
pattern LANGUAGE_BRAHUI = Language (#const KBTS_LANGUAGE_BRAHUI)

pattern LANGUAGE_BRAJ_BHASHA :: Language
pattern LANGUAGE_BRAJ_BHASHA = Language (#const KBTS_LANGUAGE_BRAJ_BHASHA)

pattern LANGUAGE_BRETON :: Language
pattern LANGUAGE_BRETON = Language (#const KBTS_LANGUAGE_BRETON)

pattern LANGUAGE_BUGIS :: Language
pattern LANGUAGE_BUGIS = Language (#const KBTS_LANGUAGE_BUGIS)

pattern LANGUAGE_BULGARIAN :: Language
pattern LANGUAGE_BULGARIAN = Language (#const KBTS_LANGUAGE_BULGARIAN)

pattern LANGUAGE_BUMTHANGKHA :: Language
pattern LANGUAGE_BUMTHANGKHA = Language (#const KBTS_LANGUAGE_BUMTHANGKHA)

pattern LANGUAGE_BURMESE :: Language
pattern LANGUAGE_BURMESE = Language (#const KBTS_LANGUAGE_BURMESE)

pattern LANGUAGE_BURUSHASKI :: Language
pattern LANGUAGE_BURUSHASKI = Language (#const KBTS_LANGUAGE_BURUSHASKI)

pattern LANGUAGE_CAJUN_FRENCH :: Language
pattern LANGUAGE_CAJUN_FRENCH = Language (#const KBTS_LANGUAGE_CAJUN_FRENCH)

pattern LANGUAGE_CARRIER :: Language
pattern LANGUAGE_CARRIER = Language (#const KBTS_LANGUAGE_CARRIER)

pattern LANGUAGE_CATALAN :: Language
pattern LANGUAGE_CATALAN = Language (#const KBTS_LANGUAGE_CATALAN)

pattern LANGUAGE_CAYUGA :: Language
pattern LANGUAGE_CAYUGA = Language (#const KBTS_LANGUAGE_CAYUGA)

pattern LANGUAGE_CEBUANO :: Language
pattern LANGUAGE_CEBUANO = Language (#const KBTS_LANGUAGE_CEBUANO)

pattern LANGUAGE_CENTRAL_YUPIK :: Language
pattern LANGUAGE_CENTRAL_YUPIK = Language (#const KBTS_LANGUAGE_CENTRAL_YUPIK)

pattern LANGUAGE_CHAHA_GURAGE :: Language
pattern LANGUAGE_CHAHA_GURAGE = Language (#const KBTS_LANGUAGE_CHAHA_GURAGE)

pattern LANGUAGE_CHAMORRO :: Language
pattern LANGUAGE_CHAMORRO = Language (#const KBTS_LANGUAGE_CHAMORRO)

pattern LANGUAGE_CHATTISGARHI :: Language
pattern LANGUAGE_CHATTISGARHI = Language (#const KBTS_LANGUAGE_CHATTISGARHI)

pattern LANGUAGE_CHECHEN :: Language
pattern LANGUAGE_CHECHEN = Language (#const KBTS_LANGUAGE_CHECHEN)

pattern LANGUAGE_CHEROKEE :: Language
pattern LANGUAGE_CHEROKEE = Language (#const KBTS_LANGUAGE_CHEROKEE)

pattern LANGUAGE_CHEYENNE :: Language
pattern LANGUAGE_CHEYENNE = Language (#const KBTS_LANGUAGE_CHEYENNE)

pattern LANGUAGE_CHICHEWA :: Language
pattern LANGUAGE_CHICHEWA = Language (#const KBTS_LANGUAGE_CHICHEWA)

pattern LANGUAGE_CHIGA :: Language
pattern LANGUAGE_CHIGA = Language (#const KBTS_LANGUAGE_CHIGA)

pattern LANGUAGE_CHIMILA :: Language
pattern LANGUAGE_CHIMILA = Language (#const KBTS_LANGUAGE_CHIMILA)

pattern LANGUAGE_CHIN :: Language
pattern LANGUAGE_CHIN = Language (#const KBTS_LANGUAGE_CHIN)

pattern LANGUAGE_CHINANTEC :: Language
pattern LANGUAGE_CHINANTEC = Language (#const KBTS_LANGUAGE_CHINANTEC)

pattern LANGUAGE_CHINESE_PHONETIC :: Language
pattern LANGUAGE_CHINESE_PHONETIC = Language (#const KBTS_LANGUAGE_CHINESE_PHONETIC)

pattern LANGUAGE_CHINESE_SIMPLIFIED :: Language
pattern LANGUAGE_CHINESE_SIMPLIFIED = Language (#const KBTS_LANGUAGE_CHINESE_SIMPLIFIED)

pattern LANGUAGE_CHINESE_TRADITIONAL :: Language
pattern LANGUAGE_CHINESE_TRADITIONAL = Language (#const KBTS_LANGUAGE_CHINESE_TRADITIONAL)

pattern LANGUAGE_CHINESE_TRADITIONAL_HONG_KONG :: Language
pattern LANGUAGE_CHINESE_TRADITIONAL_HONG_KONG = Language (#const KBTS_LANGUAGE_CHINESE_TRADITIONAL_HONG_KONG)

pattern LANGUAGE_CHINESE_TRADITIONAL_MACAO :: Language
pattern LANGUAGE_CHINESE_TRADITIONAL_MACAO = Language (#const KBTS_LANGUAGE_CHINESE_TRADITIONAL_MACAO)

pattern LANGUAGE_CHIPEWYAN :: Language
pattern LANGUAGE_CHIPEWYAN = Language (#const KBTS_LANGUAGE_CHIPEWYAN)

pattern LANGUAGE_CHITTAGONIAN :: Language
pattern LANGUAGE_CHITTAGONIAN = Language (#const KBTS_LANGUAGE_CHITTAGONIAN)

pattern LANGUAGE_CHOCTAW :: Language
pattern LANGUAGE_CHOCTAW = Language (#const KBTS_LANGUAGE_CHOCTAW)

pattern LANGUAGE_CHUKCHI :: Language
pattern LANGUAGE_CHUKCHI = Language (#const KBTS_LANGUAGE_CHUKCHI)

pattern LANGUAGE_CHURCH_SLAVONIC :: Language
pattern LANGUAGE_CHURCH_SLAVONIC = Language (#const KBTS_LANGUAGE_CHURCH_SLAVONIC)

pattern LANGUAGE_CHUUKESE :: Language
pattern LANGUAGE_CHUUKESE = Language (#const KBTS_LANGUAGE_CHUUKESE)

pattern LANGUAGE_CHUVASH :: Language
pattern LANGUAGE_CHUVASH = Language (#const KBTS_LANGUAGE_CHUVASH)

pattern LANGUAGE_COMORIAN :: Language
pattern LANGUAGE_COMORIAN = Language (#const KBTS_LANGUAGE_COMORIAN)

pattern LANGUAGE_COMOX :: Language
pattern LANGUAGE_COMOX = Language (#const KBTS_LANGUAGE_COMOX)

pattern LANGUAGE_COPTIC :: Language
pattern LANGUAGE_COPTIC = Language (#const KBTS_LANGUAGE_COPTIC)

pattern LANGUAGE_CORNISH :: Language
pattern LANGUAGE_CORNISH = Language (#const KBTS_LANGUAGE_CORNISH)

pattern LANGUAGE_CORSICAN :: Language
pattern LANGUAGE_CORSICAN = Language (#const KBTS_LANGUAGE_CORSICAN)

pattern LANGUAGE_CREE :: Language
pattern LANGUAGE_CREE = Language (#const KBTS_LANGUAGE_CREE)

pattern LANGUAGE_CREOLES :: Language
pattern LANGUAGE_CREOLES = Language (#const KBTS_LANGUAGE_CREOLES)

pattern LANGUAGE_CRIMEAN_TATAR :: Language
pattern LANGUAGE_CRIMEAN_TATAR = Language (#const KBTS_LANGUAGE_CRIMEAN_TATAR)

pattern LANGUAGE_CRIOULO :: Language
pattern LANGUAGE_CRIOULO = Language (#const KBTS_LANGUAGE_CRIOULO)

pattern LANGUAGE_CROATIAN :: Language
pattern LANGUAGE_CROATIAN = Language (#const KBTS_LANGUAGE_CROATIAN)

pattern LANGUAGE_CYPRIOT_ARABIC :: Language
pattern LANGUAGE_CYPRIOT_ARABIC = Language (#const KBTS_LANGUAGE_CYPRIOT_ARABIC)

pattern LANGUAGE_CZECH :: Language
pattern LANGUAGE_CZECH = Language (#const KBTS_LANGUAGE_CZECH)

pattern LANGUAGE_DAGBANI :: Language
pattern LANGUAGE_DAGBANI = Language (#const KBTS_LANGUAGE_DAGBANI)

pattern LANGUAGE_DAN :: Language
pattern LANGUAGE_DAN = Language (#const KBTS_LANGUAGE_DAN)

pattern LANGUAGE_DANGME :: Language
pattern LANGUAGE_DANGME = Language (#const KBTS_LANGUAGE_DANGME)

pattern LANGUAGE_DANISH :: Language
pattern LANGUAGE_DANISH = Language (#const KBTS_LANGUAGE_DANISH)

pattern LANGUAGE_DARGWA :: Language
pattern LANGUAGE_DARGWA = Language (#const KBTS_LANGUAGE_DARGWA)

pattern LANGUAGE_DARI :: Language
pattern LANGUAGE_DARI = Language (#const KBTS_LANGUAGE_DARI)

pattern LANGUAGE_DAYI :: Language
pattern LANGUAGE_DAYI = Language (#const KBTS_LANGUAGE_DAYI)

pattern LANGUAGE_DEFAULT :: Language
pattern LANGUAGE_DEFAULT = Language (#const KBTS_LANGUAGE_DEFAULT)

pattern LANGUAGE_DEHONG_DAI :: Language
pattern LANGUAGE_DEHONG_DAI = Language (#const KBTS_LANGUAGE_DEHONG_DAI)

pattern LANGUAGE_DHANGU :: Language
pattern LANGUAGE_DHANGU = Language (#const KBTS_LANGUAGE_DHANGU)

pattern LANGUAGE_DHIVEHI :: Language
pattern LANGUAGE_DHIVEHI = Language (#const KBTS_LANGUAGE_DHIVEHI)

pattern LANGUAGE_DHUWAL :: Language
pattern LANGUAGE_DHUWAL = Language (#const KBTS_LANGUAGE_DHUWAL)

pattern LANGUAGE_DIMLI :: Language
pattern LANGUAGE_DIMLI = Language (#const KBTS_LANGUAGE_DIMLI)

pattern LANGUAGE_DINKA :: Language
pattern LANGUAGE_DINKA = Language (#const KBTS_LANGUAGE_DINKA)

pattern LANGUAGE_DIVEHI :: Language
pattern LANGUAGE_DIVEHI = Language (#const KBTS_LANGUAGE_DIVEHI)

pattern LANGUAGE_DJAMBARRPUYNGU :: Language
pattern LANGUAGE_DJAMBARRPUYNGU = Language (#const KBTS_LANGUAGE_DJAMBARRPUYNGU)

pattern LANGUAGE_DOGRI :: Language
pattern LANGUAGE_DOGRI = Language (#const KBTS_LANGUAGE_DOGRI)

pattern LANGUAGE_DOGRI_MACROLANGUAGE :: Language
pattern LANGUAGE_DOGRI_MACROLANGUAGE = Language (#const KBTS_LANGUAGE_DOGRI_MACROLANGUAGE)

pattern LANGUAGE_DUNGAN :: Language
pattern LANGUAGE_DUNGAN = Language (#const KBTS_LANGUAGE_DUNGAN)

pattern LANGUAGE_DUTCH :: Language
pattern LANGUAGE_DUTCH = Language (#const KBTS_LANGUAGE_DUTCH)

pattern LANGUAGE_DZONGKHA :: Language
pattern LANGUAGE_DZONGKHA = Language (#const KBTS_LANGUAGE_DZONGKHA)

pattern LANGUAGE_EASTERN_ABENAKI :: Language
pattern LANGUAGE_EASTERN_ABENAKI = Language (#const KBTS_LANGUAGE_EASTERN_ABENAKI)

pattern LANGUAGE_EASTERN_CHAM :: Language
pattern LANGUAGE_EASTERN_CHAM = Language (#const KBTS_LANGUAGE_EASTERN_CHAM)

pattern LANGUAGE_EASTERN_CREE :: Language
pattern LANGUAGE_EASTERN_CREE = Language (#const KBTS_LANGUAGE_EASTERN_CREE)

pattern LANGUAGE_EASTERN_MANINKAKAN :: Language
pattern LANGUAGE_EASTERN_MANINKAKAN = Language (#const KBTS_LANGUAGE_EASTERN_MANINKAKAN)

pattern LANGUAGE_EASTERN_PWO_KAREN :: Language
pattern LANGUAGE_EASTERN_PWO_KAREN = Language (#const KBTS_LANGUAGE_EASTERN_PWO_KAREN)

pattern LANGUAGE_EBIRA :: Language
pattern LANGUAGE_EBIRA = Language (#const KBTS_LANGUAGE_EBIRA)

pattern LANGUAGE_EDO :: Language
pattern LANGUAGE_EDO = Language (#const KBTS_LANGUAGE_EDO)

pattern LANGUAGE_EFIK :: Language
pattern LANGUAGE_EFIK = Language (#const KBTS_LANGUAGE_EFIK)

pattern LANGUAGE_EMBERA_BAUDO :: Language
pattern LANGUAGE_EMBERA_BAUDO = Language (#const KBTS_LANGUAGE_EMBERA_BAUDO)

pattern LANGUAGE_EMBERA_CATIO :: Language
pattern LANGUAGE_EMBERA_CATIO = Language (#const KBTS_LANGUAGE_EMBERA_CATIO)

pattern LANGUAGE_EMBERA_CHAMI :: Language
pattern LANGUAGE_EMBERA_CHAMI = Language (#const KBTS_LANGUAGE_EMBERA_CHAMI)

pattern LANGUAGE_EMBERA_TADO :: Language
pattern LANGUAGE_EMBERA_TADO = Language (#const KBTS_LANGUAGE_EMBERA_TADO)

pattern LANGUAGE_ENGLISH :: Language
pattern LANGUAGE_ENGLISH = Language (#const KBTS_LANGUAGE_ENGLISH)

pattern LANGUAGE_EPENA :: Language
pattern LANGUAGE_EPENA = Language (#const KBTS_LANGUAGE_EPENA)

pattern LANGUAGE_ERZYA :: Language
pattern LANGUAGE_ERZYA = Language (#const KBTS_LANGUAGE_ERZYA)

pattern LANGUAGE_KB_TEXT_SHAPEANTO :: Language
pattern LANGUAGE_KB_TEXT_SHAPEANTO = Language (#const KBTS_LANGUAGE_KB_TEXT_SHAPEANTO)

pattern LANGUAGE_ESTONIAN :: Language
pattern LANGUAGE_ESTONIAN = Language (#const KBTS_LANGUAGE_ESTONIAN)

pattern LANGUAGE_EVEN :: Language
pattern LANGUAGE_EVEN = Language (#const KBTS_LANGUAGE_EVEN)

pattern LANGUAGE_EVENKI :: Language
pattern LANGUAGE_EVENKI = Language (#const KBTS_LANGUAGE_EVENKI)

pattern LANGUAGE_EWE :: Language
pattern LANGUAGE_EWE = Language (#const KBTS_LANGUAGE_EWE)

pattern LANGUAGE_FALAM_CHIN :: Language
pattern LANGUAGE_FALAM_CHIN = Language (#const KBTS_LANGUAGE_FALAM_CHIN)

pattern LANGUAGE_FANG :: Language
pattern LANGUAGE_FANG = Language (#const KBTS_LANGUAGE_FANG)

pattern LANGUAGE_FANTI :: Language
pattern LANGUAGE_FANTI = Language (#const KBTS_LANGUAGE_FANTI)

pattern LANGUAGE_FAROESE :: Language
pattern LANGUAGE_FAROESE = Language (#const KBTS_LANGUAGE_FAROESE)

pattern LANGUAGE_FEFE :: Language
pattern LANGUAGE_FEFE = Language (#const KBTS_LANGUAGE_FEFE)

pattern LANGUAGE_FIJIAN :: Language
pattern LANGUAGE_FIJIAN = Language (#const KBTS_LANGUAGE_FIJIAN)

pattern LANGUAGE_FILIPINO :: Language
pattern LANGUAGE_FILIPINO = Language (#const KBTS_LANGUAGE_FILIPINO)

pattern LANGUAGE_FINNISH :: Language
pattern LANGUAGE_FINNISH = Language (#const KBTS_LANGUAGE_FINNISH)

pattern LANGUAGE_FLEMISH :: Language
pattern LANGUAGE_FLEMISH = Language (#const KBTS_LANGUAGE_FLEMISH)

pattern LANGUAGE_FON :: Language
pattern LANGUAGE_FON = Language (#const KBTS_LANGUAGE_FON)

pattern LANGUAGE_FOREST_ENETS :: Language
pattern LANGUAGE_FOREST_ENETS = Language (#const KBTS_LANGUAGE_FOREST_ENETS)

pattern LANGUAGE_FRENCH :: Language
pattern LANGUAGE_FRENCH = Language (#const KBTS_LANGUAGE_FRENCH)

pattern LANGUAGE_FRENCH_ANTILLEAN :: Language
pattern LANGUAGE_FRENCH_ANTILLEAN = Language (#const KBTS_LANGUAGE_FRENCH_ANTILLEAN)

pattern LANGUAGE_FRISIAN :: Language
pattern LANGUAGE_FRISIAN = Language (#const KBTS_LANGUAGE_FRISIAN)

pattern LANGUAGE_FRIULIAN :: Language
pattern LANGUAGE_FRIULIAN = Language (#const KBTS_LANGUAGE_FRIULIAN)

pattern LANGUAGE_FULAH :: Language
pattern LANGUAGE_FULAH = Language (#const KBTS_LANGUAGE_FULAH)

pattern LANGUAGE_FUTA :: Language
pattern LANGUAGE_FUTA = Language (#const KBTS_LANGUAGE_FUTA)

pattern LANGUAGE_GA :: Language
pattern LANGUAGE_GA = Language (#const KBTS_LANGUAGE_GA)

pattern LANGUAGE_GAGAUZ :: Language
pattern LANGUAGE_GAGAUZ = Language (#const KBTS_LANGUAGE_GAGAUZ)

pattern LANGUAGE_GALICIAN :: Language
pattern LANGUAGE_GALICIAN = Language (#const KBTS_LANGUAGE_GALICIAN)

pattern LANGUAGE_GANDA :: Language
pattern LANGUAGE_GANDA = Language (#const KBTS_LANGUAGE_GANDA)

pattern LANGUAGE_GARHWALI :: Language
pattern LANGUAGE_GARHWALI = Language (#const KBTS_LANGUAGE_GARHWALI)

pattern LANGUAGE_GARO :: Language
pattern LANGUAGE_GARO = Language (#const KBTS_LANGUAGE_GARO)

pattern LANGUAGE_GARSHUNI :: Language
pattern LANGUAGE_GARSHUNI = Language (#const KBTS_LANGUAGE_GARSHUNI)

pattern LANGUAGE_GEBA_KAREN :: Language
pattern LANGUAGE_GEBA_KAREN = Language (#const KBTS_LANGUAGE_GEBA_KAREN)

pattern LANGUAGE_GEEZ :: Language
pattern LANGUAGE_GEEZ = Language (#const KBTS_LANGUAGE_GEEZ)

pattern LANGUAGE_GEORGIAN :: Language
pattern LANGUAGE_GEORGIAN = Language (#const KBTS_LANGUAGE_GEORGIAN)

pattern LANGUAGE_GEPO :: Language
pattern LANGUAGE_GEPO = Language (#const KBTS_LANGUAGE_GEPO)

pattern LANGUAGE_GERMAN :: Language
pattern LANGUAGE_GERMAN = Language (#const KBTS_LANGUAGE_GERMAN)

pattern LANGUAGE_GIKUYU :: Language
pattern LANGUAGE_GIKUYU = Language (#const KBTS_LANGUAGE_GIKUYU)

pattern LANGUAGE_GILAKI :: Language
pattern LANGUAGE_GILAKI = Language (#const KBTS_LANGUAGE_GILAKI)

pattern LANGUAGE_GILBERTESE :: Language
pattern LANGUAGE_GILBERTESE = Language (#const KBTS_LANGUAGE_GILBERTESE)

pattern LANGUAGE_GILYAK :: Language
pattern LANGUAGE_GILYAK = Language (#const KBTS_LANGUAGE_GILYAK)

pattern LANGUAGE_GITHABUL :: Language
pattern LANGUAGE_GITHABUL = Language (#const KBTS_LANGUAGE_GITHABUL)

pattern LANGUAGE_GOGO :: Language
pattern LANGUAGE_GOGO = Language (#const KBTS_LANGUAGE_GOGO)

pattern LANGUAGE_GONDI :: Language
pattern LANGUAGE_GONDI = Language (#const KBTS_LANGUAGE_GONDI)

pattern LANGUAGE_GREEK :: Language
pattern LANGUAGE_GREEK = Language (#const KBTS_LANGUAGE_GREEK)

pattern LANGUAGE_GREENLANDIC :: Language
pattern LANGUAGE_GREENLANDIC = Language (#const KBTS_LANGUAGE_GREENLANDIC)

pattern LANGUAGE_GUARANI :: Language
pattern LANGUAGE_GUARANI = Language (#const KBTS_LANGUAGE_GUARANI)

pattern LANGUAGE_GUINEA :: Language
pattern LANGUAGE_GUINEA = Language (#const KBTS_LANGUAGE_GUINEA)

pattern LANGUAGE_GUJARATI :: Language
pattern LANGUAGE_GUJARATI = Language (#const KBTS_LANGUAGE_GUJARATI)

pattern LANGUAGE_GUMATJ :: Language
pattern LANGUAGE_GUMATJ = Language (#const KBTS_LANGUAGE_GUMATJ)

pattern LANGUAGE_GUMUZ :: Language
pattern LANGUAGE_GUMUZ = Language (#const KBTS_LANGUAGE_GUMUZ)

pattern LANGUAGE_GUPAPUYNGU :: Language
pattern LANGUAGE_GUPAPUYNGU = Language (#const KBTS_LANGUAGE_GUPAPUYNGU)

pattern LANGUAGE_GUSII :: Language
pattern LANGUAGE_GUSII = Language (#const KBTS_LANGUAGE_GUSII)

pattern LANGUAGE_HAIDA :: Language
pattern LANGUAGE_HAIDA = Language (#const KBTS_LANGUAGE_HAIDA)

pattern LANGUAGE_HAITIAN_CREOLE :: Language
pattern LANGUAGE_HAITIAN_CREOLE = Language (#const KBTS_LANGUAGE_HAITIAN_CREOLE)

pattern LANGUAGE_HALKOMELEM :: Language
pattern LANGUAGE_HALKOMELEM = Language (#const KBTS_LANGUAGE_HALKOMELEM)

pattern LANGUAGE_HAMMER_BANNA :: Language
pattern LANGUAGE_HAMMER_BANNA = Language (#const KBTS_LANGUAGE_HAMMER_BANNA)

pattern LANGUAGE_HARARI :: Language
pattern LANGUAGE_HARARI = Language (#const KBTS_LANGUAGE_HARARI)

pattern LANGUAGE_HARAUTI :: Language
pattern LANGUAGE_HARAUTI = Language (#const KBTS_LANGUAGE_HARAUTI)

pattern LANGUAGE_HARYANVI :: Language
pattern LANGUAGE_HARYANVI = Language (#const KBTS_LANGUAGE_HARYANVI)

pattern LANGUAGE_HAUSA :: Language
pattern LANGUAGE_HAUSA = Language (#const KBTS_LANGUAGE_HAUSA)

pattern LANGUAGE_HAVASUPAI_WALAPAI_YAVAPAI :: Language
pattern LANGUAGE_HAVASUPAI_WALAPAI_YAVAPAI = Language (#const KBTS_LANGUAGE_HAVASUPAI_WALAPAI_YAVAPAI)

pattern LANGUAGE_HAWAIIAN :: Language
pattern LANGUAGE_HAWAIIAN = Language (#const KBTS_LANGUAGE_HAWAIIAN)

pattern LANGUAGE_HAYA :: Language
pattern LANGUAGE_HAYA = Language (#const KBTS_LANGUAGE_HAYA)

pattern LANGUAGE_HAZARAGI :: Language
pattern LANGUAGE_HAZARAGI = Language (#const KBTS_LANGUAGE_HAZARAGI)

pattern LANGUAGE_HEBREW :: Language
pattern LANGUAGE_HEBREW = Language (#const KBTS_LANGUAGE_HEBREW)

pattern LANGUAGE_HEILTSUK :: Language
pattern LANGUAGE_HEILTSUK = Language (#const KBTS_LANGUAGE_HEILTSUK)

pattern LANGUAGE_HERERO :: Language
pattern LANGUAGE_HERERO = Language (#const KBTS_LANGUAGE_HERERO)

pattern LANGUAGE_HIGH_MARI :: Language
pattern LANGUAGE_HIGH_MARI = Language (#const KBTS_LANGUAGE_HIGH_MARI)

pattern LANGUAGE_HILIGAYNON :: Language
pattern LANGUAGE_HILIGAYNON = Language (#const KBTS_LANGUAGE_HILIGAYNON)

pattern LANGUAGE_HINDI :: Language
pattern LANGUAGE_HINDI = Language (#const KBTS_LANGUAGE_HINDI)

pattern LANGUAGE_HINDKO :: Language
pattern LANGUAGE_HINDKO = Language (#const KBTS_LANGUAGE_HINDKO)

pattern LANGUAGE_HIRI_MOTU :: Language
pattern LANGUAGE_HIRI_MOTU = Language (#const KBTS_LANGUAGE_HIRI_MOTU)

pattern LANGUAGE_HMONG :: Language
pattern LANGUAGE_HMONG = Language (#const KBTS_LANGUAGE_HMONG)

pattern LANGUAGE_HMONG_DAW :: Language
pattern LANGUAGE_HMONG_DAW = Language (#const KBTS_LANGUAGE_HMONG_DAW)

pattern LANGUAGE_HMONG_SHUAT :: Language
pattern LANGUAGE_HMONG_SHUAT = Language (#const KBTS_LANGUAGE_HMONG_SHUAT)

pattern LANGUAGE_HO :: Language
pattern LANGUAGE_HO = Language (#const KBTS_LANGUAGE_HO)

pattern LANGUAGE_HUNGARIAN :: Language
pattern LANGUAGE_HUNGARIAN = Language (#const KBTS_LANGUAGE_HUNGARIAN)

pattern LANGUAGE_IBAN :: Language
pattern LANGUAGE_IBAN = Language (#const KBTS_LANGUAGE_IBAN)

pattern LANGUAGE_IBIBIO :: Language
pattern LANGUAGE_IBIBIO = Language (#const KBTS_LANGUAGE_IBIBIO)

pattern LANGUAGE_ICELANDIC :: Language
pattern LANGUAGE_ICELANDIC = Language (#const KBTS_LANGUAGE_ICELANDIC)

pattern LANGUAGE_IDO :: Language
pattern LANGUAGE_IDO = Language (#const KBTS_LANGUAGE_IDO)

pattern LANGUAGE_IGBO :: Language
pattern LANGUAGE_IGBO = Language (#const KBTS_LANGUAGE_IGBO)

pattern LANGUAGE_IJO :: Language
pattern LANGUAGE_IJO = Language (#const KBTS_LANGUAGE_IJO)

pattern LANGUAGE_ILOKANO :: Language
pattern LANGUAGE_ILOKANO = Language (#const KBTS_LANGUAGE_ILOKANO)

pattern LANGUAGE_INARI_SAMI :: Language
pattern LANGUAGE_INARI_SAMI = Language (#const KBTS_LANGUAGE_INARI_SAMI)

pattern LANGUAGE_INDONESIAN :: Language
pattern LANGUAGE_INDONESIAN = Language (#const KBTS_LANGUAGE_INDONESIAN)

pattern LANGUAGE_INGUSH :: Language
pattern LANGUAGE_INGUSH = Language (#const KBTS_LANGUAGE_INGUSH)

pattern LANGUAGE_INTERLINGUA :: Language
pattern LANGUAGE_INTERLINGUA = Language (#const KBTS_LANGUAGE_INTERLINGUA)

pattern LANGUAGE_INTERLINGUE :: Language
pattern LANGUAGE_INTERLINGUE = Language (#const KBTS_LANGUAGE_INTERLINGUE)

pattern LANGUAGE_INUKTITUT :: Language
pattern LANGUAGE_INUKTITUT = Language (#const KBTS_LANGUAGE_INUKTITUT)

pattern LANGUAGE_INUPIAT :: Language
pattern LANGUAGE_INUPIAT = Language (#const KBTS_LANGUAGE_INUPIAT)

pattern LANGUAGE_IPA_PHONETIC :: Language
pattern LANGUAGE_IPA_PHONETIC = Language (#const KBTS_LANGUAGE_IPA_PHONETIC)

pattern LANGUAGE_IRISH :: Language
pattern LANGUAGE_IRISH = Language (#const KBTS_LANGUAGE_IRISH)

pattern LANGUAGE_IRISH_TRADITIONAL :: Language
pattern LANGUAGE_IRISH_TRADITIONAL = Language (#const KBTS_LANGUAGE_IRISH_TRADITIONAL)

pattern LANGUAGE_IRULA :: Language
pattern LANGUAGE_IRULA = Language (#const KBTS_LANGUAGE_IRULA)

pattern LANGUAGE_ITALIAN :: Language
pattern LANGUAGE_ITALIAN = Language (#const KBTS_LANGUAGE_ITALIAN)

pattern LANGUAGE_JAMAICAN_CREOLE :: Language
pattern LANGUAGE_JAMAICAN_CREOLE = Language (#const KBTS_LANGUAGE_JAMAICAN_CREOLE)

pattern LANGUAGE_JAPANESE :: Language
pattern LANGUAGE_JAPANESE = Language (#const KBTS_LANGUAGE_JAPANESE)

pattern LANGUAGE_JAVANESE :: Language
pattern LANGUAGE_JAVANESE = Language (#const KBTS_LANGUAGE_JAVANESE)

pattern LANGUAGE_JENNU_KURUMA :: Language
pattern LANGUAGE_JENNU_KURUMA = Language (#const KBTS_LANGUAGE_JENNU_KURUMA)

pattern LANGUAGE_JUDEO_TAT :: Language
pattern LANGUAGE_JUDEO_TAT = Language (#const KBTS_LANGUAGE_JUDEO_TAT)

pattern LANGUAGE_JULA :: Language
pattern LANGUAGE_JULA = Language (#const KBTS_LANGUAGE_JULA)

pattern LANGUAGE_KABARDIAN :: Language
pattern LANGUAGE_KABARDIAN = Language (#const KBTS_LANGUAGE_KABARDIAN)

pattern LANGUAGE_KABYLE :: Language
pattern LANGUAGE_KABYLE = Language (#const KBTS_LANGUAGE_KABYLE)

pattern LANGUAGE_KACHCHI :: Language
pattern LANGUAGE_KACHCHI = Language (#const KBTS_LANGUAGE_KACHCHI)

pattern LANGUAGE_KADIWEU :: Language
pattern LANGUAGE_KADIWEU = Language (#const KBTS_LANGUAGE_KADIWEU)

pattern LANGUAGE_KALENJIN :: Language
pattern LANGUAGE_KALENJIN = Language (#const KBTS_LANGUAGE_KALENJIN)

pattern LANGUAGE_KALMYK :: Language
pattern LANGUAGE_KALMYK = Language (#const KBTS_LANGUAGE_KALMYK)

pattern LANGUAGE_KAMBA :: Language
pattern LANGUAGE_KAMBA = Language (#const KBTS_LANGUAGE_KAMBA)

pattern LANGUAGE_KANAUJI :: Language
pattern LANGUAGE_KANAUJI = Language (#const KBTS_LANGUAGE_KANAUJI)

pattern LANGUAGE_KANNADA :: Language
pattern LANGUAGE_KANNADA = Language (#const KBTS_LANGUAGE_KANNADA)

pattern LANGUAGE_KANURI :: Language
pattern LANGUAGE_KANURI = Language (#const KBTS_LANGUAGE_KANURI)

pattern LANGUAGE_KAQCHIKEL :: Language
pattern LANGUAGE_KAQCHIKEL = Language (#const KBTS_LANGUAGE_KAQCHIKEL)

pattern LANGUAGE_KARACHAY :: Language
pattern LANGUAGE_KARACHAY = Language (#const KBTS_LANGUAGE_KARACHAY)

pattern LANGUAGE_KARAIM :: Language
pattern LANGUAGE_KARAIM = Language (#const KBTS_LANGUAGE_KARAIM)

pattern LANGUAGE_KARAKALPAK :: Language
pattern LANGUAGE_KARAKALPAK = Language (#const KBTS_LANGUAGE_KARAKALPAK)

pattern LANGUAGE_KARELIAN :: Language
pattern LANGUAGE_KARELIAN = Language (#const KBTS_LANGUAGE_KARELIAN)

pattern LANGUAGE_KAREN :: Language
pattern LANGUAGE_KAREN = Language (#const KBTS_LANGUAGE_KAREN)

pattern LANGUAGE_KASHMIRI :: Language
pattern LANGUAGE_KASHMIRI = Language (#const KBTS_LANGUAGE_KASHMIRI)

pattern LANGUAGE_KASHUBIAN :: Language
pattern LANGUAGE_KASHUBIAN = Language (#const KBTS_LANGUAGE_KASHUBIAN)

pattern LANGUAGE_KATE :: Language
pattern LANGUAGE_KATE = Language (#const KBTS_LANGUAGE_KATE)

pattern LANGUAGE_KAZAKH :: Language
pattern LANGUAGE_KAZAKH = Language (#const KBTS_LANGUAGE_KAZAKH)

pattern LANGUAGE_KEBENA :: Language
pattern LANGUAGE_KEBENA = Language (#const KBTS_LANGUAGE_KEBENA)

pattern LANGUAGE_KEKCHI :: Language
pattern LANGUAGE_KEKCHI = Language (#const KBTS_LANGUAGE_KEKCHI)

pattern LANGUAGE_KHAKASS :: Language
pattern LANGUAGE_KHAKASS = Language (#const KBTS_LANGUAGE_KHAKASS)

pattern LANGUAGE_KHAMTI_SHAN :: Language
pattern LANGUAGE_KHAMTI_SHAN = Language (#const KBTS_LANGUAGE_KHAMTI_SHAN)

pattern LANGUAGE_KHAMYANG :: Language
pattern LANGUAGE_KHAMYANG = Language (#const KBTS_LANGUAGE_KHAMYANG)

pattern LANGUAGE_KHANTY_KAZIM :: Language
pattern LANGUAGE_KHANTY_KAZIM = Language (#const KBTS_LANGUAGE_KHANTY_KAZIM)

pattern LANGUAGE_KHANTY_SHURISHKAR :: Language
pattern LANGUAGE_KHANTY_SHURISHKAR = Language (#const KBTS_LANGUAGE_KHANTY_SHURISHKAR)

pattern LANGUAGE_KHANTY_VAKHI :: Language
pattern LANGUAGE_KHANTY_VAKHI = Language (#const KBTS_LANGUAGE_KHANTY_VAKHI)

pattern LANGUAGE_KHASI :: Language
pattern LANGUAGE_KHASI = Language (#const KBTS_LANGUAGE_KHASI)

pattern LANGUAGE_KHENGKHA :: Language
pattern LANGUAGE_KHENGKHA = Language (#const KBTS_LANGUAGE_KHENGKHA)

pattern LANGUAGE_KHINALUG :: Language
pattern LANGUAGE_KHINALUG = Language (#const KBTS_LANGUAGE_KHINALUG)

pattern LANGUAGE_KHMER :: Language
pattern LANGUAGE_KHMER = Language (#const KBTS_LANGUAGE_KHMER)

pattern LANGUAGE_KHORASANI_TURKIC :: Language
pattern LANGUAGE_KHORASANI_TURKIC = Language (#const KBTS_LANGUAGE_KHORASANI_TURKIC)

pattern LANGUAGE_KHOWAR :: Language
pattern LANGUAGE_KHOWAR = Language (#const KBTS_LANGUAGE_KHOWAR)

pattern LANGUAGE_KHUTSURI_GEORGIAN :: Language
pattern LANGUAGE_KHUTSURI_GEORGIAN = Language (#const KBTS_LANGUAGE_KHUTSURI_GEORGIAN)

pattern LANGUAGE_KICHE :: Language
pattern LANGUAGE_KICHE = Language (#const KBTS_LANGUAGE_KICHE)

pattern LANGUAGE_KIKONGO :: Language
pattern LANGUAGE_KIKONGO = Language (#const KBTS_LANGUAGE_KIKONGO)

pattern LANGUAGE_KILDIN_SAMI :: Language
pattern LANGUAGE_KILDIN_SAMI = Language (#const KBTS_LANGUAGE_KILDIN_SAMI)

pattern LANGUAGE_KINYARWANDA :: Language
pattern LANGUAGE_KINYARWANDA = Language (#const KBTS_LANGUAGE_KINYARWANDA)

pattern LANGUAGE_KIRMANJKI :: Language
pattern LANGUAGE_KIRMANJKI = Language (#const KBTS_LANGUAGE_KIRMANJKI)

pattern LANGUAGE_KISII :: Language
pattern LANGUAGE_KISII = Language (#const KBTS_LANGUAGE_KISII)

pattern LANGUAGE_KITUBA :: Language
pattern LANGUAGE_KITUBA = Language (#const KBTS_LANGUAGE_KITUBA)

pattern LANGUAGE_KODAGU :: Language
pattern LANGUAGE_KODAGU = Language (#const KBTS_LANGUAGE_KODAGU)

pattern LANGUAGE_KOKNI :: Language
pattern LANGUAGE_KOKNI = Language (#const KBTS_LANGUAGE_KOKNI)

pattern LANGUAGE_KOMI :: Language
pattern LANGUAGE_KOMI = Language (#const KBTS_LANGUAGE_KOMI)

pattern LANGUAGE_KOMI_PERMYAK :: Language
pattern LANGUAGE_KOMI_PERMYAK = Language (#const KBTS_LANGUAGE_KOMI_PERMYAK)

pattern LANGUAGE_KOMI_ZYRIAN :: Language
pattern LANGUAGE_KOMI_ZYRIAN = Language (#const KBTS_LANGUAGE_KOMI_ZYRIAN)

pattern LANGUAGE_KOMO :: Language
pattern LANGUAGE_KOMO = Language (#const KBTS_LANGUAGE_KOMO)

pattern LANGUAGE_KOMSO :: Language
pattern LANGUAGE_KOMSO = Language (#const KBTS_LANGUAGE_KOMSO)

pattern LANGUAGE_KONGO :: Language
pattern LANGUAGE_KONGO = Language (#const KBTS_LANGUAGE_KONGO)

pattern LANGUAGE_KONKANI :: Language
pattern LANGUAGE_KONKANI = Language (#const KBTS_LANGUAGE_KONKANI)

pattern LANGUAGE_KOORETE :: Language
pattern LANGUAGE_KOORETE = Language (#const KBTS_LANGUAGE_KOORETE)

pattern LANGUAGE_KOREAN :: Language
pattern LANGUAGE_KOREAN = Language (#const KBTS_LANGUAGE_KOREAN)

pattern LANGUAGE_KOREAO_OLD_HANGUL :: Language
pattern LANGUAGE_KOREAO_OLD_HANGUL = Language (#const KBTS_LANGUAGE_KOREAO_OLD_HANGUL)

pattern LANGUAGE_KORYAK :: Language
pattern LANGUAGE_KORYAK = Language (#const KBTS_LANGUAGE_KORYAK)

pattern LANGUAGE_KOSRAEAN :: Language
pattern LANGUAGE_KOSRAEAN = Language (#const KBTS_LANGUAGE_KOSRAEAN)

pattern LANGUAGE_KPELLE :: Language
pattern LANGUAGE_KPELLE = Language (#const KBTS_LANGUAGE_KPELLE)

pattern LANGUAGE_KPELLE_LIBERIA :: Language
pattern LANGUAGE_KPELLE_LIBERIA = Language (#const KBTS_LANGUAGE_KPELLE_LIBERIA)

pattern LANGUAGE_KRIO :: Language
pattern LANGUAGE_KRIO = Language (#const KBTS_LANGUAGE_KRIO)

pattern LANGUAGE_KRYMCHAK :: Language
pattern LANGUAGE_KRYMCHAK = Language (#const KBTS_LANGUAGE_KRYMCHAK)

pattern LANGUAGE_KUANYAMA :: Language
pattern LANGUAGE_KUANYAMA = Language (#const KBTS_LANGUAGE_KUANYAMA)

pattern LANGUAGE_KUBE :: Language
pattern LANGUAGE_KUBE = Language (#const KBTS_LANGUAGE_KUBE)

pattern LANGUAGE_KUI :: Language
pattern LANGUAGE_KUI = Language (#const KBTS_LANGUAGE_KUI)

pattern LANGUAGE_KULVI :: Language
pattern LANGUAGE_KULVI = Language (#const KBTS_LANGUAGE_KULVI)

pattern LANGUAGE_KUMAONI :: Language
pattern LANGUAGE_KUMAONI = Language (#const KBTS_LANGUAGE_KUMAONI)

pattern LANGUAGE_KUMYK :: Language
pattern LANGUAGE_KUMYK = Language (#const KBTS_LANGUAGE_KUMYK)

pattern LANGUAGE_KURDISH :: Language
pattern LANGUAGE_KURDISH = Language (#const KBTS_LANGUAGE_KURDISH)

pattern LANGUAGE_KURUKH :: Language
pattern LANGUAGE_KURUKH = Language (#const KBTS_LANGUAGE_KURUKH)

pattern LANGUAGE_KUY :: Language
pattern LANGUAGE_KUY = Language (#const KBTS_LANGUAGE_KUY)

pattern LANGUAGE_KWAKWALA :: Language
pattern LANGUAGE_KWAKWALA = Language (#const KBTS_LANGUAGE_KWAKWALA)

pattern LANGUAGE_KYRGYZ :: Language
pattern LANGUAGE_KYRGYZ = Language (#const KBTS_LANGUAGE_KYRGYZ)

pattern LANGUAGE_L_CREE :: Language
pattern LANGUAGE_L_CREE = Language (#const KBTS_LANGUAGE_L_CREE)

pattern LANGUAGE_LADAKHI :: Language
pattern LANGUAGE_LADAKHI = Language (#const KBTS_LANGUAGE_LADAKHI)

pattern LANGUAGE_LADIN :: Language
pattern LANGUAGE_LADIN = Language (#const KBTS_LANGUAGE_LADIN)

pattern LANGUAGE_LADINO :: Language
pattern LANGUAGE_LADINO = Language (#const KBTS_LANGUAGE_LADINO)

pattern LANGUAGE_LAHULI :: Language
pattern LANGUAGE_LAHULI = Language (#const KBTS_LANGUAGE_LAHULI)

pattern LANGUAGE_LAK :: Language
pattern LANGUAGE_LAK = Language (#const KBTS_LANGUAGE_LAK)

pattern LANGUAGE_LAKI :: Language
pattern LANGUAGE_LAKI = Language (#const KBTS_LANGUAGE_LAKI)

pattern LANGUAGE_LAMBANI :: Language
pattern LANGUAGE_LAMBANI = Language (#const KBTS_LANGUAGE_LAMBANI)

pattern LANGUAGE_LAMPUNG :: Language
pattern LANGUAGE_LAMPUNG = Language (#const KBTS_LANGUAGE_LAMPUNG)

pattern LANGUAGE_LAO :: Language
pattern LANGUAGE_LAO = Language (#const KBTS_LANGUAGE_LAO)

pattern LANGUAGE_LATIN :: Language
pattern LANGUAGE_LATIN = Language (#const KBTS_LANGUAGE_LATIN)

pattern LANGUAGE_LATVIAN :: Language
pattern LANGUAGE_LATVIAN = Language (#const KBTS_LANGUAGE_LATVIAN)

pattern LANGUAGE_LAZ :: Language
pattern LANGUAGE_LAZ = Language (#const KBTS_LANGUAGE_LAZ)

pattern LANGUAGE_LELEMI :: Language
pattern LANGUAGE_LELEMI = Language (#const KBTS_LANGUAGE_LELEMI)

pattern LANGUAGE_LEZGI :: Language
pattern LANGUAGE_LEZGI = Language (#const KBTS_LANGUAGE_LEZGI)

pattern LANGUAGE_LIGURIAN :: Language
pattern LANGUAGE_LIGURIAN = Language (#const KBTS_LANGUAGE_LIGURIAN)

pattern LANGUAGE_LIMBU :: Language
pattern LANGUAGE_LIMBU = Language (#const KBTS_LANGUAGE_LIMBU)

pattern LANGUAGE_LIMBURGISH :: Language
pattern LANGUAGE_LIMBURGISH = Language (#const KBTS_LANGUAGE_LIMBURGISH)

pattern LANGUAGE_LINGALA :: Language
pattern LANGUAGE_LINGALA = Language (#const KBTS_LANGUAGE_LINGALA)

pattern LANGUAGE_LIPO :: Language
pattern LANGUAGE_LIPO = Language (#const KBTS_LANGUAGE_LIPO)

pattern LANGUAGE_LISU :: Language
pattern LANGUAGE_LISU = Language (#const KBTS_LANGUAGE_LISU)

pattern LANGUAGE_LITHUANIAN :: Language
pattern LANGUAGE_LITHUANIAN = Language (#const KBTS_LANGUAGE_LITHUANIAN)

pattern LANGUAGE_LIV :: Language
pattern LANGUAGE_LIV = Language (#const KBTS_LANGUAGE_LIV)

pattern LANGUAGE_LOJBAN :: Language
pattern LANGUAGE_LOJBAN = Language (#const KBTS_LANGUAGE_LOJBAN)

pattern LANGUAGE_LOMA :: Language
pattern LANGUAGE_LOMA = Language (#const KBTS_LANGUAGE_LOMA)

pattern LANGUAGE_LOMBARD :: Language
pattern LANGUAGE_LOMBARD = Language (#const KBTS_LANGUAGE_LOMBARD)

pattern LANGUAGE_LOMWE :: Language
pattern LANGUAGE_LOMWE = Language (#const KBTS_LANGUAGE_LOMWE)

pattern LANGUAGE_LOW_MARI :: Language
pattern LANGUAGE_LOW_MARI = Language (#const KBTS_LANGUAGE_LOW_MARI)

pattern LANGUAGE_LOW_SAXON :: Language
pattern LANGUAGE_LOW_SAXON = Language (#const KBTS_LANGUAGE_LOW_SAXON)

pattern LANGUAGE_LOWER_SORBIAN :: Language
pattern LANGUAGE_LOWER_SORBIAN = Language (#const KBTS_LANGUAGE_LOWER_SORBIAN)

pattern LANGUAGE_LU :: Language
pattern LANGUAGE_LU = Language (#const KBTS_LANGUAGE_LU)

pattern LANGUAGE_LUBA_KATANGA :: Language
pattern LANGUAGE_LUBA_KATANGA = Language (#const KBTS_LANGUAGE_LUBA_KATANGA)

pattern LANGUAGE_LUBA_LULUA :: Language
pattern LANGUAGE_LUBA_LULUA = Language (#const KBTS_LANGUAGE_LUBA_LULUA)

pattern LANGUAGE_LULE_SAMI :: Language
pattern LANGUAGE_LULE_SAMI = Language (#const KBTS_LANGUAGE_LULE_SAMI)

pattern LANGUAGE_LUO :: Language
pattern LANGUAGE_LUO = Language (#const KBTS_LANGUAGE_LUO)

pattern LANGUAGE_LURI :: Language
pattern LANGUAGE_LURI = Language (#const KBTS_LANGUAGE_LURI)

pattern LANGUAGE_LUSHOOTSEED :: Language
pattern LANGUAGE_LUSHOOTSEED = Language (#const KBTS_LANGUAGE_LUSHOOTSEED)

pattern LANGUAGE_LUXEMBOURGISH :: Language
pattern LANGUAGE_LUXEMBOURGISH = Language (#const KBTS_LANGUAGE_LUXEMBOURGISH)

pattern LANGUAGE_LUYIA :: Language
pattern LANGUAGE_LUYIA = Language (#const KBTS_LANGUAGE_LUYIA)

pattern LANGUAGE_MACEDONIAN :: Language
pattern LANGUAGE_MACEDONIAN = Language (#const KBTS_LANGUAGE_MACEDONIAN)

pattern LANGUAGE_MADURA :: Language
pattern LANGUAGE_MADURA = Language (#const KBTS_LANGUAGE_MADURA)

pattern LANGUAGE_MAGAHI :: Language
pattern LANGUAGE_MAGAHI = Language (#const KBTS_LANGUAGE_MAGAHI)

pattern LANGUAGE_MAITHILI :: Language
pattern LANGUAGE_MAITHILI = Language (#const KBTS_LANGUAGE_MAITHILI)

pattern LANGUAGE_MAJANG :: Language
pattern LANGUAGE_MAJANG = Language (#const KBTS_LANGUAGE_MAJANG)

pattern LANGUAGE_MAKASAR :: Language
pattern LANGUAGE_MAKASAR = Language (#const KBTS_LANGUAGE_MAKASAR)

pattern LANGUAGE_MAKHUWA :: Language
pattern LANGUAGE_MAKHUWA = Language (#const KBTS_LANGUAGE_MAKHUWA)

pattern LANGUAGE_MAKONDE :: Language
pattern LANGUAGE_MAKONDE = Language (#const KBTS_LANGUAGE_MAKONDE)

pattern LANGUAGE_MALAGASY :: Language
pattern LANGUAGE_MALAGASY = Language (#const KBTS_LANGUAGE_MALAGASY)

pattern LANGUAGE_MALAY :: Language
pattern LANGUAGE_MALAY = Language (#const KBTS_LANGUAGE_MALAY)

pattern LANGUAGE_MALAYALAM :: Language
pattern LANGUAGE_MALAYALAM = Language (#const KBTS_LANGUAGE_MALAYALAM)

pattern LANGUAGE_MALAYALAM_REFORMED :: Language
pattern LANGUAGE_MALAYALAM_REFORMED = Language (#const KBTS_LANGUAGE_MALAYALAM_REFORMED)

pattern LANGUAGE_MALE :: Language
pattern LANGUAGE_MALE = Language (#const KBTS_LANGUAGE_MALE)

pattern LANGUAGE_MALINKE :: Language
pattern LANGUAGE_MALINKE = Language (#const KBTS_LANGUAGE_MALINKE)

pattern LANGUAGE_MALTESE :: Language
pattern LANGUAGE_MALTESE = Language (#const KBTS_LANGUAGE_MALTESE)

pattern LANGUAGE_MAM :: Language
pattern LANGUAGE_MAM = Language (#const KBTS_LANGUAGE_MAM)

pattern LANGUAGE_MANCHU :: Language
pattern LANGUAGE_MANCHU = Language (#const KBTS_LANGUAGE_MANCHU)

pattern LANGUAGE_MANDAR :: Language
pattern LANGUAGE_MANDAR = Language (#const KBTS_LANGUAGE_MANDAR)

pattern LANGUAGE_MANDINKA :: Language
pattern LANGUAGE_MANDINKA = Language (#const KBTS_LANGUAGE_MANDINKA)

pattern LANGUAGE_MANINKA :: Language
pattern LANGUAGE_MANINKA = Language (#const KBTS_LANGUAGE_MANINKA)

pattern LANGUAGE_MANIPURI :: Language
pattern LANGUAGE_MANIPURI = Language (#const KBTS_LANGUAGE_MANIPURI)

pattern LANGUAGE_MANO :: Language
pattern LANGUAGE_MANO = Language (#const KBTS_LANGUAGE_MANO)

pattern LANGUAGE_MANSI :: Language
pattern LANGUAGE_MANSI = Language (#const KBTS_LANGUAGE_MANSI)

pattern LANGUAGE_MANX :: Language
pattern LANGUAGE_MANX = Language (#const KBTS_LANGUAGE_MANX)

pattern LANGUAGE_MAORI :: Language
pattern LANGUAGE_MAORI = Language (#const KBTS_LANGUAGE_MAORI)

pattern LANGUAGE_MAPUDUNGUN :: Language
pattern LANGUAGE_MAPUDUNGUN = Language (#const KBTS_LANGUAGE_MAPUDUNGUN)

pattern LANGUAGE_MARATHI :: Language
pattern LANGUAGE_MARATHI = Language (#const KBTS_LANGUAGE_MARATHI)

pattern LANGUAGE_MARSHALLESE :: Language
pattern LANGUAGE_MARSHALLESE = Language (#const KBTS_LANGUAGE_MARSHALLESE)

pattern LANGUAGE_MARWARI :: Language
pattern LANGUAGE_MARWARI = Language (#const KBTS_LANGUAGE_MARWARI)

pattern LANGUAGE_MAYAN :: Language
pattern LANGUAGE_MAYAN = Language (#const KBTS_LANGUAGE_MAYAN)

pattern LANGUAGE_MAZANDERANI :: Language
pattern LANGUAGE_MAZANDERANI = Language (#const KBTS_LANGUAGE_MAZANDERANI)

pattern LANGUAGE_MBEMBE_TIGON :: Language
pattern LANGUAGE_MBEMBE_TIGON = Language (#const KBTS_LANGUAGE_MBEMBE_TIGON)

pattern LANGUAGE_MBO :: Language
pattern LANGUAGE_MBO = Language (#const KBTS_LANGUAGE_MBO)

pattern LANGUAGE_MBUNDU :: Language
pattern LANGUAGE_MBUNDU = Language (#const KBTS_LANGUAGE_MBUNDU)

pattern LANGUAGE_MEDUMBA :: Language
pattern LANGUAGE_MEDUMBA = Language (#const KBTS_LANGUAGE_MEDUMBA)

pattern LANGUAGE_MEEN :: Language
pattern LANGUAGE_MEEN = Language (#const KBTS_LANGUAGE_MEEN)

pattern LANGUAGE_MENDE :: Language
pattern LANGUAGE_MENDE = Language (#const KBTS_LANGUAGE_MENDE)

pattern LANGUAGE_MERU :: Language
pattern LANGUAGE_MERU = Language (#const KBTS_LANGUAGE_MERU)

pattern LANGUAGE_MEWATI :: Language
pattern LANGUAGE_MEWATI = Language (#const KBTS_LANGUAGE_MEWATI)

pattern LANGUAGE_MINANGKABAU :: Language
pattern LANGUAGE_MINANGKABAU = Language (#const KBTS_LANGUAGE_MINANGKABAU)

pattern LANGUAGE_MINJANGBAL :: Language
pattern LANGUAGE_MINJANGBAL = Language (#const KBTS_LANGUAGE_MINJANGBAL)

pattern LANGUAGE_MIRANDESE :: Language
pattern LANGUAGE_MIRANDESE = Language (#const KBTS_LANGUAGE_MIRANDESE)

pattern LANGUAGE_MIZO :: Language
pattern LANGUAGE_MIZO = Language (#const KBTS_LANGUAGE_MIZO)

pattern LANGUAGE_MOHAWK :: Language
pattern LANGUAGE_MOHAWK = Language (#const KBTS_LANGUAGE_MOHAWK)

pattern LANGUAGE_MOKSHA :: Language
pattern LANGUAGE_MOKSHA = Language (#const KBTS_LANGUAGE_MOKSHA)

pattern LANGUAGE_MOLDAVIAN :: Language
pattern LANGUAGE_MOLDAVIAN = Language (#const KBTS_LANGUAGE_MOLDAVIAN)

pattern LANGUAGE_MON :: Language
pattern LANGUAGE_MON = Language (#const KBTS_LANGUAGE_MON)

pattern LANGUAGE_MONGOLIAN :: Language
pattern LANGUAGE_MONGOLIAN = Language (#const KBTS_LANGUAGE_MONGOLIAN)

pattern LANGUAGE_MOOSE_CREE :: Language
pattern LANGUAGE_MOOSE_CREE = Language (#const KBTS_LANGUAGE_MOOSE_CREE)

pattern LANGUAGE_MORISYEN :: Language
pattern LANGUAGE_MORISYEN = Language (#const KBTS_LANGUAGE_MORISYEN)

pattern LANGUAGE_MOROCCAN :: Language
pattern LANGUAGE_MOROCCAN = Language (#const KBTS_LANGUAGE_MOROCCAN)

pattern LANGUAGE_MOSSI :: Language
pattern LANGUAGE_MOSSI = Language (#const KBTS_LANGUAGE_MOSSI)

pattern LANGUAGE_MUNDARI :: Language
pattern LANGUAGE_MUNDARI = Language (#const KBTS_LANGUAGE_MUNDARI)

pattern LANGUAGE_MUSCOGEE :: Language
pattern LANGUAGE_MUSCOGEE = Language (#const KBTS_LANGUAGE_MUSCOGEE)

pattern LANGUAGE_N_CREE :: Language
pattern LANGUAGE_N_CREE = Language (#const KBTS_LANGUAGE_N_CREE)

pattern LANGUAGE_NAGA_ASSAMESE :: Language
pattern LANGUAGE_NAGA_ASSAMESE = Language (#const KBTS_LANGUAGE_NAGA_ASSAMESE)

pattern LANGUAGE_NAGARI :: Language
pattern LANGUAGE_NAGARI = Language (#const KBTS_LANGUAGE_NAGARI)

pattern LANGUAGE_NAHUATL :: Language
pattern LANGUAGE_NAHUATL = Language (#const KBTS_LANGUAGE_NAHUATL)

pattern LANGUAGE_NANAI :: Language
pattern LANGUAGE_NANAI = Language (#const KBTS_LANGUAGE_NANAI)

pattern LANGUAGE_NASKAPI :: Language
pattern LANGUAGE_NASKAPI = Language (#const KBTS_LANGUAGE_NASKAPI)

pattern LANGUAGE_NAURUAN :: Language
pattern LANGUAGE_NAURUAN = Language (#const KBTS_LANGUAGE_NAURUAN)

pattern LANGUAGE_NAVAJO :: Language
pattern LANGUAGE_NAVAJO = Language (#const KBTS_LANGUAGE_NAVAJO)

pattern LANGUAGE_NDAU :: Language
pattern LANGUAGE_NDAU = Language (#const KBTS_LANGUAGE_NDAU)

pattern LANGUAGE_NDEBELE :: Language
pattern LANGUAGE_NDEBELE = Language (#const KBTS_LANGUAGE_NDEBELE)

pattern LANGUAGE_NDONGA :: Language
pattern LANGUAGE_NDONGA = Language (#const KBTS_LANGUAGE_NDONGA)

pattern LANGUAGE_NEAPOLITAN :: Language
pattern LANGUAGE_NEAPOLITAN = Language (#const KBTS_LANGUAGE_NEAPOLITAN)

pattern LANGUAGE_NEPALI :: Language
pattern LANGUAGE_NEPALI = Language (#const KBTS_LANGUAGE_NEPALI)

pattern LANGUAGE_NEWARI :: Language
pattern LANGUAGE_NEWARI = Language (#const KBTS_LANGUAGE_NEWARI)

pattern LANGUAGE_NGBAKA :: Language
pattern LANGUAGE_NGBAKA = Language (#const KBTS_LANGUAGE_NGBAKA)

pattern LANGUAGE_NIGERIAN_FULFULDE :: Language
pattern LANGUAGE_NIGERIAN_FULFULDE = Language (#const KBTS_LANGUAGE_NIGERIAN_FULFULDE)

pattern LANGUAGE_NIMADI :: Language
pattern LANGUAGE_NIMADI = Language (#const KBTS_LANGUAGE_NIMADI)

pattern LANGUAGE_NISI :: Language
pattern LANGUAGE_NISI = Language (#const KBTS_LANGUAGE_NISI)

pattern LANGUAGE_NIUEAN :: Language
pattern LANGUAGE_NIUEAN = Language (#const KBTS_LANGUAGE_NIUEAN)

pattern LANGUAGE_NKO :: Language
pattern LANGUAGE_NKO = Language (#const KBTS_LANGUAGE_NKO)

pattern LANGUAGE_NOGAI :: Language
pattern LANGUAGE_NOGAI = Language (#const KBTS_LANGUAGE_NOGAI)

pattern LANGUAGE_NORFOLK :: Language
pattern LANGUAGE_NORFOLK = Language (#const KBTS_LANGUAGE_NORFOLK)

pattern LANGUAGE_NORTH_SLAVEY :: Language
pattern LANGUAGE_NORTH_SLAVEY = Language (#const KBTS_LANGUAGE_NORTH_SLAVEY)

pattern LANGUAGE_NORTHERN_EMBERA :: Language
pattern LANGUAGE_NORTHERN_EMBERA = Language (#const KBTS_LANGUAGE_NORTHERN_EMBERA)

pattern LANGUAGE_NORTHERN_SAMI :: Language
pattern LANGUAGE_NORTHERN_SAMI = Language (#const KBTS_LANGUAGE_NORTHERN_SAMI)

pattern LANGUAGE_NORTHERN_SOTHO :: Language
pattern LANGUAGE_NORTHERN_SOTHO = Language (#const KBTS_LANGUAGE_NORTHERN_SOTHO)

pattern LANGUAGE_NORTHERN_TAI :: Language
pattern LANGUAGE_NORTHERN_TAI = Language (#const KBTS_LANGUAGE_NORTHERN_TAI)

pattern LANGUAGE_NORWAY_HOUSE_CREE :: Language
pattern LANGUAGE_NORWAY_HOUSE_CREE = Language (#const KBTS_LANGUAGE_NORWAY_HOUSE_CREE)

pattern LANGUAGE_NORWEGIAN :: Language
pattern LANGUAGE_NORWEGIAN = Language (#const KBTS_LANGUAGE_NORWEGIAN)

pattern LANGUAGE_NORWEGIAN_NYNORSK :: Language
pattern LANGUAGE_NORWEGIAN_NYNORSK = Language (#const KBTS_LANGUAGE_NORWEGIAN_NYNORSK)

pattern LANGUAGE_NOVIAL :: Language
pattern LANGUAGE_NOVIAL = Language (#const KBTS_LANGUAGE_NOVIAL)

pattern LANGUAGE_NUMANGGANG :: Language
pattern LANGUAGE_NUMANGGANG = Language (#const KBTS_LANGUAGE_NUMANGGANG)

pattern LANGUAGE_NUNAVIK_INUKTITUT :: Language
pattern LANGUAGE_NUNAVIK_INUKTITUT = Language (#const KBTS_LANGUAGE_NUNAVIK_INUKTITUT)

pattern LANGUAGE_NUU_CHAH_NULTH :: Language
pattern LANGUAGE_NUU_CHAH_NULTH = Language (#const KBTS_LANGUAGE_NUU_CHAH_NULTH)

pattern LANGUAGE_NYAMWEZI :: Language
pattern LANGUAGE_NYAMWEZI = Language (#const KBTS_LANGUAGE_NYAMWEZI)

pattern LANGUAGE_NYANKOLE :: Language
pattern LANGUAGE_NYANKOLE = Language (#const KBTS_LANGUAGE_NYANKOLE)

pattern LANGUAGE_OCCITAN :: Language
pattern LANGUAGE_OCCITAN = Language (#const KBTS_LANGUAGE_OCCITAN)

pattern LANGUAGE_ODIA :: Language
pattern LANGUAGE_ODIA = Language (#const KBTS_LANGUAGE_ODIA)

pattern LANGUAGE_OJI_CREE :: Language
pattern LANGUAGE_OJI_CREE = Language (#const KBTS_LANGUAGE_OJI_CREE)

pattern LANGUAGE_OJIBWAY :: Language
pattern LANGUAGE_OJIBWAY = Language (#const KBTS_LANGUAGE_OJIBWAY)

pattern LANGUAGE_OLD_IRISH :: Language
pattern LANGUAGE_OLD_IRISH = Language (#const KBTS_LANGUAGE_OLD_IRISH)

pattern LANGUAGE_OLD_JAVANESE :: Language
pattern LANGUAGE_OLD_JAVANESE = Language (#const KBTS_LANGUAGE_OLD_JAVANESE)

pattern LANGUAGE_ONEIDA :: Language
pattern LANGUAGE_ONEIDA = Language (#const KBTS_LANGUAGE_ONEIDA)

pattern LANGUAGE_ONONDAGA :: Language
pattern LANGUAGE_ONONDAGA = Language (#const KBTS_LANGUAGE_ONONDAGA)

pattern LANGUAGE_OROMO :: Language
pattern LANGUAGE_OROMO = Language (#const KBTS_LANGUAGE_OROMO)

pattern LANGUAGE_OSSETIAN :: Language
pattern LANGUAGE_OSSETIAN = Language (#const KBTS_LANGUAGE_OSSETIAN)

pattern LANGUAGE_PA_O_KAREN :: Language
pattern LANGUAGE_PA_O_KAREN = Language (#const KBTS_LANGUAGE_PA_O_KAREN)

pattern LANGUAGE_PALAUAN :: Language
pattern LANGUAGE_PALAUAN = Language (#const KBTS_LANGUAGE_PALAUAN)

pattern LANGUAGE_PALAUNG :: Language
pattern LANGUAGE_PALAUNG = Language (#const KBTS_LANGUAGE_PALAUNG)

pattern LANGUAGE_PALESTINIAN_ARAMAIC :: Language
pattern LANGUAGE_PALESTINIAN_ARAMAIC = Language (#const KBTS_LANGUAGE_PALESTINIAN_ARAMAIC)

pattern LANGUAGE_PALI :: Language
pattern LANGUAGE_PALI = Language (#const KBTS_LANGUAGE_PALI)

pattern LANGUAGE_PALPA :: Language
pattern LANGUAGE_PALPA = Language (#const KBTS_LANGUAGE_PALPA)

pattern LANGUAGE_PAMPANGAN :: Language
pattern LANGUAGE_PAMPANGAN = Language (#const KBTS_LANGUAGE_PAMPANGAN)

pattern LANGUAGE_PANGASINAN :: Language
pattern LANGUAGE_PANGASINAN = Language (#const KBTS_LANGUAGE_PANGASINAN)

pattern LANGUAGE_PAPIAMENTU :: Language
pattern LANGUAGE_PAPIAMENTU = Language (#const KBTS_LANGUAGE_PAPIAMENTU)

pattern LANGUAGE_PASHTO :: Language
pattern LANGUAGE_PASHTO = Language (#const KBTS_LANGUAGE_PASHTO)

pattern LANGUAGE_PATTANI_MALAY :: Language
pattern LANGUAGE_PATTANI_MALAY = Language (#const KBTS_LANGUAGE_PATTANI_MALAY)

pattern LANGUAGE_PENNSYLVANIA_GERMAN :: Language
pattern LANGUAGE_PENNSYLVANIA_GERMAN = Language (#const KBTS_LANGUAGE_PENNSYLVANIA_GERMAN)

pattern LANGUAGE_PERSIAN :: Language
pattern LANGUAGE_PERSIAN = Language (#const KBTS_LANGUAGE_PERSIAN)

pattern LANGUAGE_PHAKE :: Language
pattern LANGUAGE_PHAKE = Language (#const KBTS_LANGUAGE_PHAKE)

pattern LANGUAGE_PICARD :: Language
pattern LANGUAGE_PICARD = Language (#const KBTS_LANGUAGE_PICARD)

pattern LANGUAGE_PIEMONTESE :: Language
pattern LANGUAGE_PIEMONTESE = Language (#const KBTS_LANGUAGE_PIEMONTESE)

pattern LANGUAGE_PILAGA :: Language
pattern LANGUAGE_PILAGA = Language (#const KBTS_LANGUAGE_PILAGA)

pattern LANGUAGE_PITE_SAMI :: Language
pattern LANGUAGE_PITE_SAMI = Language (#const KBTS_LANGUAGE_PITE_SAMI)

pattern LANGUAGE_POCOMCHI :: Language
pattern LANGUAGE_POCOMCHI = Language (#const KBTS_LANGUAGE_POCOMCHI)

pattern LANGUAGE_POHNPEIAN :: Language
pattern LANGUAGE_POHNPEIAN = Language (#const KBTS_LANGUAGE_POHNPEIAN)

pattern LANGUAGE_POLISH :: Language
pattern LANGUAGE_POLISH = Language (#const KBTS_LANGUAGE_POLISH)

pattern LANGUAGE_POLYTONIC_GREEK :: Language
pattern LANGUAGE_POLYTONIC_GREEK = Language (#const KBTS_LANGUAGE_POLYTONIC_GREEK)

pattern LANGUAGE_PORTUGUESE :: Language
pattern LANGUAGE_PORTUGUESE = Language (#const KBTS_LANGUAGE_PORTUGUESE)

pattern LANGUAGE_PROVENCAL :: Language
pattern LANGUAGE_PROVENCAL = Language (#const KBTS_LANGUAGE_PROVENCAL)

pattern LANGUAGE_PUNJABI :: Language
pattern LANGUAGE_PUNJABI = Language (#const KBTS_LANGUAGE_PUNJABI)

pattern LANGUAGE_QUECHUA :: Language
pattern LANGUAGE_QUECHUA = Language (#const KBTS_LANGUAGE_QUECHUA)

pattern LANGUAGE_QUECHUA_BOLIVIA :: Language
pattern LANGUAGE_QUECHUA_BOLIVIA = Language (#const KBTS_LANGUAGE_QUECHUA_BOLIVIA)

pattern LANGUAGE_QUECHUA_ECUADOR :: Language
pattern LANGUAGE_QUECHUA_ECUADOR = Language (#const KBTS_LANGUAGE_QUECHUA_ECUADOR)

pattern LANGUAGE_QUECHUA_PERU :: Language
pattern LANGUAGE_QUECHUA_PERU = Language (#const KBTS_LANGUAGE_QUECHUA_PERU)

pattern LANGUAGE_R_CREE :: Language
pattern LANGUAGE_R_CREE = Language (#const KBTS_LANGUAGE_R_CREE)

pattern LANGUAGE_RAJASTHANI :: Language
pattern LANGUAGE_RAJASTHANI = Language (#const KBTS_LANGUAGE_RAJASTHANI)

pattern LANGUAGE_RAKHINE :: Language
pattern LANGUAGE_RAKHINE = Language (#const KBTS_LANGUAGE_RAKHINE)

pattern LANGUAGE_RAROTONGAN :: Language
pattern LANGUAGE_RAROTONGAN = Language (#const KBTS_LANGUAGE_RAROTONGAN)

pattern LANGUAGE_REJANG :: Language
pattern LANGUAGE_REJANG = Language (#const KBTS_LANGUAGE_REJANG)

pattern LANGUAGE_RIANG :: Language
pattern LANGUAGE_RIANG = Language (#const KBTS_LANGUAGE_RIANG)

pattern LANGUAGE_RIPUARIAN :: Language
pattern LANGUAGE_RIPUARIAN = Language (#const KBTS_LANGUAGE_RIPUARIAN)

pattern LANGUAGE_RITARUNGO :: Language
pattern LANGUAGE_RITARUNGO = Language (#const KBTS_LANGUAGE_RITARUNGO)

pattern LANGUAGE_ROHINGYA :: Language
pattern LANGUAGE_ROHINGYA = Language (#const KBTS_LANGUAGE_ROHINGYA)

pattern LANGUAGE_ROMANIAN :: Language
pattern LANGUAGE_ROMANIAN = Language (#const KBTS_LANGUAGE_ROMANIAN)

pattern LANGUAGE_ROMANSH :: Language
pattern LANGUAGE_ROMANSH = Language (#const KBTS_LANGUAGE_ROMANSH)

pattern LANGUAGE_ROMANY :: Language
pattern LANGUAGE_ROMANY = Language (#const KBTS_LANGUAGE_ROMANY)

pattern LANGUAGE_ROTUMAN :: Language
pattern LANGUAGE_ROTUMAN = Language (#const KBTS_LANGUAGE_ROTUMAN)

pattern LANGUAGE_RUNDI :: Language
pattern LANGUAGE_RUNDI = Language (#const KBTS_LANGUAGE_RUNDI)

pattern LANGUAGE_RUSSIAN :: Language
pattern LANGUAGE_RUSSIAN = Language (#const KBTS_LANGUAGE_RUSSIAN)

pattern LANGUAGE_RUSSIAN_BURIAT :: Language
pattern LANGUAGE_RUSSIAN_BURIAT = Language (#const KBTS_LANGUAGE_RUSSIAN_BURIAT)

pattern LANGUAGE_RUSYN :: Language
pattern LANGUAGE_RUSYN = Language (#const KBTS_LANGUAGE_RUSYN)

pattern LANGUAGE_SADRI :: Language
pattern LANGUAGE_SADRI = Language (#const KBTS_LANGUAGE_SADRI)

pattern LANGUAGE_SAKHA :: Language
pattern LANGUAGE_SAKHA = Language (#const KBTS_LANGUAGE_SAKHA)

pattern LANGUAGE_SAMOAN :: Language
pattern LANGUAGE_SAMOAN = Language (#const KBTS_LANGUAGE_SAMOAN)

pattern LANGUAGE_SAMOGITIAN :: Language
pattern LANGUAGE_SAMOGITIAN = Language (#const KBTS_LANGUAGE_SAMOGITIAN)

pattern LANGUAGE_SAN_BLAS_KUNA :: Language
pattern LANGUAGE_SAN_BLAS_KUNA = Language (#const KBTS_LANGUAGE_SAN_BLAS_KUNA)

pattern LANGUAGE_SANGO :: Language
pattern LANGUAGE_SANGO = Language (#const KBTS_LANGUAGE_SANGO)

pattern LANGUAGE_SANSKRIT :: Language
pattern LANGUAGE_SANSKRIT = Language (#const KBTS_LANGUAGE_SANSKRIT)

pattern LANGUAGE_SANTALI :: Language
pattern LANGUAGE_SANTALI = Language (#const KBTS_LANGUAGE_SANTALI)

pattern LANGUAGE_SARAIKI :: Language
pattern LANGUAGE_SARAIKI = Language (#const KBTS_LANGUAGE_SARAIKI)

pattern LANGUAGE_SARDINIAN :: Language
pattern LANGUAGE_SARDINIAN = Language (#const KBTS_LANGUAGE_SARDINIAN)

pattern LANGUAGE_SASAK :: Language
pattern LANGUAGE_SASAK = Language (#const KBTS_LANGUAGE_SASAK)

pattern LANGUAGE_SATERLAND_FRISIAN :: Language
pattern LANGUAGE_SATERLAND_FRISIAN = Language (#const KBTS_LANGUAGE_SATERLAND_FRISIAN)

pattern LANGUAGE_SAYISI :: Language
pattern LANGUAGE_SAYISI = Language (#const KBTS_LANGUAGE_SAYISI)

pattern LANGUAGE_SCOTS :: Language
pattern LANGUAGE_SCOTS = Language (#const KBTS_LANGUAGE_SCOTS)

pattern LANGUAGE_SCOTTISH_GAELIC :: Language
pattern LANGUAGE_SCOTTISH_GAELIC = Language (#const KBTS_LANGUAGE_SCOTTISH_GAELIC)

pattern LANGUAGE_SEKOTA :: Language
pattern LANGUAGE_SEKOTA = Language (#const KBTS_LANGUAGE_SEKOTA)

pattern LANGUAGE_SELKUP :: Language
pattern LANGUAGE_SELKUP = Language (#const KBTS_LANGUAGE_SELKUP)

pattern LANGUAGE_SENA :: Language
pattern LANGUAGE_SENA = Language (#const KBTS_LANGUAGE_SENA)

pattern LANGUAGE_SENECA :: Language
pattern LANGUAGE_SENECA = Language (#const KBTS_LANGUAGE_SENECA)

pattern LANGUAGE_SERBIAN :: Language
pattern LANGUAGE_SERBIAN = Language (#const KBTS_LANGUAGE_SERBIAN)

pattern LANGUAGE_SERER :: Language
pattern LANGUAGE_SERER = Language (#const KBTS_LANGUAGE_SERER)

pattern LANGUAGE_SGAW_KAREN :: Language
pattern LANGUAGE_SGAW_KAREN = Language (#const KBTS_LANGUAGE_SGAW_KAREN)

pattern LANGUAGE_SHAN :: Language
pattern LANGUAGE_SHAN = Language (#const KBTS_LANGUAGE_SHAN)

pattern LANGUAGE_SHONA :: Language
pattern LANGUAGE_SHONA = Language (#const KBTS_LANGUAGE_SHONA)

pattern LANGUAGE_SIBE :: Language
pattern LANGUAGE_SIBE = Language (#const KBTS_LANGUAGE_SIBE)

pattern LANGUAGE_SICILIAN :: Language
pattern LANGUAGE_SICILIAN = Language (#const KBTS_LANGUAGE_SICILIAN)

pattern LANGUAGE_SIDAMO :: Language
pattern LANGUAGE_SIDAMO = Language (#const KBTS_LANGUAGE_SIDAMO)

pattern LANGUAGE_SILESIAN :: Language
pattern LANGUAGE_SILESIAN = Language (#const KBTS_LANGUAGE_SILESIAN)

pattern LANGUAGE_SILTE_GURAGE :: Language
pattern LANGUAGE_SILTE_GURAGE = Language (#const KBTS_LANGUAGE_SILTE_GURAGE)

pattern LANGUAGE_SINDHI :: Language
pattern LANGUAGE_SINDHI = Language (#const KBTS_LANGUAGE_SINDHI)

pattern LANGUAGE_SINHALA :: Language
pattern LANGUAGE_SINHALA = Language (#const KBTS_LANGUAGE_SINHALA)

pattern LANGUAGE_SKOLT_SAMI :: Language
pattern LANGUAGE_SKOLT_SAMI = Language (#const KBTS_LANGUAGE_SKOLT_SAMI)

pattern LANGUAGE_SLAVEY :: Language
pattern LANGUAGE_SLAVEY = Language (#const KBTS_LANGUAGE_SLAVEY)

pattern LANGUAGE_SLOVAK :: Language
pattern LANGUAGE_SLOVAK = Language (#const KBTS_LANGUAGE_SLOVAK)

pattern LANGUAGE_SLOVENIAN :: Language
pattern LANGUAGE_SLOVENIAN = Language (#const KBTS_LANGUAGE_SLOVENIAN)

pattern LANGUAGE_SMALL_FLOWERY_MIAO :: Language
pattern LANGUAGE_SMALL_FLOWERY_MIAO = Language (#const KBTS_LANGUAGE_SMALL_FLOWERY_MIAO)

pattern LANGUAGE_SODO_GURAGE :: Language
pattern LANGUAGE_SODO_GURAGE = Language (#const KBTS_LANGUAGE_SODO_GURAGE)

pattern LANGUAGE_SOGA :: Language
pattern LANGUAGE_SOGA = Language (#const KBTS_LANGUAGE_SOGA)

pattern LANGUAGE_SOMALI :: Language
pattern LANGUAGE_SOMALI = Language (#const KBTS_LANGUAGE_SOMALI)

pattern LANGUAGE_SONGE :: Language
pattern LANGUAGE_SONGE = Language (#const KBTS_LANGUAGE_SONGE)

pattern LANGUAGE_SONINKE :: Language
pattern LANGUAGE_SONINKE = Language (#const KBTS_LANGUAGE_SONINKE)

pattern LANGUAGE_SOUTH_SLAVEY :: Language
pattern LANGUAGE_SOUTH_SLAVEY = Language (#const KBTS_LANGUAGE_SOUTH_SLAVEY)

pattern LANGUAGE_SOUTHERN_KIWAI :: Language
pattern LANGUAGE_SOUTHERN_KIWAI = Language (#const KBTS_LANGUAGE_SOUTHERN_KIWAI)

pattern LANGUAGE_SOUTHERN_SAMI :: Language
pattern LANGUAGE_SOUTHERN_SAMI = Language (#const KBTS_LANGUAGE_SOUTHERN_SAMI)

pattern LANGUAGE_SOUTHERN_SOTHO :: Language
pattern LANGUAGE_SOUTHERN_SOTHO = Language (#const KBTS_LANGUAGE_SOUTHERN_SOTHO)

pattern LANGUAGE_SPANISH :: Language
pattern LANGUAGE_SPANISH = Language (#const KBTS_LANGUAGE_SPANISH)

pattern LANGUAGE_STANDARD_MOROCCAN_TAMAZIGHT :: Language
pattern LANGUAGE_STANDARD_MOROCCAN_TAMAZIGHT = Language (#const KBTS_LANGUAGE_STANDARD_MOROCCAN_TAMAZIGHT)

pattern LANGUAGE_STRAITS_SALISH :: Language
pattern LANGUAGE_STRAITS_SALISH = Language (#const KBTS_LANGUAGE_STRAITS_SALISH)

pattern LANGUAGE_SUKUMA :: Language
pattern LANGUAGE_SUKUMA = Language (#const KBTS_LANGUAGE_SUKUMA)

pattern LANGUAGE_SUNDANESE :: Language
pattern LANGUAGE_SUNDANESE = Language (#const KBTS_LANGUAGE_SUNDANESE)

pattern LANGUAGE_SURI :: Language
pattern LANGUAGE_SURI = Language (#const KBTS_LANGUAGE_SURI)

pattern LANGUAGE_SUTU :: Language
pattern LANGUAGE_SUTU = Language (#const KBTS_LANGUAGE_SUTU)

pattern LANGUAGE_SVAN :: Language
pattern LANGUAGE_SVAN = Language (#const KBTS_LANGUAGE_SVAN)

pattern LANGUAGE_SWADAYA_ARAMAIC :: Language
pattern LANGUAGE_SWADAYA_ARAMAIC = Language (#const KBTS_LANGUAGE_SWADAYA_ARAMAIC)

pattern LANGUAGE_SWAHILI :: Language
pattern LANGUAGE_SWAHILI = Language (#const KBTS_LANGUAGE_SWAHILI)

pattern LANGUAGE_SWATI :: Language
pattern LANGUAGE_SWATI = Language (#const KBTS_LANGUAGE_SWATI)

pattern LANGUAGE_SWEDISH :: Language
pattern LANGUAGE_SWEDISH = Language (#const KBTS_LANGUAGE_SWEDISH)

pattern LANGUAGE_SYLHETI :: Language
pattern LANGUAGE_SYLHETI = Language (#const KBTS_LANGUAGE_SYLHETI)

pattern LANGUAGE_SYRIAC :: Language
pattern LANGUAGE_SYRIAC = Language (#const KBTS_LANGUAGE_SYRIAC)

pattern LANGUAGE_SYRIAC_EASTERN :: Language
pattern LANGUAGE_SYRIAC_EASTERN = Language (#const KBTS_LANGUAGE_SYRIAC_EASTERN)

pattern LANGUAGE_SYRIAC_ESTRANGELA :: Language
pattern LANGUAGE_SYRIAC_ESTRANGELA = Language (#const KBTS_LANGUAGE_SYRIAC_ESTRANGELA)

pattern LANGUAGE_SYRIAC_WESTERN :: Language
pattern LANGUAGE_SYRIAC_WESTERN = Language (#const KBTS_LANGUAGE_SYRIAC_WESTERN)

pattern LANGUAGE_TABASARAN :: Language
pattern LANGUAGE_TABASARAN = Language (#const KBTS_LANGUAGE_TABASARAN)

pattern LANGUAGE_TACHELHIT :: Language
pattern LANGUAGE_TACHELHIT = Language (#const KBTS_LANGUAGE_TACHELHIT)

pattern LANGUAGE_TAGALOG :: Language
pattern LANGUAGE_TAGALOG = Language (#const KBTS_LANGUAGE_TAGALOG)

pattern LANGUAGE_TAHAGGART_TAMAHAQ :: Language
pattern LANGUAGE_TAHAGGART_TAMAHAQ = Language (#const KBTS_LANGUAGE_TAHAGGART_TAMAHAQ)

pattern LANGUAGE_TAHITIAN :: Language
pattern LANGUAGE_TAHITIAN = Language (#const KBTS_LANGUAGE_TAHITIAN)

pattern LANGUAGE_TAI_LAING :: Language
pattern LANGUAGE_TAI_LAING = Language (#const KBTS_LANGUAGE_TAI_LAING)

pattern LANGUAGE_TAJIKI :: Language
pattern LANGUAGE_TAJIKI = Language (#const KBTS_LANGUAGE_TAJIKI)

pattern LANGUAGE_TALYSH :: Language
pattern LANGUAGE_TALYSH = Language (#const KBTS_LANGUAGE_TALYSH)

pattern LANGUAGE_TAMASHEK :: Language
pattern LANGUAGE_TAMASHEK = Language (#const KBTS_LANGUAGE_TAMASHEK)

pattern LANGUAGE_TAMASHEQ :: Language
pattern LANGUAGE_TAMASHEQ = Language (#const KBTS_LANGUAGE_TAMASHEQ)

pattern LANGUAGE_TAMAZIGHT :: Language
pattern LANGUAGE_TAMAZIGHT = Language (#const KBTS_LANGUAGE_TAMAZIGHT)

pattern LANGUAGE_TAMIL :: Language
pattern LANGUAGE_TAMIL = Language (#const KBTS_LANGUAGE_TAMIL)

pattern LANGUAGE_TARIFIT :: Language
pattern LANGUAGE_TARIFIT = Language (#const KBTS_LANGUAGE_TARIFIT)

pattern LANGUAGE_TATAR :: Language
pattern LANGUAGE_TATAR = Language (#const KBTS_LANGUAGE_TATAR)

pattern LANGUAGE_TAWALLAMMAT_TAMAJAQ :: Language
pattern LANGUAGE_TAWALLAMMAT_TAMAJAQ = Language (#const KBTS_LANGUAGE_TAWALLAMMAT_TAMAJAQ)

pattern LANGUAGE_TAY :: Language
pattern LANGUAGE_TAY = Language (#const KBTS_LANGUAGE_TAY)

pattern LANGUAGE_TAYART_TAMAJEQ :: Language
pattern LANGUAGE_TAYART_TAMAJEQ = Language (#const KBTS_LANGUAGE_TAYART_TAMAJEQ)

pattern LANGUAGE_TELUGU :: Language
pattern LANGUAGE_TELUGU = Language (#const KBTS_LANGUAGE_TELUGU)

pattern LANGUAGE_TEMNE :: Language
pattern LANGUAGE_TEMNE = Language (#const KBTS_LANGUAGE_TEMNE)

pattern LANGUAGE_TETUM :: Language
pattern LANGUAGE_TETUM = Language (#const KBTS_LANGUAGE_TETUM)

pattern LANGUAGE_TH_CREE :: Language
pattern LANGUAGE_TH_CREE = Language (#const KBTS_LANGUAGE_TH_CREE)

pattern LANGUAGE_THAI :: Language
pattern LANGUAGE_THAI = Language (#const KBTS_LANGUAGE_THAI)

pattern LANGUAGE_THAILAND_MON :: Language
pattern LANGUAGE_THAILAND_MON = Language (#const KBTS_LANGUAGE_THAILAND_MON)

pattern LANGUAGE_THOMPSON :: Language
pattern LANGUAGE_THOMPSON = Language (#const KBTS_LANGUAGE_THOMPSON)

pattern LANGUAGE_TIBETAN :: Language
pattern LANGUAGE_TIBETAN = Language (#const KBTS_LANGUAGE_TIBETAN)

pattern LANGUAGE_TIGRE :: Language
pattern LANGUAGE_TIGRE = Language (#const KBTS_LANGUAGE_TIGRE)

pattern LANGUAGE_TIGRINYA :: Language
pattern LANGUAGE_TIGRINYA = Language (#const KBTS_LANGUAGE_TIGRINYA)

pattern LANGUAGE_TIV :: Language
pattern LANGUAGE_TIV = Language (#const KBTS_LANGUAGE_TIV)

pattern LANGUAGE_TLINGIT :: Language
pattern LANGUAGE_TLINGIT = Language (#const KBTS_LANGUAGE_TLINGIT)

pattern LANGUAGE_TOBO :: Language
pattern LANGUAGE_TOBO = Language (#const KBTS_LANGUAGE_TOBO)

pattern LANGUAGE_TODO :: Language
pattern LANGUAGE_TODO = Language (#const KBTS_LANGUAGE_TODO)

pattern LANGUAGE_TOK_PISIN :: Language
pattern LANGUAGE_TOK_PISIN = Language (#const KBTS_LANGUAGE_TOK_PISIN)

pattern LANGUAGE_TOMA :: Language
pattern LANGUAGE_TOMA = Language (#const KBTS_LANGUAGE_TOMA)

pattern LANGUAGE_TONGA :: Language
pattern LANGUAGE_TONGA = Language (#const KBTS_LANGUAGE_TONGA)

pattern LANGUAGE_TONGAN :: Language
pattern LANGUAGE_TONGAN = Language (#const KBTS_LANGUAGE_TONGAN)

pattern LANGUAGE_TORKI :: Language
pattern LANGUAGE_TORKI = Language (#const KBTS_LANGUAGE_TORKI)

pattern LANGUAGE_TSHANGLA :: Language
pattern LANGUAGE_TSHANGLA = Language (#const KBTS_LANGUAGE_TSHANGLA)

pattern LANGUAGE_TSONGA :: Language
pattern LANGUAGE_TSONGA = Language (#const KBTS_LANGUAGE_TSONGA)

pattern LANGUAGE_TSWANA :: Language
pattern LANGUAGE_TSWANA = Language (#const KBTS_LANGUAGE_TSWANA)

pattern LANGUAGE_TULU :: Language
pattern LANGUAGE_TULU = Language (#const KBTS_LANGUAGE_TULU)

pattern LANGUAGE_TUMBUKA :: Language
pattern LANGUAGE_TUMBUKA = Language (#const KBTS_LANGUAGE_TUMBUKA)

pattern LANGUAGE_TUNDRA_ENETS :: Language
pattern LANGUAGE_TUNDRA_ENETS = Language (#const KBTS_LANGUAGE_TUNDRA_ENETS)

pattern LANGUAGE_TURKISH :: Language
pattern LANGUAGE_TURKISH = Language (#const KBTS_LANGUAGE_TURKISH)

pattern LANGUAGE_TURKMEN :: Language
pattern LANGUAGE_TURKMEN = Language (#const KBTS_LANGUAGE_TURKMEN)

pattern LANGUAGE_TUROYO_ARAMAIC :: Language
pattern LANGUAGE_TUROYO_ARAMAIC = Language (#const KBTS_LANGUAGE_TUROYO_ARAMAIC)

pattern LANGUAGE_TUSCARORA :: Language
pattern LANGUAGE_TUSCARORA = Language (#const KBTS_LANGUAGE_TUSCARORA)

pattern LANGUAGE_TUVALU :: Language
pattern LANGUAGE_TUVALU = Language (#const KBTS_LANGUAGE_TUVALU)

pattern LANGUAGE_TUVIN :: Language
pattern LANGUAGE_TUVIN = Language (#const KBTS_LANGUAGE_TUVIN)

pattern LANGUAGE_TWI :: Language
pattern LANGUAGE_TWI = Language (#const KBTS_LANGUAGE_TWI)

pattern LANGUAGE_TZOTZIL :: Language
pattern LANGUAGE_TZOTZIL = Language (#const KBTS_LANGUAGE_TZOTZIL)

pattern LANGUAGE_UDI :: Language
pattern LANGUAGE_UDI = Language (#const KBTS_LANGUAGE_UDI)

pattern LANGUAGE_UDMURT :: Language
pattern LANGUAGE_UDMURT = Language (#const KBTS_LANGUAGE_UDMURT)

pattern LANGUAGE_UKRAINIAN :: Language
pattern LANGUAGE_UKRAINIAN = Language (#const KBTS_LANGUAGE_UKRAINIAN)

pattern LANGUAGE_UMBUNDU :: Language
pattern LANGUAGE_UMBUNDU = Language (#const KBTS_LANGUAGE_UMBUNDU)

pattern LANGUAGE_UME_SAMI :: Language
pattern LANGUAGE_UME_SAMI = Language (#const KBTS_LANGUAGE_UME_SAMI)

pattern LANGUAGE_UPPER_SAXON :: Language
pattern LANGUAGE_UPPER_SAXON = Language (#const KBTS_LANGUAGE_UPPER_SAXON)

pattern LANGUAGE_UPPER_SORBIAN :: Language
pattern LANGUAGE_UPPER_SORBIAN = Language (#const KBTS_LANGUAGE_UPPER_SORBIAN)

pattern LANGUAGE_URALIC_PHONETIC :: Language
pattern LANGUAGE_URALIC_PHONETIC = Language (#const KBTS_LANGUAGE_URALIC_PHONETIC)

pattern LANGUAGE_URDU :: Language
pattern LANGUAGE_URDU = Language (#const KBTS_LANGUAGE_URDU)

pattern LANGUAGE_UYGHUR :: Language
pattern LANGUAGE_UYGHUR = Language (#const KBTS_LANGUAGE_UYGHUR)

pattern LANGUAGE_UZBEK :: Language
pattern LANGUAGE_UZBEK = Language (#const KBTS_LANGUAGE_UZBEK)

pattern LANGUAGE_VENDA :: Language
pattern LANGUAGE_VENDA = Language (#const KBTS_LANGUAGE_VENDA)

pattern LANGUAGE_VENETIAN :: Language
pattern LANGUAGE_VENETIAN = Language (#const KBTS_LANGUAGE_VENETIAN)

pattern LANGUAGE_VIETNAMESE :: Language
pattern LANGUAGE_VIETNAMESE = Language (#const KBTS_LANGUAGE_VIETNAMESE)

pattern LANGUAGE_VLAX_ROMANI :: Language
pattern LANGUAGE_VLAX_ROMANI = Language (#const KBTS_LANGUAGE_VLAX_ROMANI)

pattern LANGUAGE_VOLAPUK :: Language
pattern LANGUAGE_VOLAPUK = Language (#const KBTS_LANGUAGE_VOLAPUK)

pattern LANGUAGE_VORO :: Language
pattern LANGUAGE_VORO = Language (#const KBTS_LANGUAGE_VORO)

pattern LANGUAGE_WA :: Language
pattern LANGUAGE_WA = Language (#const KBTS_LANGUAGE_WA)

pattern LANGUAGE_WACI_GBE :: Language
pattern LANGUAGE_WACI_GBE = Language (#const KBTS_LANGUAGE_WACI_GBE)

pattern LANGUAGE_WAGDI :: Language
pattern LANGUAGE_WAGDI = Language (#const KBTS_LANGUAGE_WAGDI)

pattern LANGUAGE_WAKHI :: Language
pattern LANGUAGE_WAKHI = Language (#const KBTS_LANGUAGE_WAKHI)

pattern LANGUAGE_WALLOON :: Language
pattern LANGUAGE_WALLOON = Language (#const KBTS_LANGUAGE_WALLOON)

pattern LANGUAGE_WARAY_WARAY :: Language
pattern LANGUAGE_WARAY_WARAY = Language (#const KBTS_LANGUAGE_WARAY_WARAY)

pattern LANGUAGE_WAYANAD_CHETTI :: Language
pattern LANGUAGE_WAYANAD_CHETTI = Language (#const KBTS_LANGUAGE_WAYANAD_CHETTI)

pattern LANGUAGE_WAYUU :: Language
pattern LANGUAGE_WAYUU = Language (#const KBTS_LANGUAGE_WAYUU)

pattern LANGUAGE_WELSH :: Language
pattern LANGUAGE_WELSH = Language (#const KBTS_LANGUAGE_WELSH)

pattern LANGUAGE_WENDAT :: Language
pattern LANGUAGE_WENDAT = Language (#const KBTS_LANGUAGE_WENDAT)

pattern LANGUAGE_WEST_CREE :: Language
pattern LANGUAGE_WEST_CREE = Language (#const KBTS_LANGUAGE_WEST_CREE)

pattern LANGUAGE_WESTERN_CHAM :: Language
pattern LANGUAGE_WESTERN_CHAM = Language (#const KBTS_LANGUAGE_WESTERN_CHAM)

pattern LANGUAGE_WESTERN_KAYAH :: Language
pattern LANGUAGE_WESTERN_KAYAH = Language (#const KBTS_LANGUAGE_WESTERN_KAYAH)

pattern LANGUAGE_WESTERN_PANJABI :: Language
pattern LANGUAGE_WESTERN_PANJABI = Language (#const KBTS_LANGUAGE_WESTERN_PANJABI)

pattern LANGUAGE_WESTERN_PWO_KAREN :: Language
pattern LANGUAGE_WESTERN_PWO_KAREN = Language (#const KBTS_LANGUAGE_WESTERN_PWO_KAREN)

pattern LANGUAGE_WOLOF :: Language
pattern LANGUAGE_WOLOF = Language (#const KBTS_LANGUAGE_WOLOF)

pattern LANGUAGE_WOODS_CREE :: Language
pattern LANGUAGE_WOODS_CREE = Language (#const KBTS_LANGUAGE_WOODS_CREE)

pattern LANGUAGE_WUDING_LUQUAN_YI :: Language
pattern LANGUAGE_WUDING_LUQUAN_YI = Language (#const KBTS_LANGUAGE_WUDING_LUQUAN_YI)

pattern LANGUAGE_WYANDOT :: Language
pattern LANGUAGE_WYANDOT = Language (#const KBTS_LANGUAGE_WYANDOT)

pattern LANGUAGE_XHOSA :: Language
pattern LANGUAGE_XHOSA = Language (#const KBTS_LANGUAGE_XHOSA)

pattern LANGUAGE_Y_CREE :: Language
pattern LANGUAGE_Y_CREE = Language (#const KBTS_LANGUAGE_Y_CREE)

pattern LANGUAGE_YAO :: Language
pattern LANGUAGE_YAO = Language (#const KBTS_LANGUAGE_YAO)

pattern LANGUAGE_YAPESE :: Language
pattern LANGUAGE_YAPESE = Language (#const KBTS_LANGUAGE_YAPESE)

pattern LANGUAGE_YI_CLASSIC :: Language
pattern LANGUAGE_YI_CLASSIC = Language (#const KBTS_LANGUAGE_YI_CLASSIC)

pattern LANGUAGE_YI_MODERN :: Language
pattern LANGUAGE_YI_MODERN = Language (#const KBTS_LANGUAGE_YI_MODERN)

pattern LANGUAGE_YIDDISH :: Language
pattern LANGUAGE_YIDDISH = Language (#const KBTS_LANGUAGE_YIDDISH)

pattern LANGUAGE_YORUBA :: Language
pattern LANGUAGE_YORUBA = Language (#const KBTS_LANGUAGE_YORUBA)

pattern LANGUAGE_ZAMBOANGA_CHAVACANO :: Language
pattern LANGUAGE_ZAMBOANGA_CHAVACANO = Language (#const KBTS_LANGUAGE_ZAMBOANGA_CHAVACANO)

pattern LANGUAGE_ZANDE :: Language
pattern LANGUAGE_ZANDE = Language (#const KBTS_LANGUAGE_ZANDE)

pattern LANGUAGE_ZARMA :: Language
pattern LANGUAGE_ZARMA = Language (#const KBTS_LANGUAGE_ZARMA)

pattern LANGUAGE_ZAZAKI :: Language
pattern LANGUAGE_ZAZAKI = Language (#const KBTS_LANGUAGE_ZAZAKI)

pattern LANGUAGE_ZEALANDIC :: Language
pattern LANGUAGE_ZEALANDIC = Language (#const KBTS_LANGUAGE_ZEALANDIC)

pattern LANGUAGE_ZHUANG :: Language
pattern LANGUAGE_ZHUANG = Language (#const KBTS_LANGUAGE_ZHUANG)

pattern LANGUAGE_ZULU :: Language
pattern LANGUAGE_ZULU = Language (#const KBTS_LANGUAGE_ZULU)

languageNames :: Map Language String
languageNames = Map.fromList
  [ (LANGUAGE_DONT_KNOW, "LANGUAGE_DONT_KNOW")
  , (LANGUAGE_A_HMAO, "LANGUAGE_A_HMAO")
  , (LANGUAGE_AARI, "LANGUAGE_AARI")
  , (LANGUAGE_ABAZA, "LANGUAGE_ABAZA")
  , (LANGUAGE_ABKHAZIAN, "LANGUAGE_ABKHAZIAN")
  , (LANGUAGE_ACHI, "LANGUAGE_ACHI")
  , (LANGUAGE_ACHOLI, "LANGUAGE_ACHOLI")
  , (LANGUAGE_ADYGHE, "LANGUAGE_ADYGHE")
  , (LANGUAGE_AFAR, "LANGUAGE_AFAR")
  , (LANGUAGE_AFRIKAANS, "LANGUAGE_AFRIKAANS")
  , (LANGUAGE_AGAW, "LANGUAGE_AGAW")
  , (LANGUAGE_AITON, "LANGUAGE_AITON")
  , (LANGUAGE_AKAN, "LANGUAGE_AKAN")
  , (LANGUAGE_ALBANIAN, "LANGUAGE_ALBANIAN")
  , (LANGUAGE_ALSATIAN, "LANGUAGE_ALSATIAN")
  , (LANGUAGE_ALTAI, "LANGUAGE_ALTAI")
  , (LANGUAGE_ALUO, "LANGUAGE_ALUO")
  , (LANGUAGE_AMERICAN_PHONETIC, "LANGUAGE_AMERICAN_PHONETIC")
  , (LANGUAGE_AMHARIC, "LANGUAGE_AMHARIC")
  , (LANGUAGE_ANGLO_SAXON, "LANGUAGE_ANGLO_SAXON")
  , (LANGUAGE_ARABIC, "LANGUAGE_ARABIC")
  , (LANGUAGE_ARAGONESE, "LANGUAGE_ARAGONESE")
  , (LANGUAGE_ARAKANESE, "LANGUAGE_ARAKANESE")
  , (LANGUAGE_ARAKWAL, "LANGUAGE_ARAKWAL")
  , (LANGUAGE_ARMENIAN, "LANGUAGE_ARMENIAN")
  , (LANGUAGE_ARMENIAN_EAST, "LANGUAGE_ARMENIAN_EAST")
  , (LANGUAGE_AROMANIAN, "LANGUAGE_AROMANIAN")
  , (LANGUAGE_ARPITAN, "LANGUAGE_ARPITAN")
  , (LANGUAGE_ASSAMESE, "LANGUAGE_ASSAMESE")
  , (LANGUAGE_ASTURIAN, "LANGUAGE_ASTURIAN")
  , (LANGUAGE_ATHAPASKAN, "LANGUAGE_ATHAPASKAN")
  , (LANGUAGE_ATSINA, "LANGUAGE_ATSINA")
  , (LANGUAGE_AVAR, "LANGUAGE_AVAR")
  , (LANGUAGE_AVATIME, "LANGUAGE_AVATIME")
  , (LANGUAGE_AWADHI, "LANGUAGE_AWADHI")
  , (LANGUAGE_AYMARA, "LANGUAGE_AYMARA")
  , (LANGUAGE_AZERBAIDJANI, "LANGUAGE_AZERBAIDJANI")
  , (LANGUAGE_BADAGA, "LANGUAGE_BADAGA")
  , (LANGUAGE_BAGHELKHANDI, "LANGUAGE_BAGHELKHANDI")
  , (LANGUAGE_BAGRI, "LANGUAGE_BAGRI")
  , (LANGUAGE_BALANTE, "LANGUAGE_BALANTE")
  , (LANGUAGE_BALINESE, "LANGUAGE_BALINESE")
  , (LANGUAGE_BALKAR, "LANGUAGE_BALKAR")
  , (LANGUAGE_BALTI, "LANGUAGE_BALTI")
  , (LANGUAGE_BALUCHI, "LANGUAGE_BALUCHI")
  , (LANGUAGE_BAMBARA, "LANGUAGE_BAMBARA")
  , (LANGUAGE_BAMILEKE, "LANGUAGE_BAMILEKE")
  , (LANGUAGE_BANDA, "LANGUAGE_BANDA")
  , (LANGUAGE_BANDJALANG, "LANGUAGE_BANDJALANG")
  , (LANGUAGE_BANGLA, "LANGUAGE_BANGLA")
  , (LANGUAGE_BASHKIR, "LANGUAGE_BASHKIR")
  , (LANGUAGE_BASQUE, "LANGUAGE_BASQUE")
  , (LANGUAGE_BATAK, "LANGUAGE_BATAK")
  , (LANGUAGE_BATAK_ALAS_KLUET, "LANGUAGE_BATAK_ALAS_KLUET")
  , (LANGUAGE_BATAK_ANGKOLA, "LANGUAGE_BATAK_ANGKOLA")
  , (LANGUAGE_BATAK_DAIRI, "LANGUAGE_BATAK_DAIRI")
  , (LANGUAGE_BATAK_KARO, "LANGUAGE_BATAK_KARO")
  , (LANGUAGE_BATAK_MANDAILING, "LANGUAGE_BATAK_MANDAILING")
  , (LANGUAGE_BATAK_SIMALUNGUN, "LANGUAGE_BATAK_SIMALUNGUN")
  , (LANGUAGE_BATAK_TOBA, "LANGUAGE_BATAK_TOBA")
  , (LANGUAGE_BAULE, "LANGUAGE_BAULE")
  , (LANGUAGE_BAVARIAN, "LANGUAGE_BAVARIAN")
  , (LANGUAGE_BELARUSIAN, "LANGUAGE_BELARUSIAN")
  , (LANGUAGE_BEMBA, "LANGUAGE_BEMBA")
  , (LANGUAGE_BENCH, "LANGUAGE_BENCH")
  , (LANGUAGE_BERBER, "LANGUAGE_BERBER")
  , (LANGUAGE_BETI, "LANGUAGE_BETI")
  , (LANGUAGE_BETTE_KURUMA, "LANGUAGE_BETTE_KURUMA")
  , (LANGUAGE_BHILI, "LANGUAGE_BHILI")
  , (LANGUAGE_BHOJPURI, "LANGUAGE_BHOJPURI")
  , (LANGUAGE_BHUTANESE, "LANGUAGE_BHUTANESE")
  , (LANGUAGE_BIBLE_CREE, "LANGUAGE_BIBLE_CREE")
  , (LANGUAGE_BIKOL, "LANGUAGE_BIKOL")
  , (LANGUAGE_BILEN, "LANGUAGE_BILEN")
  , (LANGUAGE_BISHNUPRIYA_MANIPURI, "LANGUAGE_BISHNUPRIYA_MANIPURI")
  , (LANGUAGE_BISLAMA, "LANGUAGE_BISLAMA")
  , (LANGUAGE_BLACKFOOT, "LANGUAGE_BLACKFOOT")
  , (LANGUAGE_BODO, "LANGUAGE_BODO")
  , (LANGUAGE_BOSNIAN, "LANGUAGE_BOSNIAN")
  , (LANGUAGE_BOUYEI, "LANGUAGE_BOUYEI")
  , (LANGUAGE_BRAHUI, "LANGUAGE_BRAHUI")
  , (LANGUAGE_BRAJ_BHASHA, "LANGUAGE_BRAJ_BHASHA")
  , (LANGUAGE_BRETON, "LANGUAGE_BRETON")
  , (LANGUAGE_BUGIS, "LANGUAGE_BUGIS")
  , (LANGUAGE_BULGARIAN, "LANGUAGE_BULGARIAN")
  , (LANGUAGE_BUMTHANGKHA, "LANGUAGE_BUMTHANGKHA")
  , (LANGUAGE_BURMESE, "LANGUAGE_BURMESE")
  , (LANGUAGE_BURUSHASKI, "LANGUAGE_BURUSHASKI")
  , (LANGUAGE_CAJUN_FRENCH, "LANGUAGE_CAJUN_FRENCH")
  , (LANGUAGE_CARRIER, "LANGUAGE_CARRIER")
  , (LANGUAGE_CATALAN, "LANGUAGE_CATALAN")
  , (LANGUAGE_CAYUGA, "LANGUAGE_CAYUGA")
  , (LANGUAGE_CEBUANO, "LANGUAGE_CEBUANO")
  , (LANGUAGE_CENTRAL_YUPIK, "LANGUAGE_CENTRAL_YUPIK")
  , (LANGUAGE_CHAHA_GURAGE, "LANGUAGE_CHAHA_GURAGE")
  , (LANGUAGE_CHAMORRO, "LANGUAGE_CHAMORRO")
  , (LANGUAGE_CHATTISGARHI, "LANGUAGE_CHATTISGARHI")
  , (LANGUAGE_CHECHEN, "LANGUAGE_CHECHEN")
  , (LANGUAGE_CHEROKEE, "LANGUAGE_CHEROKEE")
  , (LANGUAGE_CHEYENNE, "LANGUAGE_CHEYENNE")
  , (LANGUAGE_CHICHEWA, "LANGUAGE_CHICHEWA")
  , (LANGUAGE_CHIGA, "LANGUAGE_CHIGA")
  , (LANGUAGE_CHIMILA, "LANGUAGE_CHIMILA")
  , (LANGUAGE_CHIN, "LANGUAGE_CHIN")
  , (LANGUAGE_CHINANTEC, "LANGUAGE_CHINANTEC")
  , (LANGUAGE_CHINESE_PHONETIC, "LANGUAGE_CHINESE_PHONETIC")
  , (LANGUAGE_CHINESE_SIMPLIFIED, "LANGUAGE_CHINESE_SIMPLIFIED")
  , (LANGUAGE_CHINESE_TRADITIONAL, "LANGUAGE_CHINESE_TRADITIONAL")
  , (LANGUAGE_CHINESE_TRADITIONAL_HONG_KONG, "LANGUAGE_CHINESE_TRADITIONAL_HONG_KONG")
  , (LANGUAGE_CHINESE_TRADITIONAL_MACAO, "LANGUAGE_CHINESE_TRADITIONAL_MACAO")
  , (LANGUAGE_CHIPEWYAN, "LANGUAGE_CHIPEWYAN")
  , (LANGUAGE_CHITTAGONIAN, "LANGUAGE_CHITTAGONIAN")
  , (LANGUAGE_CHOCTAW, "LANGUAGE_CHOCTAW")
  , (LANGUAGE_CHUKCHI, "LANGUAGE_CHUKCHI")
  , (LANGUAGE_CHURCH_SLAVONIC, "LANGUAGE_CHURCH_SLAVONIC")
  , (LANGUAGE_CHUUKESE, "LANGUAGE_CHUUKESE")
  , (LANGUAGE_CHUVASH, "LANGUAGE_CHUVASH")
  , (LANGUAGE_COMORIAN, "LANGUAGE_COMORIAN")
  , (LANGUAGE_COMOX, "LANGUAGE_COMOX")
  , (LANGUAGE_COPTIC, "LANGUAGE_COPTIC")
  , (LANGUAGE_CORNISH, "LANGUAGE_CORNISH")
  , (LANGUAGE_CORSICAN, "LANGUAGE_CORSICAN")
  , (LANGUAGE_CREE, "LANGUAGE_CREE")
  , (LANGUAGE_CREOLES, "LANGUAGE_CREOLES")
  , (LANGUAGE_CRIMEAN_TATAR, "LANGUAGE_CRIMEAN_TATAR")
  , (LANGUAGE_CRIOULO, "LANGUAGE_CRIOULO")
  , (LANGUAGE_CROATIAN, "LANGUAGE_CROATIAN")
  , (LANGUAGE_CYPRIOT_ARABIC, "LANGUAGE_CYPRIOT_ARABIC")
  , (LANGUAGE_CZECH, "LANGUAGE_CZECH")
  , (LANGUAGE_DAGBANI, "LANGUAGE_DAGBANI")
  , (LANGUAGE_DAN, "LANGUAGE_DAN")
  , (LANGUAGE_DANGME, "LANGUAGE_DANGME")
  , (LANGUAGE_DANISH, "LANGUAGE_DANISH")
  , (LANGUAGE_DARGWA, "LANGUAGE_DARGWA")
  , (LANGUAGE_DARI, "LANGUAGE_DARI")
  , (LANGUAGE_DAYI, "LANGUAGE_DAYI")
  , (LANGUAGE_DEFAULT, "LANGUAGE_DEFAULT")
  , (LANGUAGE_DEHONG_DAI, "LANGUAGE_DEHONG_DAI")
  , (LANGUAGE_DHANGU, "LANGUAGE_DHANGU")
  , (LANGUAGE_DHIVEHI, "LANGUAGE_DHIVEHI")
  , (LANGUAGE_DHUWAL, "LANGUAGE_DHUWAL")
  , (LANGUAGE_DIMLI, "LANGUAGE_DIMLI")
  , (LANGUAGE_DINKA, "LANGUAGE_DINKA")
  , (LANGUAGE_DIVEHI, "LANGUAGE_DIVEHI")
  , (LANGUAGE_DJAMBARRPUYNGU, "LANGUAGE_DJAMBARRPUYNGU")
  , (LANGUAGE_DOGRI, "LANGUAGE_DOGRI")
  , (LANGUAGE_DOGRI_MACROLANGUAGE, "LANGUAGE_DOGRI_MACROLANGUAGE")
  , (LANGUAGE_DUNGAN, "LANGUAGE_DUNGAN")
  , (LANGUAGE_DUTCH, "LANGUAGE_DUTCH")
  , (LANGUAGE_DZONGKHA, "LANGUAGE_DZONGKHA")
  , (LANGUAGE_EASTERN_ABENAKI, "LANGUAGE_EASTERN_ABENAKI")
  , (LANGUAGE_EASTERN_CHAM, "LANGUAGE_EASTERN_CHAM")
  , (LANGUAGE_EASTERN_CREE, "LANGUAGE_EASTERN_CREE")
  , (LANGUAGE_EASTERN_MANINKAKAN, "LANGUAGE_EASTERN_MANINKAKAN")
  , (LANGUAGE_EASTERN_PWO_KAREN, "LANGUAGE_EASTERN_PWO_KAREN")
  , (LANGUAGE_EBIRA, "LANGUAGE_EBIRA")
  , (LANGUAGE_EDO, "LANGUAGE_EDO")
  , (LANGUAGE_EFIK, "LANGUAGE_EFIK")
  , (LANGUAGE_EMBERA_BAUDO, "LANGUAGE_EMBERA_BAUDO")
  , (LANGUAGE_EMBERA_CATIO, "LANGUAGE_EMBERA_CATIO")
  , (LANGUAGE_EMBERA_CHAMI, "LANGUAGE_EMBERA_CHAMI")
  , (LANGUAGE_EMBERA_TADO, "LANGUAGE_EMBERA_TADO")
  , (LANGUAGE_ENGLISH, "LANGUAGE_ENGLISH")
  , (LANGUAGE_EPENA, "LANGUAGE_EPENA")
  , (LANGUAGE_ERZYA, "LANGUAGE_ERZYA")
  , (LANGUAGE_KB_TEXT_SHAPEANTO, "LANGUAGE_KB_TEXT_SHAPEANTO")
  , (LANGUAGE_ESTONIAN, "LANGUAGE_ESTONIAN")
  , (LANGUAGE_EVEN, "LANGUAGE_EVEN")
  , (LANGUAGE_EVENKI, "LANGUAGE_EVENKI")
  , (LANGUAGE_EWE, "LANGUAGE_EWE")
  , (LANGUAGE_FALAM_CHIN, "LANGUAGE_FALAM_CHIN")
  , (LANGUAGE_FANG, "LANGUAGE_FANG")
  , (LANGUAGE_FANTI, "LANGUAGE_FANTI")
  , (LANGUAGE_FAROESE, "LANGUAGE_FAROESE")
  , (LANGUAGE_FEFE, "LANGUAGE_FEFE")
  , (LANGUAGE_FIJIAN, "LANGUAGE_FIJIAN")
  , (LANGUAGE_FILIPINO, "LANGUAGE_FILIPINO")
  , (LANGUAGE_FINNISH, "LANGUAGE_FINNISH")
  , (LANGUAGE_FLEMISH, "LANGUAGE_FLEMISH")
  , (LANGUAGE_FON, "LANGUAGE_FON")
  , (LANGUAGE_FOREST_ENETS, "LANGUAGE_FOREST_ENETS")
  , (LANGUAGE_FRENCH, "LANGUAGE_FRENCH")
  , (LANGUAGE_FRENCH_ANTILLEAN, "LANGUAGE_FRENCH_ANTILLEAN")
  , (LANGUAGE_FRISIAN, "LANGUAGE_FRISIAN")
  , (LANGUAGE_FRIULIAN, "LANGUAGE_FRIULIAN")
  , (LANGUAGE_FULAH, "LANGUAGE_FULAH")
  , (LANGUAGE_FUTA, "LANGUAGE_FUTA")
  , (LANGUAGE_GA, "LANGUAGE_GA")
  , (LANGUAGE_GAGAUZ, "LANGUAGE_GAGAUZ")
  , (LANGUAGE_GALICIAN, "LANGUAGE_GALICIAN")
  , (LANGUAGE_GANDA, "LANGUAGE_GANDA")
  , (LANGUAGE_GARHWALI, "LANGUAGE_GARHWALI")
  , (LANGUAGE_GARO, "LANGUAGE_GARO")
  , (LANGUAGE_GARSHUNI, "LANGUAGE_GARSHUNI")
  , (LANGUAGE_GEBA_KAREN, "LANGUAGE_GEBA_KAREN")
  , (LANGUAGE_GEEZ, "LANGUAGE_GEEZ")
  , (LANGUAGE_GEORGIAN, "LANGUAGE_GEORGIAN")
  , (LANGUAGE_GEPO, "LANGUAGE_GEPO")
  , (LANGUAGE_GERMAN, "LANGUAGE_GERMAN")
  , (LANGUAGE_GIKUYU, "LANGUAGE_GIKUYU")
  , (LANGUAGE_GILAKI, "LANGUAGE_GILAKI")
  , (LANGUAGE_GILBERTESE, "LANGUAGE_GILBERTESE")
  , (LANGUAGE_GILYAK, "LANGUAGE_GILYAK")
  , (LANGUAGE_GITHABUL, "LANGUAGE_GITHABUL")
  , (LANGUAGE_GOGO, "LANGUAGE_GOGO")
  , (LANGUAGE_GONDI, "LANGUAGE_GONDI")
  , (LANGUAGE_GREEK, "LANGUAGE_GREEK")
  , (LANGUAGE_GREENLANDIC, "LANGUAGE_GREENLANDIC")
  , (LANGUAGE_GUARANI, "LANGUAGE_GUARANI")
  , (LANGUAGE_GUINEA, "LANGUAGE_GUINEA")
  , (LANGUAGE_GUJARATI, "LANGUAGE_GUJARATI")
  , (LANGUAGE_GUMATJ, "LANGUAGE_GUMATJ")
  , (LANGUAGE_GUMUZ, "LANGUAGE_GUMUZ")
  , (LANGUAGE_GUPAPUYNGU, "LANGUAGE_GUPAPUYNGU")
  , (LANGUAGE_GUSII, "LANGUAGE_GUSII")
  , (LANGUAGE_HAIDA, "LANGUAGE_HAIDA")
  , (LANGUAGE_HAITIAN_CREOLE, "LANGUAGE_HAITIAN_CREOLE")
  , (LANGUAGE_HALKOMELEM, "LANGUAGE_HALKOMELEM")
  , (LANGUAGE_HAMMER_BANNA, "LANGUAGE_HAMMER_BANNA")
  , (LANGUAGE_HARARI, "LANGUAGE_HARARI")
  , (LANGUAGE_HARAUTI, "LANGUAGE_HARAUTI")
  , (LANGUAGE_HARYANVI, "LANGUAGE_HARYANVI")
  , (LANGUAGE_HAUSA, "LANGUAGE_HAUSA")
  , (LANGUAGE_HAVASUPAI_WALAPAI_YAVAPAI, "LANGUAGE_HAVASUPAI_WALAPAI_YAVAPAI")
  , (LANGUAGE_HAWAIIAN, "LANGUAGE_HAWAIIAN")
  , (LANGUAGE_HAYA, "LANGUAGE_HAYA")
  , (LANGUAGE_HAZARAGI, "LANGUAGE_HAZARAGI")
  , (LANGUAGE_HEBREW, "LANGUAGE_HEBREW")
  , (LANGUAGE_HEILTSUK, "LANGUAGE_HEILTSUK")
  , (LANGUAGE_HERERO, "LANGUAGE_HERERO")
  , (LANGUAGE_HIGH_MARI, "LANGUAGE_HIGH_MARI")
  , (LANGUAGE_HILIGAYNON, "LANGUAGE_HILIGAYNON")
  , (LANGUAGE_HINDI, "LANGUAGE_HINDI")
  , (LANGUAGE_HINDKO, "LANGUAGE_HINDKO")
  , (LANGUAGE_HIRI_MOTU, "LANGUAGE_HIRI_MOTU")
  , (LANGUAGE_HMONG, "LANGUAGE_HMONG")
  , (LANGUAGE_HMONG_DAW, "LANGUAGE_HMONG_DAW")
  , (LANGUAGE_HMONG_SHUAT, "LANGUAGE_HMONG_SHUAT")
  , (LANGUAGE_HO, "LANGUAGE_HO")
  , (LANGUAGE_HUNGARIAN, "LANGUAGE_HUNGARIAN")
  , (LANGUAGE_IBAN, "LANGUAGE_IBAN")
  , (LANGUAGE_IBIBIO, "LANGUAGE_IBIBIO")
  , (LANGUAGE_ICELANDIC, "LANGUAGE_ICELANDIC")
  , (LANGUAGE_IDO, "LANGUAGE_IDO")
  , (LANGUAGE_IGBO, "LANGUAGE_IGBO")
  , (LANGUAGE_IJO, "LANGUAGE_IJO")
  , (LANGUAGE_ILOKANO, "LANGUAGE_ILOKANO")
  , (LANGUAGE_INARI_SAMI, "LANGUAGE_INARI_SAMI")
  , (LANGUAGE_INDONESIAN, "LANGUAGE_INDONESIAN")
  , (LANGUAGE_INGUSH, "LANGUAGE_INGUSH")
  , (LANGUAGE_INTERLINGUA, "LANGUAGE_INTERLINGUA")
  , (LANGUAGE_INTERLINGUE, "LANGUAGE_INTERLINGUE")
  , (LANGUAGE_INUKTITUT, "LANGUAGE_INUKTITUT")
  , (LANGUAGE_INUPIAT, "LANGUAGE_INUPIAT")
  , (LANGUAGE_IPA_PHONETIC, "LANGUAGE_IPA_PHONETIC")
  , (LANGUAGE_IRISH, "LANGUAGE_IRISH")
  , (LANGUAGE_IRISH_TRADITIONAL, "LANGUAGE_IRISH_TRADITIONAL")
  , (LANGUAGE_IRULA, "LANGUAGE_IRULA")
  , (LANGUAGE_ITALIAN, "LANGUAGE_ITALIAN")
  , (LANGUAGE_JAMAICAN_CREOLE, "LANGUAGE_JAMAICAN_CREOLE")
  , (LANGUAGE_JAPANESE, "LANGUAGE_JAPANESE")
  , (LANGUAGE_JAVANESE, "LANGUAGE_JAVANESE")
  , (LANGUAGE_JENNU_KURUMA, "LANGUAGE_JENNU_KURUMA")
  , (LANGUAGE_JUDEO_TAT, "LANGUAGE_JUDEO_TAT")
  , (LANGUAGE_JULA, "LANGUAGE_JULA")
  , (LANGUAGE_KABARDIAN, "LANGUAGE_KABARDIAN")
  , (LANGUAGE_KABYLE, "LANGUAGE_KABYLE")
  , (LANGUAGE_KACHCHI, "LANGUAGE_KACHCHI")
  , (LANGUAGE_KADIWEU, "LANGUAGE_KADIWEU")
  , (LANGUAGE_KALENJIN, "LANGUAGE_KALENJIN")
  , (LANGUAGE_KALMYK, "LANGUAGE_KALMYK")
  , (LANGUAGE_KAMBA, "LANGUAGE_KAMBA")
  , (LANGUAGE_KANAUJI, "LANGUAGE_KANAUJI")
  , (LANGUAGE_KANNADA, "LANGUAGE_KANNADA")
  , (LANGUAGE_KANURI, "LANGUAGE_KANURI")
  , (LANGUAGE_KAQCHIKEL, "LANGUAGE_KAQCHIKEL")
  , (LANGUAGE_KARACHAY, "LANGUAGE_KARACHAY")
  , (LANGUAGE_KARAIM, "LANGUAGE_KARAIM")
  , (LANGUAGE_KARAKALPAK, "LANGUAGE_KARAKALPAK")
  , (LANGUAGE_KARELIAN, "LANGUAGE_KARELIAN")
  , (LANGUAGE_KAREN, "LANGUAGE_KAREN")
  , (LANGUAGE_KASHMIRI, "LANGUAGE_KASHMIRI")
  , (LANGUAGE_KASHUBIAN, "LANGUAGE_KASHUBIAN")
  , (LANGUAGE_KATE, "LANGUAGE_KATE")
  , (LANGUAGE_KAZAKH, "LANGUAGE_KAZAKH")
  , (LANGUAGE_KEBENA, "LANGUAGE_KEBENA")
  , (LANGUAGE_KEKCHI, "LANGUAGE_KEKCHI")
  , (LANGUAGE_KHAKASS, "LANGUAGE_KHAKASS")
  , (LANGUAGE_KHAMTI_SHAN, "LANGUAGE_KHAMTI_SHAN")
  , (LANGUAGE_KHAMYANG, "LANGUAGE_KHAMYANG")
  , (LANGUAGE_KHANTY_KAZIM, "LANGUAGE_KHANTY_KAZIM")
  , (LANGUAGE_KHANTY_SHURISHKAR, "LANGUAGE_KHANTY_SHURISHKAR")
  , (LANGUAGE_KHANTY_VAKHI, "LANGUAGE_KHANTY_VAKHI")
  , (LANGUAGE_KHASI, "LANGUAGE_KHASI")
  , (LANGUAGE_KHENGKHA, "LANGUAGE_KHENGKHA")
  , (LANGUAGE_KHINALUG, "LANGUAGE_KHINALUG")
  , (LANGUAGE_KHMER, "LANGUAGE_KHMER")
  , (LANGUAGE_KHORASANI_TURKIC, "LANGUAGE_KHORASANI_TURKIC")
  , (LANGUAGE_KHOWAR, "LANGUAGE_KHOWAR")
  , (LANGUAGE_KHUTSURI_GEORGIAN, "LANGUAGE_KHUTSURI_GEORGIAN")
  , (LANGUAGE_KICHE, "LANGUAGE_KICHE")
  , (LANGUAGE_KIKONGO, "LANGUAGE_KIKONGO")
  , (LANGUAGE_KILDIN_SAMI, "LANGUAGE_KILDIN_SAMI")
  , (LANGUAGE_KINYARWANDA, "LANGUAGE_KINYARWANDA")
  , (LANGUAGE_KIRMANJKI, "LANGUAGE_KIRMANJKI")
  , (LANGUAGE_KISII, "LANGUAGE_KISII")
  , (LANGUAGE_KITUBA, "LANGUAGE_KITUBA")
  , (LANGUAGE_KODAGU, "LANGUAGE_KODAGU")
  , (LANGUAGE_KOKNI, "LANGUAGE_KOKNI")
  , (LANGUAGE_KOMI, "LANGUAGE_KOMI")
  , (LANGUAGE_KOMI_PERMYAK, "LANGUAGE_KOMI_PERMYAK")
  , (LANGUAGE_KOMI_ZYRIAN, "LANGUAGE_KOMI_ZYRIAN")
  , (LANGUAGE_KOMO, "LANGUAGE_KOMO")
  , (LANGUAGE_KOMSO, "LANGUAGE_KOMSO")
  , (LANGUAGE_KONGO, "LANGUAGE_KONGO")
  , (LANGUAGE_KONKANI, "LANGUAGE_KONKANI")
  , (LANGUAGE_KOORETE, "LANGUAGE_KOORETE")
  , (LANGUAGE_KOREAN, "LANGUAGE_KOREAN")
  , (LANGUAGE_KOREAO_OLD_HANGUL, "LANGUAGE_KOREAO_OLD_HANGUL")
  , (LANGUAGE_KORYAK, "LANGUAGE_KORYAK")
  , (LANGUAGE_KOSRAEAN, "LANGUAGE_KOSRAEAN")
  , (LANGUAGE_KPELLE, "LANGUAGE_KPELLE")
  , (LANGUAGE_KPELLE_LIBERIA, "LANGUAGE_KPELLE_LIBERIA")
  , (LANGUAGE_KRIO, "LANGUAGE_KRIO")
  , (LANGUAGE_KRYMCHAK, "LANGUAGE_KRYMCHAK")
  , (LANGUAGE_KUANYAMA, "LANGUAGE_KUANYAMA")
  , (LANGUAGE_KUBE, "LANGUAGE_KUBE")
  , (LANGUAGE_KUI, "LANGUAGE_KUI")
  , (LANGUAGE_KULVI, "LANGUAGE_KULVI")
  , (LANGUAGE_KUMAONI, "LANGUAGE_KUMAONI")
  , (LANGUAGE_KUMYK, "LANGUAGE_KUMYK")
  , (LANGUAGE_KURDISH, "LANGUAGE_KURDISH")
  , (LANGUAGE_KURUKH, "LANGUAGE_KURUKH")
  , (LANGUAGE_KUY, "LANGUAGE_KUY")
  , (LANGUAGE_KWAKWALA, "LANGUAGE_KWAKWALA")
  , (LANGUAGE_KYRGYZ, "LANGUAGE_KYRGYZ")
  , (LANGUAGE_L_CREE, "LANGUAGE_L_CREE")
  , (LANGUAGE_LADAKHI, "LANGUAGE_LADAKHI")
  , (LANGUAGE_LADIN, "LANGUAGE_LADIN")
  , (LANGUAGE_LADINO, "LANGUAGE_LADINO")
  , (LANGUAGE_LAHULI, "LANGUAGE_LAHULI")
  , (LANGUAGE_LAK, "LANGUAGE_LAK")
  , (LANGUAGE_LAKI, "LANGUAGE_LAKI")
  , (LANGUAGE_LAMBANI, "LANGUAGE_LAMBANI")
  , (LANGUAGE_LAMPUNG, "LANGUAGE_LAMPUNG")
  , (LANGUAGE_LAO, "LANGUAGE_LAO")
  , (LANGUAGE_LATIN, "LANGUAGE_LATIN")
  , (LANGUAGE_LATVIAN, "LANGUAGE_LATVIAN")
  , (LANGUAGE_LAZ, "LANGUAGE_LAZ")
  , (LANGUAGE_LELEMI, "LANGUAGE_LELEMI")
  , (LANGUAGE_LEZGI, "LANGUAGE_LEZGI")
  , (LANGUAGE_LIGURIAN, "LANGUAGE_LIGURIAN")
  , (LANGUAGE_LIMBU, "LANGUAGE_LIMBU")
  , (LANGUAGE_LIMBURGISH, "LANGUAGE_LIMBURGISH")
  , (LANGUAGE_LINGALA, "LANGUAGE_LINGALA")
  , (LANGUAGE_LIPO, "LANGUAGE_LIPO")
  , (LANGUAGE_LISU, "LANGUAGE_LISU")
  , (LANGUAGE_LITHUANIAN, "LANGUAGE_LITHUANIAN")
  , (LANGUAGE_LIV, "LANGUAGE_LIV")
  , (LANGUAGE_LOJBAN, "LANGUAGE_LOJBAN")
  , (LANGUAGE_LOMA, "LANGUAGE_LOMA")
  , (LANGUAGE_LOMBARD, "LANGUAGE_LOMBARD")
  , (LANGUAGE_LOMWE, "LANGUAGE_LOMWE")
  , (LANGUAGE_LOW_MARI, "LANGUAGE_LOW_MARI")
  , (LANGUAGE_LOW_SAXON, "LANGUAGE_LOW_SAXON")
  , (LANGUAGE_LOWER_SORBIAN, "LANGUAGE_LOWER_SORBIAN")
  , (LANGUAGE_LU, "LANGUAGE_LU")
  , (LANGUAGE_LUBA_KATANGA, "LANGUAGE_LUBA_KATANGA")
  , (LANGUAGE_LUBA_LULUA, "LANGUAGE_LUBA_LULUA")
  , (LANGUAGE_LULE_SAMI, "LANGUAGE_LULE_SAMI")
  , (LANGUAGE_LUO, "LANGUAGE_LUO")
  , (LANGUAGE_LURI, "LANGUAGE_LURI")
  , (LANGUAGE_LUSHOOTSEED, "LANGUAGE_LUSHOOTSEED")
  , (LANGUAGE_LUXEMBOURGISH, "LANGUAGE_LUXEMBOURGISH")
  , (LANGUAGE_LUYIA, "LANGUAGE_LUYIA")
  , (LANGUAGE_MACEDONIAN, "LANGUAGE_MACEDONIAN")
  , (LANGUAGE_MADURA, "LANGUAGE_MADURA")
  , (LANGUAGE_MAGAHI, "LANGUAGE_MAGAHI")
  , (LANGUAGE_MAITHILI, "LANGUAGE_MAITHILI")
  , (LANGUAGE_MAJANG, "LANGUAGE_MAJANG")
  , (LANGUAGE_MAKASAR, "LANGUAGE_MAKASAR")
  , (LANGUAGE_MAKHUWA, "LANGUAGE_MAKHUWA")
  , (LANGUAGE_MAKONDE, "LANGUAGE_MAKONDE")
  , (LANGUAGE_MALAGASY, "LANGUAGE_MALAGASY")
  , (LANGUAGE_MALAY, "LANGUAGE_MALAY")
  , (LANGUAGE_MALAYALAM, "LANGUAGE_MALAYALAM")
  , (LANGUAGE_MALAYALAM_REFORMED, "LANGUAGE_MALAYALAM_REFORMED")
  , (LANGUAGE_MALE, "LANGUAGE_MALE")
  , (LANGUAGE_MALINKE, "LANGUAGE_MALINKE")
  , (LANGUAGE_MALTESE, "LANGUAGE_MALTESE")
  , (LANGUAGE_MAM, "LANGUAGE_MAM")
  , (LANGUAGE_MANCHU, "LANGUAGE_MANCHU")
  , (LANGUAGE_MANDAR, "LANGUAGE_MANDAR")
  , (LANGUAGE_MANDINKA, "LANGUAGE_MANDINKA")
  , (LANGUAGE_MANINKA, "LANGUAGE_MANINKA")
  , (LANGUAGE_MANIPURI, "LANGUAGE_MANIPURI")
  , (LANGUAGE_MANO, "LANGUAGE_MANO")
  , (LANGUAGE_MANSI, "LANGUAGE_MANSI")
  , (LANGUAGE_MANX, "LANGUAGE_MANX")
  , (LANGUAGE_MAORI, "LANGUAGE_MAORI")
  , (LANGUAGE_MAPUDUNGUN, "LANGUAGE_MAPUDUNGUN")
  , (LANGUAGE_MARATHI, "LANGUAGE_MARATHI")
  , (LANGUAGE_MARSHALLESE, "LANGUAGE_MARSHALLESE")
  , (LANGUAGE_MARWARI, "LANGUAGE_MARWARI")
  , (LANGUAGE_MAYAN, "LANGUAGE_MAYAN")
  , (LANGUAGE_MAZANDERANI, "LANGUAGE_MAZANDERANI")
  , (LANGUAGE_MBEMBE_TIGON, "LANGUAGE_MBEMBE_TIGON")
  , (LANGUAGE_MBO, "LANGUAGE_MBO")
  , (LANGUAGE_MBUNDU, "LANGUAGE_MBUNDU")
  , (LANGUAGE_MEDUMBA, "LANGUAGE_MEDUMBA")
  , (LANGUAGE_MEEN, "LANGUAGE_MEEN")
  , (LANGUAGE_MENDE, "LANGUAGE_MENDE")
  , (LANGUAGE_MERU, "LANGUAGE_MERU")
  , (LANGUAGE_MEWATI, "LANGUAGE_MEWATI")
  , (LANGUAGE_MINANGKABAU, "LANGUAGE_MINANGKABAU")
  , (LANGUAGE_MINJANGBAL, "LANGUAGE_MINJANGBAL")
  , (LANGUAGE_MIRANDESE, "LANGUAGE_MIRANDESE")
  , (LANGUAGE_MIZO, "LANGUAGE_MIZO")
  , (LANGUAGE_MOHAWK, "LANGUAGE_MOHAWK")
  , (LANGUAGE_MOKSHA, "LANGUAGE_MOKSHA")
  , (LANGUAGE_MOLDAVIAN, "LANGUAGE_MOLDAVIAN")
  , (LANGUAGE_MON, "LANGUAGE_MON")
  , (LANGUAGE_MONGOLIAN, "LANGUAGE_MONGOLIAN")
  , (LANGUAGE_MOOSE_CREE, "LANGUAGE_MOOSE_CREE")
  , (LANGUAGE_MORISYEN, "LANGUAGE_MORISYEN")
  , (LANGUAGE_MOROCCAN, "LANGUAGE_MOROCCAN")
  , (LANGUAGE_MOSSI, "LANGUAGE_MOSSI")
  , (LANGUAGE_MUNDARI, "LANGUAGE_MUNDARI")
  , (LANGUAGE_MUSCOGEE, "LANGUAGE_MUSCOGEE")
  , (LANGUAGE_N_CREE, "LANGUAGE_N_CREE")
  , (LANGUAGE_NAGA_ASSAMESE, "LANGUAGE_NAGA_ASSAMESE")
  , (LANGUAGE_NAGARI, "LANGUAGE_NAGARI")
  , (LANGUAGE_NAHUATL, "LANGUAGE_NAHUATL")
  , (LANGUAGE_NANAI, "LANGUAGE_NANAI")
  , (LANGUAGE_NASKAPI, "LANGUAGE_NASKAPI")
  , (LANGUAGE_NAURUAN, "LANGUAGE_NAURUAN")
  , (LANGUAGE_NAVAJO, "LANGUAGE_NAVAJO")
  , (LANGUAGE_NDAU, "LANGUAGE_NDAU")
  , (LANGUAGE_NDEBELE, "LANGUAGE_NDEBELE")
  , (LANGUAGE_NDONGA, "LANGUAGE_NDONGA")
  , (LANGUAGE_NEAPOLITAN, "LANGUAGE_NEAPOLITAN")
  , (LANGUAGE_NEPALI, "LANGUAGE_NEPALI")
  , (LANGUAGE_NEWARI, "LANGUAGE_NEWARI")
  , (LANGUAGE_NGBAKA, "LANGUAGE_NGBAKA")
  , (LANGUAGE_NIGERIAN_FULFULDE, "LANGUAGE_NIGERIAN_FULFULDE")
  , (LANGUAGE_NIMADI, "LANGUAGE_NIMADI")
  , (LANGUAGE_NISI, "LANGUAGE_NISI")
  , (LANGUAGE_NIUEAN, "LANGUAGE_NIUEAN")
  , (LANGUAGE_NKO, "LANGUAGE_NKO")
  , (LANGUAGE_NOGAI, "LANGUAGE_NOGAI")
  , (LANGUAGE_NORFOLK, "LANGUAGE_NORFOLK")
  , (LANGUAGE_NORTH_SLAVEY, "LANGUAGE_NORTH_SLAVEY")
  , (LANGUAGE_NORTHERN_EMBERA, "LANGUAGE_NORTHERN_EMBERA")
  , (LANGUAGE_NORTHERN_SAMI, "LANGUAGE_NORTHERN_SAMI")
  , (LANGUAGE_NORTHERN_SOTHO, "LANGUAGE_NORTHERN_SOTHO")
  , (LANGUAGE_NORTHERN_TAI, "LANGUAGE_NORTHERN_TAI")
  , (LANGUAGE_NORWAY_HOUSE_CREE, "LANGUAGE_NORWAY_HOUSE_CREE")
  , (LANGUAGE_NORWEGIAN, "LANGUAGE_NORWEGIAN")
  , (LANGUAGE_NORWEGIAN_NYNORSK, "LANGUAGE_NORWEGIAN_NYNORSK")
  , (LANGUAGE_NOVIAL, "LANGUAGE_NOVIAL")
  , (LANGUAGE_NUMANGGANG, "LANGUAGE_NUMANGGANG")
  , (LANGUAGE_NUNAVIK_INUKTITUT, "LANGUAGE_NUNAVIK_INUKTITUT")
  , (LANGUAGE_NUU_CHAH_NULTH, "LANGUAGE_NUU_CHAH_NULTH")
  , (LANGUAGE_NYAMWEZI, "LANGUAGE_NYAMWEZI")
  , (LANGUAGE_NYANKOLE, "LANGUAGE_NYANKOLE")
  , (LANGUAGE_OCCITAN, "LANGUAGE_OCCITAN")
  , (LANGUAGE_ODIA, "LANGUAGE_ODIA")
  , (LANGUAGE_OJI_CREE, "LANGUAGE_OJI_CREE")
  , (LANGUAGE_OJIBWAY, "LANGUAGE_OJIBWAY")
  , (LANGUAGE_OLD_IRISH, "LANGUAGE_OLD_IRISH")
  , (LANGUAGE_OLD_JAVANESE, "LANGUAGE_OLD_JAVANESE")
  , (LANGUAGE_ONEIDA, "LANGUAGE_ONEIDA")
  , (LANGUAGE_ONONDAGA, "LANGUAGE_ONONDAGA")
  , (LANGUAGE_OROMO, "LANGUAGE_OROMO")
  , (LANGUAGE_OSSETIAN, "LANGUAGE_OSSETIAN")
  , (LANGUAGE_PA_O_KAREN, "LANGUAGE_PA_O_KAREN")
  , (LANGUAGE_PALAUAN, "LANGUAGE_PALAUAN")
  , (LANGUAGE_PALAUNG, "LANGUAGE_PALAUNG")
  , (LANGUAGE_PALESTINIAN_ARAMAIC, "LANGUAGE_PALESTINIAN_ARAMAIC")
  , (LANGUAGE_PALI, "LANGUAGE_PALI")
  , (LANGUAGE_PALPA, "LANGUAGE_PALPA")
  , (LANGUAGE_PAMPANGAN, "LANGUAGE_PAMPANGAN")
  , (LANGUAGE_PANGASINAN, "LANGUAGE_PANGASINAN")
  , (LANGUAGE_PAPIAMENTU, "LANGUAGE_PAPIAMENTU")
  , (LANGUAGE_PASHTO, "LANGUAGE_PASHTO")
  , (LANGUAGE_PATTANI_MALAY, "LANGUAGE_PATTANI_MALAY")
  , (LANGUAGE_PENNSYLVANIA_GERMAN, "LANGUAGE_PENNSYLVANIA_GERMAN")
  , (LANGUAGE_PERSIAN, "LANGUAGE_PERSIAN")
  , (LANGUAGE_PHAKE, "LANGUAGE_PHAKE")
  , (LANGUAGE_PICARD, "LANGUAGE_PICARD")
  , (LANGUAGE_PIEMONTESE, "LANGUAGE_PIEMONTESE")
  , (LANGUAGE_PILAGA, "LANGUAGE_PILAGA")
  , (LANGUAGE_PITE_SAMI, "LANGUAGE_PITE_SAMI")
  , (LANGUAGE_POCOMCHI, "LANGUAGE_POCOMCHI")
  , (LANGUAGE_POHNPEIAN, "LANGUAGE_POHNPEIAN")
  , (LANGUAGE_POLISH, "LANGUAGE_POLISH")
  , (LANGUAGE_POLYTONIC_GREEK, "LANGUAGE_POLYTONIC_GREEK")
  , (LANGUAGE_PORTUGUESE, "LANGUAGE_PORTUGUESE")
  , (LANGUAGE_PROVENCAL, "LANGUAGE_PROVENCAL")
  , (LANGUAGE_PUNJABI, "LANGUAGE_PUNJABI")
  , (LANGUAGE_QUECHUA, "LANGUAGE_QUECHUA")
  , (LANGUAGE_QUECHUA_BOLIVIA, "LANGUAGE_QUECHUA_BOLIVIA")
  , (LANGUAGE_QUECHUA_ECUADOR, "LANGUAGE_QUECHUA_ECUADOR")
  , (LANGUAGE_QUECHUA_PERU, "LANGUAGE_QUECHUA_PERU")
  , (LANGUAGE_R_CREE, "LANGUAGE_R_CREE")
  , (LANGUAGE_RAJASTHANI, "LANGUAGE_RAJASTHANI")
  , (LANGUAGE_RAKHINE, "LANGUAGE_RAKHINE")
  , (LANGUAGE_RAROTONGAN, "LANGUAGE_RAROTONGAN")
  , (LANGUAGE_REJANG, "LANGUAGE_REJANG")
  , (LANGUAGE_RIANG, "LANGUAGE_RIANG")
  , (LANGUAGE_RIPUARIAN, "LANGUAGE_RIPUARIAN")
  , (LANGUAGE_RITARUNGO, "LANGUAGE_RITARUNGO")
  , (LANGUAGE_ROHINGYA, "LANGUAGE_ROHINGYA")
  , (LANGUAGE_ROMANIAN, "LANGUAGE_ROMANIAN")
  , (LANGUAGE_ROMANSH, "LANGUAGE_ROMANSH")
  , (LANGUAGE_ROMANY, "LANGUAGE_ROMANY")
  , (LANGUAGE_ROTUMAN, "LANGUAGE_ROTUMAN")
  , (LANGUAGE_RUNDI, "LANGUAGE_RUNDI")
  , (LANGUAGE_RUSSIAN, "LANGUAGE_RUSSIAN")
  , (LANGUAGE_RUSSIAN_BURIAT, "LANGUAGE_RUSSIAN_BURIAT")
  , (LANGUAGE_RUSYN, "LANGUAGE_RUSYN")
  , (LANGUAGE_SADRI, "LANGUAGE_SADRI")
  , (LANGUAGE_SAKHA, "LANGUAGE_SAKHA")
  , (LANGUAGE_SAMOAN, "LANGUAGE_SAMOAN")
  , (LANGUAGE_SAMOGITIAN, "LANGUAGE_SAMOGITIAN")
  , (LANGUAGE_SAN_BLAS_KUNA, "LANGUAGE_SAN_BLAS_KUNA")
  , (LANGUAGE_SANGO, "LANGUAGE_SANGO")
  , (LANGUAGE_SANSKRIT, "LANGUAGE_SANSKRIT")
  , (LANGUAGE_SANTALI, "LANGUAGE_SANTALI")
  , (LANGUAGE_SARAIKI, "LANGUAGE_SARAIKI")
  , (LANGUAGE_SARDINIAN, "LANGUAGE_SARDINIAN")
  , (LANGUAGE_SASAK, "LANGUAGE_SASAK")
  , (LANGUAGE_SATERLAND_FRISIAN, "LANGUAGE_SATERLAND_FRISIAN")
  , (LANGUAGE_SAYISI, "LANGUAGE_SAYISI")
  , (LANGUAGE_SCOTS, "LANGUAGE_SCOTS")
  , (LANGUAGE_SCOTTISH_GAELIC, "LANGUAGE_SCOTTISH_GAELIC")
  , (LANGUAGE_SEKOTA, "LANGUAGE_SEKOTA")
  , (LANGUAGE_SELKUP, "LANGUAGE_SELKUP")
  , (LANGUAGE_SENA, "LANGUAGE_SENA")
  , (LANGUAGE_SENECA, "LANGUAGE_SENECA")
  , (LANGUAGE_SERBIAN, "LANGUAGE_SERBIAN")
  , (LANGUAGE_SERER, "LANGUAGE_SERER")
  , (LANGUAGE_SGAW_KAREN, "LANGUAGE_SGAW_KAREN")
  , (LANGUAGE_SHAN, "LANGUAGE_SHAN")
  , (LANGUAGE_SHONA, "LANGUAGE_SHONA")
  , (LANGUAGE_SIBE, "LANGUAGE_SIBE")
  , (LANGUAGE_SICILIAN, "LANGUAGE_SICILIAN")
  , (LANGUAGE_SIDAMO, "LANGUAGE_SIDAMO")
  , (LANGUAGE_SILESIAN, "LANGUAGE_SILESIAN")
  , (LANGUAGE_SILTE_GURAGE, "LANGUAGE_SILTE_GURAGE")
  , (LANGUAGE_SINDHI, "LANGUAGE_SINDHI")
  , (LANGUAGE_SINHALA, "LANGUAGE_SINHALA")
  , (LANGUAGE_SKOLT_SAMI, "LANGUAGE_SKOLT_SAMI")
  , (LANGUAGE_SLAVEY, "LANGUAGE_SLAVEY")
  , (LANGUAGE_SLOVAK, "LANGUAGE_SLOVAK")
  , (LANGUAGE_SLOVENIAN, "LANGUAGE_SLOVENIAN")
  , (LANGUAGE_SMALL_FLOWERY_MIAO, "LANGUAGE_SMALL_FLOWERY_MIAO")
  , (LANGUAGE_SODO_GURAGE, "LANGUAGE_SODO_GURAGE")
  , (LANGUAGE_SOGA, "LANGUAGE_SOGA")
  , (LANGUAGE_SOMALI, "LANGUAGE_SOMALI")
  , (LANGUAGE_SONGE, "LANGUAGE_SONGE")
  , (LANGUAGE_SONINKE, "LANGUAGE_SONINKE")
  , (LANGUAGE_SOUTH_SLAVEY, "LANGUAGE_SOUTH_SLAVEY")
  , (LANGUAGE_SOUTHERN_KIWAI, "LANGUAGE_SOUTHERN_KIWAI")
  , (LANGUAGE_SOUTHERN_SAMI, "LANGUAGE_SOUTHERN_SAMI")
  , (LANGUAGE_SOUTHERN_SOTHO, "LANGUAGE_SOUTHERN_SOTHO")
  , (LANGUAGE_SPANISH, "LANGUAGE_SPANISH")
  , (LANGUAGE_STANDARD_MOROCCAN_TAMAZIGHT, "LANGUAGE_STANDARD_MOROCCAN_TAMAZIGHT")
  , (LANGUAGE_STRAITS_SALISH, "LANGUAGE_STRAITS_SALISH")
  , (LANGUAGE_SUKUMA, "LANGUAGE_SUKUMA")
  , (LANGUAGE_SUNDANESE, "LANGUAGE_SUNDANESE")
  , (LANGUAGE_SURI, "LANGUAGE_SURI")
  , (LANGUAGE_SUTU, "LANGUAGE_SUTU")
  , (LANGUAGE_SVAN, "LANGUAGE_SVAN")
  , (LANGUAGE_SWADAYA_ARAMAIC, "LANGUAGE_SWADAYA_ARAMAIC")
  , (LANGUAGE_SWAHILI, "LANGUAGE_SWAHILI")
  , (LANGUAGE_SWATI, "LANGUAGE_SWATI")
  , (LANGUAGE_SWEDISH, "LANGUAGE_SWEDISH")
  , (LANGUAGE_SYLHETI, "LANGUAGE_SYLHETI")
  , (LANGUAGE_SYRIAC, "LANGUAGE_SYRIAC")
  , (LANGUAGE_SYRIAC_EASTERN, "LANGUAGE_SYRIAC_EASTERN")
  , (LANGUAGE_SYRIAC_ESTRANGELA, "LANGUAGE_SYRIAC_ESTRANGELA")
  , (LANGUAGE_SYRIAC_WESTERN, "LANGUAGE_SYRIAC_WESTERN")
  , (LANGUAGE_TABASARAN, "LANGUAGE_TABASARAN")
  , (LANGUAGE_TACHELHIT, "LANGUAGE_TACHELHIT")
  , (LANGUAGE_TAGALOG, "LANGUAGE_TAGALOG")
  , (LANGUAGE_TAHAGGART_TAMAHAQ, "LANGUAGE_TAHAGGART_TAMAHAQ")
  , (LANGUAGE_TAHITIAN, "LANGUAGE_TAHITIAN")
  , (LANGUAGE_TAI_LAING, "LANGUAGE_TAI_LAING")
  , (LANGUAGE_TAJIKI, "LANGUAGE_TAJIKI")
  , (LANGUAGE_TALYSH, "LANGUAGE_TALYSH")
  , (LANGUAGE_TAMASHEK, "LANGUAGE_TAMASHEK")
  , (LANGUAGE_TAMASHEQ, "LANGUAGE_TAMASHEQ")
  , (LANGUAGE_TAMAZIGHT, "LANGUAGE_TAMAZIGHT")
  , (LANGUAGE_TAMIL, "LANGUAGE_TAMIL")
  , (LANGUAGE_TARIFIT, "LANGUAGE_TARIFIT")
  , (LANGUAGE_TATAR, "LANGUAGE_TATAR")
  , (LANGUAGE_TAWALLAMMAT_TAMAJAQ, "LANGUAGE_TAWALLAMMAT_TAMAJAQ")
  , (LANGUAGE_TAY, "LANGUAGE_TAY")
  , (LANGUAGE_TAYART_TAMAJEQ, "LANGUAGE_TAYART_TAMAJEQ")
  , (LANGUAGE_TELUGU, "LANGUAGE_TELUGU")
  , (LANGUAGE_TEMNE, "LANGUAGE_TEMNE")
  , (LANGUAGE_TETUM, "LANGUAGE_TETUM")
  , (LANGUAGE_TH_CREE, "LANGUAGE_TH_CREE")
  , (LANGUAGE_THAI, "LANGUAGE_THAI")
  , (LANGUAGE_THAILAND_MON, "LANGUAGE_THAILAND_MON")
  , (LANGUAGE_THOMPSON, "LANGUAGE_THOMPSON")
  , (LANGUAGE_TIBETAN, "LANGUAGE_TIBETAN")
  , (LANGUAGE_TIGRE, "LANGUAGE_TIGRE")
  , (LANGUAGE_TIGRINYA, "LANGUAGE_TIGRINYA")
  , (LANGUAGE_TIV, "LANGUAGE_TIV")
  , (LANGUAGE_TLINGIT, "LANGUAGE_TLINGIT")
  , (LANGUAGE_TOBO, "LANGUAGE_TOBO")
  , (LANGUAGE_TODO, "LANGUAGE_TODO")
  , (LANGUAGE_TOK_PISIN, "LANGUAGE_TOK_PISIN")
  , (LANGUAGE_TOMA, "LANGUAGE_TOMA")
  , (LANGUAGE_TONGA, "LANGUAGE_TONGA")
  , (LANGUAGE_TONGAN, "LANGUAGE_TONGAN")
  , (LANGUAGE_TORKI, "LANGUAGE_TORKI")
  , (LANGUAGE_TSHANGLA, "LANGUAGE_TSHANGLA")
  , (LANGUAGE_TSONGA, "LANGUAGE_TSONGA")
  , (LANGUAGE_TSWANA, "LANGUAGE_TSWANA")
  , (LANGUAGE_TULU, "LANGUAGE_TULU")
  , (LANGUAGE_TUMBUKA, "LANGUAGE_TUMBUKA")
  , (LANGUAGE_TUNDRA_ENETS, "LANGUAGE_TUNDRA_ENETS")
  , (LANGUAGE_TURKISH, "LANGUAGE_TURKISH")
  , (LANGUAGE_TURKMEN, "LANGUAGE_TURKMEN")
  , (LANGUAGE_TUROYO_ARAMAIC, "LANGUAGE_TUROYO_ARAMAIC")
  , (LANGUAGE_TUSCARORA, "LANGUAGE_TUSCARORA")
  , (LANGUAGE_TUVALU, "LANGUAGE_TUVALU")
  , (LANGUAGE_TUVIN, "LANGUAGE_TUVIN")
  , (LANGUAGE_TWI, "LANGUAGE_TWI")
  , (LANGUAGE_TZOTZIL, "LANGUAGE_TZOTZIL")
  , (LANGUAGE_UDI, "LANGUAGE_UDI")
  , (LANGUAGE_UDMURT, "LANGUAGE_UDMURT")
  , (LANGUAGE_UKRAINIAN, "LANGUAGE_UKRAINIAN")
  , (LANGUAGE_UMBUNDU, "LANGUAGE_UMBUNDU")
  , (LANGUAGE_UME_SAMI, "LANGUAGE_UME_SAMI")
  , (LANGUAGE_UPPER_SAXON, "LANGUAGE_UPPER_SAXON")
  , (LANGUAGE_UPPER_SORBIAN, "LANGUAGE_UPPER_SORBIAN")
  , (LANGUAGE_URALIC_PHONETIC, "LANGUAGE_URALIC_PHONETIC")
  , (LANGUAGE_URDU, "LANGUAGE_URDU")
  , (LANGUAGE_UYGHUR, "LANGUAGE_UYGHUR")
  , (LANGUAGE_UZBEK, "LANGUAGE_UZBEK")
  , (LANGUAGE_VENDA, "LANGUAGE_VENDA")
  , (LANGUAGE_VENETIAN, "LANGUAGE_VENETIAN")
  , (LANGUAGE_VIETNAMESE, "LANGUAGE_VIETNAMESE")
  , (LANGUAGE_VLAX_ROMANI, "LANGUAGE_VLAX_ROMANI")
  , (LANGUAGE_VOLAPUK, "LANGUAGE_VOLAPUK")
  , (LANGUAGE_VORO, "LANGUAGE_VORO")
  , (LANGUAGE_WA, "LANGUAGE_WA")
  , (LANGUAGE_WACI_GBE, "LANGUAGE_WACI_GBE")
  , (LANGUAGE_WAGDI, "LANGUAGE_WAGDI")
  , (LANGUAGE_WAKHI, "LANGUAGE_WAKHI")
  , (LANGUAGE_WALLOON, "LANGUAGE_WALLOON")
  , (LANGUAGE_WARAY_WARAY, "LANGUAGE_WARAY_WARAY")
  , (LANGUAGE_WAYANAD_CHETTI, "LANGUAGE_WAYANAD_CHETTI")
  , (LANGUAGE_WAYUU, "LANGUAGE_WAYUU")
  , (LANGUAGE_WELSH, "LANGUAGE_WELSH")
  , (LANGUAGE_WENDAT, "LANGUAGE_WENDAT")
  , (LANGUAGE_WEST_CREE, "LANGUAGE_WEST_CREE")
  , (LANGUAGE_WESTERN_CHAM, "LANGUAGE_WESTERN_CHAM")
  , (LANGUAGE_WESTERN_KAYAH, "LANGUAGE_WESTERN_KAYAH")
  , (LANGUAGE_WESTERN_PANJABI, "LANGUAGE_WESTERN_PANJABI")
  , (LANGUAGE_WESTERN_PWO_KAREN, "LANGUAGE_WESTERN_PWO_KAREN")
  , (LANGUAGE_WOLOF, "LANGUAGE_WOLOF")
  , (LANGUAGE_WOODS_CREE, "LANGUAGE_WOODS_CREE")
  , (LANGUAGE_WUDING_LUQUAN_YI, "LANGUAGE_WUDING_LUQUAN_YI")
  , (LANGUAGE_WYANDOT, "LANGUAGE_WYANDOT")
  , (LANGUAGE_XHOSA, "LANGUAGE_XHOSA")
  , (LANGUAGE_Y_CREE, "LANGUAGE_Y_CREE")
  , (LANGUAGE_YAO, "LANGUAGE_YAO")
  , (LANGUAGE_YAPESE, "LANGUAGE_YAPESE")
  , (LANGUAGE_YI_CLASSIC, "LANGUAGE_YI_CLASSIC")
  , (LANGUAGE_YI_MODERN, "LANGUAGE_YI_MODERN")
  , (LANGUAGE_YIDDISH, "LANGUAGE_YIDDISH")
  , (LANGUAGE_YORUBA, "LANGUAGE_YORUBA")
  , (LANGUAGE_ZAMBOANGA_CHAVACANO, "LANGUAGE_ZAMBOANGA_CHAVACANO")
  , (LANGUAGE_ZANDE, "LANGUAGE_ZANDE")
  , (LANGUAGE_ZARMA, "LANGUAGE_ZARMA")
  , (LANGUAGE_ZAZAKI, "LANGUAGE_ZAZAKI")
  , (LANGUAGE_ZEALANDIC, "LANGUAGE_ZEALANDIC")
  , (LANGUAGE_ZHUANG, "LANGUAGE_ZHUANG")
  , (LANGUAGE_ZULU, "LANGUAGE_ZULU")
  ]
