module KB.Text.Shape.FFI.Enums
  ( module KB.Text.Shape.FFI.Enums
  , module RE
  ) where

import Foreign

import KB.Text.Shape.FFI.Enums.FeatureTag as RE
import KB.Text.Shape.FFI.Enums.Language as RE
import KB.Text.Shape.FFI.Enums.Script as RE

#include "kb_text_shape.h"

-- ** Version

newtype Version = Version Word32
  deriving (Eq, Ord)
  deriving newtype (Storable)

instance Show Version where
  showsPrec d = \case
    VERSION_1_X -> showString "VERSION_1_X"
    VERSION_2_0 -> showString "VERSION_2_0"
    Version huh -> showParen (d > 10) $ showString "Version " . showsPrec 11 huh

pattern VERSION_1_X :: Version
pattern VERSION_1_X = Version (#const KBTS_VERSION_1_X)

pattern VERSION_2_0 :: Version
pattern VERSION_2_0 = Version (#const KBTS_VERSION_2_0)

pattern VERSION_CURRENT :: Version
pattern VERSION_CURRENT = Version (#const KBTS_VERSION_CURRENT)

-- ** BlobVersion

newtype BlobVersion = BlobVersion Word32
  deriving (Eq, Ord)
  deriving newtype (Storable)

instance Show BlobVersion where
  showsPrec d = \case
    BLOB_VERSION_INVALID -> showString "BLOB_VERSION_INVALID"
    BLOB_VERSION_INITIAL -> showString "BLOB_VERSION_INITIAL"
    BlobVersion huh -> showParen (d > 10) $ showString "BlobVersion " . showsPrec 11 huh

pattern BLOB_VERSION_INVALID :: BlobVersion
pattern BLOB_VERSION_INVALID = BlobVersion (#const KBTS_BLOB_VERSION_INVALID)

pattern BLOB_VERSION_INITIAL :: BlobVersion
pattern BLOB_VERSION_INITIAL = BlobVersion (#const KBTS_BLOB_VERSION_INITIAL)

pattern BLOB_VERSION_CURRENT :: BlobVersion
pattern BLOB_VERSION_CURRENT = BlobVersion (#const KBTS_BLOB_VERSION_CURRENT)

-- ** Direction

newtype Direction = Direction Word32
  deriving (Eq, Ord)
  deriving newtype (Storable)

instance Show Direction where
  showsPrec d = \case
    DIRECTION_DONT_KNOW -> showString "DIRECTION_DONT_KNOW"
    DIRECTION_LTR -> showString "DIRECTION_LTR"
    DIRECTION_RTL -> showString "DIRECTION_RTL"
    Direction huh -> showParen (d > 10) $ showString "Direction " . showsPrec 11 huh

pattern DIRECTION_DONT_KNOW :: Direction
pattern DIRECTION_DONT_KNOW = Direction (#const KBTS_DIRECTION_DONT_KNOW)

pattern DIRECTION_LTR :: Direction
pattern DIRECTION_LTR = Direction (#const KBTS_DIRECTION_LTR)

pattern DIRECTION_RTL :: Direction
pattern DIRECTION_RTL = Direction (#const KBTS_DIRECTION_RTL)

newtype ShapeError = ShapeError Word32
  deriving (Eq, Ord)
  deriving newtype (Storable)

instance Show ShapeError where
  showsPrec d = \case
    SHAPE_ERROR_NONE -> showString "SHAPE_ERROR_NONE"
    SHAPE_ERROR_INVALID_FONT -> showString "SHAPE_ERROR_INVALID_FONT"
    SHAPE_ERROR_GAVE_TEXT_BEFORE_CALLING_BEGIN -> showString "SHAPE_ERROR_GAVE_TEXT_BEFORE_CALLING_BEGIN"
    SHAPE_ERROR_OUT_OF_MEMORY -> showString "SHAPE_ERROR_OUT_OF_MEMORY"
    ShapeError huh -> showParen (d > 10) $ showString "ShapeError " . showsPrec 11 huh

pattern SHAPE_ERROR_NONE :: ShapeError
pattern SHAPE_ERROR_NONE = ShapeError (#const KBTS_SHAPE_ERROR_NONE)

pattern SHAPE_ERROR_INVALID_FONT :: ShapeError
pattern SHAPE_ERROR_INVALID_FONT = ShapeError (#const KBTS_SHAPE_ERROR_INVALID_FONT)

pattern SHAPE_ERROR_GAVE_TEXT_BEFORE_CALLING_BEGIN :: ShapeError
pattern SHAPE_ERROR_GAVE_TEXT_BEFORE_CALLING_BEGIN = ShapeError (#const KBTS_SHAPE_ERROR_GAVE_TEXT_BEFORE_CALLING_BEGIN)

pattern SHAPE_ERROR_OUT_OF_MEMORY :: ShapeError
pattern SHAPE_ERROR_OUT_OF_MEMORY = ShapeError (#const KBTS_SHAPE_ERROR_OUT_OF_MEMORY)

newtype UserIdGenerationMode = UserIdGenerationMode Word32
  deriving (Eq, Ord)
  deriving newtype (Storable)

instance Show UserIdGenerationMode where
  showsPrec d = \case
    USER_ID_GENERATION_MODE_CODEPOINT_INDEX -> showString "USER_ID_GENERATION_MODE_CODEPOINT_INDEX"
    USER_ID_GENERATION_MODE_SOURCE_INDEX -> showString "USER_ID_GENERATION_MODE_SOURCE_INDEX"
    UserIdGenerationMode huh -> showParen (d > 10) $ showString "UserIdGenerationMode " . showsPrec 11 huh

pattern USER_ID_GENERATION_MODE_CODEPOINT_INDEX :: UserIdGenerationMode
pattern USER_ID_GENERATION_MODE_CODEPOINT_INDEX = UserIdGenerationMode (#const KBTS_USER_ID_GENERATION_MODE_CODEPOINT_INDEX)

pattern USER_ID_GENERATION_MODE_SOURCE_INDEX :: UserIdGenerationMode
pattern USER_ID_GENERATION_MODE_SOURCE_INDEX = UserIdGenerationMode (#const KBTS_USER_ID_GENERATION_MODE_SOURCE_INDEX)

newtype LoadFontError = LoadFontError Word32
  deriving (Eq, Ord)
  deriving newtype (Storable)

instance Show LoadFontError where
  showsPrec d = \case
    LOAD_FONT_ERROR_NONE -> showString "LOAD_FONT_ERROR_NONE"
    LOAD_FONT_ERROR_NEED_TO_CREATE_BLOB -> showString "LOAD_FONT_ERROR_NEED_TO_CREATE_BLOB"
    LOAD_FONT_ERROR_INVALID_FONT -> showString "LOAD_FONT_ERROR_INVALID_FONT"
    LOAD_FONT_ERROR_OUT_OF_MEMORY -> showString "LOAD_FONT_ERROR_OUT_OF_MEMORY"
    LOAD_FONT_ERROR_COULD_NOT_OPEN_FILE -> showString "LOAD_FONT_ERROR_COULD_NOT_OPEN_FILE"
    LOAD_FONT_ERROR_READ_ERROR -> showString "LOAD_FONT_ERROR_READ_ERROR"
    LoadFontError huh -> showParen (d > 10) $ showString "LoadFontError " . showsPrec 11 huh

pattern LOAD_FONT_ERROR_NONE :: LoadFontError
pattern LOAD_FONT_ERROR_NONE = LoadFontError #const KBTS_LOAD_FONT_ERROR_NONE

pattern LOAD_FONT_ERROR_NEED_TO_CREATE_BLOB :: LoadFontError
pattern LOAD_FONT_ERROR_NEED_TO_CREATE_BLOB = LoadFontError #const KBTS_LOAD_FONT_ERROR_NEED_TO_CREATE_BLOB

pattern LOAD_FONT_ERROR_INVALID_FONT :: LoadFontError
pattern LOAD_FONT_ERROR_INVALID_FONT = LoadFontError #const KBTS_LOAD_FONT_ERROR_INVALID_FONT

pattern LOAD_FONT_ERROR_OUT_OF_MEMORY :: LoadFontError
pattern LOAD_FONT_ERROR_OUT_OF_MEMORY = LoadFontError #const KBTS_LOAD_FONT_ERROR_OUT_OF_MEMORY

pattern LOAD_FONT_ERROR_COULD_NOT_OPEN_FILE :: LoadFontError
pattern LOAD_FONT_ERROR_COULD_NOT_OPEN_FILE = LoadFontError #const KBTS_LOAD_FONT_ERROR_COULD_NOT_OPEN_FILE

pattern LOAD_FONT_ERROR_READ_ERROR :: LoadFontError
pattern LOAD_FONT_ERROR_READ_ERROR = LoadFontError #const KBTS_LOAD_FONT_ERROR_READ_ERROR

newtype FontWeight = FontWeight Word32
  deriving (Eq, Ord)
  deriving newtype (Storable)

instance Show FontWeight where
  showsPrec d = \case
    FONT_WEIGHT_UNKNOWN -> showString "FONT_WEIGHT_UNKNOWN"
    FONT_WEIGHT_THIN -> showString "FONT_WEIGHT_THIN"
    FONT_WEIGHT_EXTRA_LIGHT -> showString "FONT_WEIGHT_EXTRA_LIGHT"
    FONT_WEIGHT_LIGHT -> showString "FONT_WEIGHT_LIGHT"
    FONT_WEIGHT_NORMAL -> showString "FONT_WEIGHT_NORMAL"
    FONT_WEIGHT_MEDIUM -> showString "FONT_WEIGHT_MEDIUM"
    FONT_WEIGHT_SEMI_BOLD -> showString "FONT_WEIGHT_SEMI_BOLD"
    FONT_WEIGHT_BOLD -> showString "FONT_WEIGHT_BOLD"
    FONT_WEIGHT_EXTRA_BOLD -> showString "FONT_WEIGHT_EXTRA_BOLD"
    FONT_WEIGHT_BLACK -> showString "FONT_WEIGHT_BLACK"
    FontWeight huh -> showParen (d > 10) $ showString "FontWeight " . showsPrec 11 huh

pattern FONT_WEIGHT_UNKNOWN :: FontWeight
pattern FONT_WEIGHT_UNKNOWN = FontWeight (#const KBTS_FONT_WEIGHT_UNKNOWN)

pattern FONT_WEIGHT_THIN :: FontWeight
pattern FONT_WEIGHT_THIN = FontWeight (#const KBTS_FONT_WEIGHT_THIN)

pattern FONT_WEIGHT_EXTRA_LIGHT :: FontWeight
pattern FONT_WEIGHT_EXTRA_LIGHT = FontWeight (#const KBTS_FONT_WEIGHT_EXTRA_LIGHT)

pattern FONT_WEIGHT_LIGHT :: FontWeight
pattern FONT_WEIGHT_LIGHT = FontWeight (#const KBTS_FONT_WEIGHT_LIGHT)

pattern FONT_WEIGHT_NORMAL :: FontWeight
pattern FONT_WEIGHT_NORMAL = FontWeight (#const KBTS_FONT_WEIGHT_NORMAL)

pattern FONT_WEIGHT_MEDIUM :: FontWeight
pattern FONT_WEIGHT_MEDIUM = FontWeight (#const KBTS_FONT_WEIGHT_MEDIUM)

pattern FONT_WEIGHT_SEMI_BOLD :: FontWeight
pattern FONT_WEIGHT_SEMI_BOLD = FontWeight (#const KBTS_FONT_WEIGHT_SEMI_BOLD)

pattern FONT_WEIGHT_BOLD :: FontWeight
pattern FONT_WEIGHT_BOLD = FontWeight (#const KBTS_FONT_WEIGHT_BOLD)

pattern FONT_WEIGHT_EXTRA_BOLD :: FontWeight
pattern FONT_WEIGHT_EXTRA_BOLD = FontWeight (#const KBTS_FONT_WEIGHT_EXTRA_BOLD)

pattern FONT_WEIGHT_BLACK :: FontWeight
pattern FONT_WEIGHT_BLACK = FontWeight (#const KBTS_FONT_WEIGHT_BLACK)

newtype FontWidth = FontWidth Word32
  deriving (Eq)
  deriving newtype (Storable)

instance Show FontWidth where
  showsPrec d = \case
    FONT_WIDTH_UNKNOWN -> showString "FONT_WIDTH_UNKNOWN"
    FONT_WIDTH_ULTRA_CONDENSED -> showString "FONT_WIDTH_ULTRA_CONDENSED"
    FONT_WIDTH_EXTRA_CONDENSED -> showString "FONT_WIDTH_EXTRA_CONDENSED"
    FONT_WIDTH_CONDENSED -> showString "FONT_WIDTH_CONDENSED"
    FONT_WIDTH_SEMI_CONDENSED -> showString "FONT_WIDTH_SEMI_CONDENSED"
    FONT_WIDTH_NORMAL -> showString "FONT_WIDTH_NORMAL"
    FONT_WIDTH_SEMI_EXPANDED -> showString "FONT_WIDTH_SEMI_EXPANDED"
    FONT_WIDTH_EXPANDED -> showString "FONT_WIDTH_EXPANDED"
    FONT_WIDTH_EXTRA_EXPANDED -> showString "FONT_WIDTH_EXTRA_EXPANDED"
    FONT_WIDTH_ULTRA_EXPANDED -> showString "FONT_WIDTH_ULTRA_EXPANDED"
    FontWidth huh -> showParen (d > 10) $ showString "FontWidth " . showsPrec 11 huh

pattern FONT_WIDTH_UNKNOWN :: FontWidth
pattern FONT_WIDTH_UNKNOWN = FontWidth (#const KBTS_FONT_WIDTH_UNKNOWN)

pattern FONT_WIDTH_ULTRA_CONDENSED :: FontWidth
pattern FONT_WIDTH_ULTRA_CONDENSED = FontWidth (#const KBTS_FONT_WIDTH_ULTRA_CONDENSED)

pattern FONT_WIDTH_EXTRA_CONDENSED :: FontWidth
pattern FONT_WIDTH_EXTRA_CONDENSED = FontWidth (#const KBTS_FONT_WIDTH_EXTRA_CONDENSED)

pattern FONT_WIDTH_CONDENSED :: FontWidth
pattern FONT_WIDTH_CONDENSED = FontWidth (#const KBTS_FONT_WIDTH_CONDENSED)

pattern FONT_WIDTH_SEMI_CONDENSED :: FontWidth
pattern FONT_WIDTH_SEMI_CONDENSED = FontWidth (#const KBTS_FONT_WIDTH_SEMI_CONDENSED)

pattern FONT_WIDTH_NORMAL :: FontWidth
pattern FONT_WIDTH_NORMAL = FontWidth (#const KBTS_FONT_WIDTH_NORMAL)

pattern FONT_WIDTH_SEMI_EXPANDED :: FontWidth
pattern FONT_WIDTH_SEMI_EXPANDED = FontWidth (#const KBTS_FONT_WIDTH_SEMI_EXPANDED)

pattern FONT_WIDTH_EXPANDED :: FontWidth
pattern FONT_WIDTH_EXPANDED = FontWidth (#const KBTS_FONT_WIDTH_EXPANDED)

pattern FONT_WIDTH_EXTRA_EXPANDED :: FontWidth
pattern FONT_WIDTH_EXTRA_EXPANDED = FontWidth (#const KBTS_FONT_WIDTH_EXTRA_EXPANDED)

pattern FONT_WIDTH_ULTRA_EXPANDED :: FontWidth
pattern FONT_WIDTH_ULTRA_EXPANDED = FontWidth (#const KBTS_FONT_WIDTH_ULTRA_EXPANDED)

newtype FontInfoStringId = FontInfoStringId Int
  deriving (Eq, Ord)

instance Show FontInfoStringId where
  showsPrec d = \case
    FONT_INFO_STRING_ID_NONE -> showString "FONT_INFO_STRING_ID_NONE"
    FONT_INFO_STRING_ID_COPYRIGHT -> showString "FONT_INFO_STRING_ID_COPYRIGHT"
    FONT_INFO_STRING_ID_FAMILY -> showString "FONT_INFO_STRING_ID_FAMILY"
    FONT_INFO_STRING_ID_SUBFAMILY -> showString "FONT_INFO_STRING_ID_SUBFAMILY"
    FONT_INFO_STRING_ID_UID -> showString "FONT_INFO_STRING_ID_UID"
    FONT_INFO_STRING_ID_FULL_NAME -> showString "FONT_INFO_STRING_ID_FULL_NAME"
    FONT_INFO_STRING_ID_VERSION -> showString "FONT_INFO_STRING_ID_VERSION"
    FONT_INFO_STRING_ID_POSTSCRIPT_NAME -> showString "FONT_INFO_STRING_ID_POSTSCRIPT_NAME"
    FONT_INFO_STRING_ID_TRADEMARK -> showString "FONT_INFO_STRING_ID_TRADEMARK"
    FONT_INFO_STRING_ID_MANUFACTURER -> showString "FONT_INFO_STRING_ID_MANUFACTURER"
    FONT_INFO_STRING_ID_DESIGNER -> showString "FONT_INFO_STRING_ID_DESIGNER"
    FONT_INFO_STRING_ID_TYPOGRAPHIC_FAMILY -> showString "FONT_INFO_STRING_ID_TYPOGRAPHIC_FAMILY"
    FONT_INFO_STRING_ID_TYPOGRAPHIC_SUBFAMILY -> showString "FONT_INFO_STRING_ID_TYPOGRAPHIC_SUBFAMILY"
    FontInfoStringId huh -> showParen (d > 10) $ showString "FontInfoStringId " . showsPrec 11 huh

pattern FONT_INFO_STRING_ID_NONE :: FontInfoStringId
pattern FONT_INFO_STRING_ID_NONE = FontInfoStringId (#const KBTS_FONT_INFO_STRING_ID_NONE)

pattern FONT_INFO_STRING_ID_COPYRIGHT :: FontInfoStringId
pattern FONT_INFO_STRING_ID_COPYRIGHT = FontInfoStringId (#const KBTS_FONT_INFO_STRING_ID_COPYRIGHT)

pattern FONT_INFO_STRING_ID_FAMILY :: FontInfoStringId
pattern FONT_INFO_STRING_ID_FAMILY = FontInfoStringId (#const KBTS_FONT_INFO_STRING_ID_FAMILY)

pattern FONT_INFO_STRING_ID_SUBFAMILY :: FontInfoStringId
pattern FONT_INFO_STRING_ID_SUBFAMILY = FontInfoStringId (#const KBTS_FONT_INFO_STRING_ID_SUBFAMILY)

pattern FONT_INFO_STRING_ID_UID :: FontInfoStringId
pattern FONT_INFO_STRING_ID_UID = FontInfoStringId (#const KBTS_FONT_INFO_STRING_ID_UID)

pattern FONT_INFO_STRING_ID_FULL_NAME :: FontInfoStringId
pattern FONT_INFO_STRING_ID_FULL_NAME = FontInfoStringId (#const KBTS_FONT_INFO_STRING_ID_FULL_NAME)

pattern FONT_INFO_STRING_ID_VERSION :: FontInfoStringId
pattern FONT_INFO_STRING_ID_VERSION = FontInfoStringId (#const KBTS_FONT_INFO_STRING_ID_VERSION)

pattern FONT_INFO_STRING_ID_POSTSCRIPT_NAME :: FontInfoStringId
pattern FONT_INFO_STRING_ID_POSTSCRIPT_NAME = FontInfoStringId (#const KBTS_FONT_INFO_STRING_ID_POSTSCRIPT_NAME)

pattern FONT_INFO_STRING_ID_TRADEMARK :: FontInfoStringId
pattern FONT_INFO_STRING_ID_TRADEMARK = FontInfoStringId (#const KBTS_FONT_INFO_STRING_ID_TRADEMARK)

pattern FONT_INFO_STRING_ID_MANUFACTURER :: FontInfoStringId
pattern FONT_INFO_STRING_ID_MANUFACTURER = FontInfoStringId (#const KBTS_FONT_INFO_STRING_ID_MANUFACTURER)

pattern FONT_INFO_STRING_ID_DESIGNER :: FontInfoStringId
pattern FONT_INFO_STRING_ID_DESIGNER = FontInfoStringId (#const KBTS_FONT_INFO_STRING_ID_DESIGNER)

pattern FONT_INFO_STRING_ID_TYPOGRAPHIC_FAMILY :: FontInfoStringId
pattern FONT_INFO_STRING_ID_TYPOGRAPHIC_FAMILY = FontInfoStringId (#const KBTS_FONT_INFO_STRING_ID_TYPOGRAPHIC_FAMILY)

pattern FONT_INFO_STRING_ID_TYPOGRAPHIC_SUBFAMILY :: FontInfoStringId
pattern FONT_INFO_STRING_ID_TYPOGRAPHIC_SUBFAMILY = FontInfoStringId (#const KBTS_FONT_INFO_STRING_ID_TYPOGRAPHIC_SUBFAMILY)

pattern FONT_INFO_STRING_ID_COUNT :: Int
pattern FONT_INFO_STRING_ID_COUNT = #const KBTS_FONT_INFO_STRING_ID_COUNT

newtype TextFormat = TextFormat Word32
  deriving (Eq, Ord)
  deriving newtype (Storable)

instance Show TextFormat where
  showsPrec d = \case
    TEXT_FORMAT_NONE -> showString "TEXT_FORMAT_NONE"
    TEXT_FORMAT_UTF32 -> showString "TEXT_FORMAT_UTF32"
    TEXT_FORMAT_UTF8 -> showString "TEXT_FORMAT_UTF8"
    TextFormat huh -> showParen (d > 10) $ showString "TextFormat " . showsPrec 11 huh

pattern TEXT_FORMAT_NONE :: TextFormat
pattern TEXT_FORMAT_NONE = TextFormat (#const KBTS_TEXT_FORMAT_NONE)

pattern TEXT_FORMAT_UTF32 :: TextFormat
pattern TEXT_FORMAT_UTF32 = TextFormat (#const KBTS_TEXT_FORMAT_UTF32)

pattern TEXT_FORMAT_UTF8 :: TextFormat
pattern TEXT_FORMAT_UTF8 = TextFormat (#const KBTS_TEXT_FORMAT_UTF8)

{- |
  Japanese text contains "kinsoku" characters, around which breaking a line is forbidden.
  Exactly which characters are "kinsoku" or not depends on the context:
  - Strict style has the largest amount of kinsoku characters, which leads to longer lines.
  - Loose style has the smallest amount of kinsoku characters, which leads to smaller lines.
  - Normal style is somewhere in the middle.
  Note that, while the Unicode standard mentions all three of these styles, it does not mention
  any differences between the normal and loose styles.
  As such, normal and loose styles currently behave the same.
-}
newtype JapaneseLineBreakStyle = JapaneseLineBreakStyle Word8
  deriving (Eq, Ord)
  deriving (Storable)

instance Show JapaneseLineBreakStyle where
  showsPrec d = \case
    JAPANESE_LINE_BREAK_STYLE_STRICT -> showString "JAPANESE_LINE_BREAK_STYLE_STRICT"
    JAPANESE_LINE_BREAK_STYLE_NORMAL -> showString "JAPANESE_LINE_BREAK_STYLE_NORMAL"
    JAPANESE_LINE_BREAK_STYLE_LOOSE -> showString "JAPANESE_LINE_BREAK_STYLE_LOOSE"
    JapaneseLineBreakStyle huh -> showParen (d > 10) $ showString "JapaneseLineBreakStyle " . showsPrec 11 huh

{- |
  The Unicode standard does not define what strict style is used for.
  Supposedly, it is used for anything that does not fall into the other two categories of text.
-}
pattern JAPANESE_LINE_BREAK_STYLE_STRICT :: JapaneseLineBreakStyle
pattern JAPANESE_LINE_BREAK_STYLE_STRICT = JapaneseLineBreakStyle (#const KBTS_JAPANESE_LINE_BREAK_STYLE_STRICT)

-- | Normal style is used for books and documents.
pattern JAPANESE_LINE_BREAK_STYLE_NORMAL :: JapaneseLineBreakStyle
pattern JAPANESE_LINE_BREAK_STYLE_NORMAL = JapaneseLineBreakStyle (#const KBTS_JAPANESE_LINE_BREAK_STYLE_NORMAL)

-- | Loose style is used for newspapers, and (I assume) any other narrow column format.
pattern JAPANESE_LINE_BREAK_STYLE_LOOSE :: JapaneseLineBreakStyle
pattern JAPANESE_LINE_BREAK_STYLE_LOOSE = JapaneseLineBreakStyle (#const KBTS_JAPANESE_LINE_BREAK_STYLE_LOOSE)

-- ** UnicodeJoiningFeature

newtype UnicodeJoiningFeature = UnicodeJoiningFeature Word8
  deriving (Eq, Ord)
  deriving (Storable)

instance Show UnicodeJoiningFeature where
  showsPrec d = \case
    JOINING_FEATURE_ISOL -> showString "JOINING_FEATURE_ISOL"
    JOINING_FEATURE_FINA -> showString "JOINING_FEATURE_FINA"
    JOINING_FEATURE_FIN2 -> showString "JOINING_FEATURE_FIN2"
    JOINING_FEATURE_FIN3 -> showString "JOINING_FEATURE_FIN3"
    JOINING_FEATURE_MEDI -> showString "JOINING_FEATURE_MEDI"
    JOINING_FEATURE_MED2 -> showString "JOINING_FEATURE_MED2"
    JOINING_FEATURE_INIT -> showString "JOINING_FEATURE_INIT"
    UnicodeJoiningFeature huh -> showParen (d > 10) $ showString "UnicodeJoiningFeature " . showsPrec 11 huh

pattern JOINING_FEATURE_ISOL :: UnicodeJoiningFeature
pattern JOINING_FEATURE_ISOL = UnicodeJoiningFeature (#const KBTS_JOINING_FEATURE_ISOL)

pattern JOINING_FEATURE_FINA :: UnicodeJoiningFeature
pattern JOINING_FEATURE_FINA = UnicodeJoiningFeature (#const KBTS_JOINING_FEATURE_FINA)

pattern JOINING_FEATURE_FIN2 :: UnicodeJoiningFeature
pattern JOINING_FEATURE_FIN2 = UnicodeJoiningFeature (#const KBTS_JOINING_FEATURE_FIN2)

pattern JOINING_FEATURE_FIN3 :: UnicodeJoiningFeature
pattern JOINING_FEATURE_FIN3 = UnicodeJoiningFeature (#const KBTS_JOINING_FEATURE_FIN3)

pattern JOINING_FEATURE_MEDI :: UnicodeJoiningFeature
pattern JOINING_FEATURE_MEDI = UnicodeJoiningFeature (#const KBTS_JOINING_FEATURE_MEDI)

pattern JOINING_FEATURE_MED2 :: UnicodeJoiningFeature
pattern JOINING_FEATURE_MED2 = UnicodeJoiningFeature (#const KBTS_JOINING_FEATURE_MED2)

pattern JOINING_FEATURE_INIT :: UnicodeJoiningFeature
pattern JOINING_FEATURE_INIT = UnicodeJoiningFeature (#const KBTS_JOINING_FEATURE_INIT)

-- ** UnicodeJoiningType

newtype UnicodeJoiningType = UnicodeJoiningType Word8
  deriving (Eq, Ord)
  deriving (Storable)

instance Show UnicodeJoiningType where
  showsPrec d = \case
    UNICODE_JOINING_TYPE_NONE -> showString "UNICODE_JOINING_TYPE_NONE"
    UNICODE_JOINING_TYPE_LEFT -> showString "UNICODE_JOINING_TYPE_LEFT"
    UNICODE_JOINING_TYPE_DUAL -> showString "UNICODE_JOINING_TYPE_DUAL"
    UNICODE_JOINING_TYPE_FORCE -> showString "UNICODE_JOINING_TYPE_FORCE"
    UNICODE_JOINING_TYPE_RIGHT -> showString "UNICODE_JOINING_TYPE_RIGHT"
    UNICODE_JOINING_TYPE_TRANSPARENT -> showString "UNICODE_JOINING_TYPE_TRANSPARENT"
    UnicodeJoiningType huh -> showParen (d > 10) $ showString "UnicodeJoiningType " . showsPrec 11 huh

pattern UNICODE_JOINING_TYPE_NONE :: UnicodeJoiningType
pattern UNICODE_JOINING_TYPE_NONE = UnicodeJoiningType (#const KBTS_UNICODE_JOINING_TYPE_NONE)

pattern UNICODE_JOINING_TYPE_LEFT :: UnicodeJoiningType
pattern UNICODE_JOINING_TYPE_LEFT = UnicodeJoiningType (#const KBTS_UNICODE_JOINING_TYPE_LEFT)

pattern UNICODE_JOINING_TYPE_DUAL :: UnicodeJoiningType
pattern UNICODE_JOINING_TYPE_DUAL = UnicodeJoiningType (#const KBTS_UNICODE_JOINING_TYPE_DUAL)

pattern UNICODE_JOINING_TYPE_FORCE :: UnicodeJoiningType
pattern UNICODE_JOINING_TYPE_FORCE = UnicodeJoiningType (#const KBTS_UNICODE_JOINING_TYPE_FORCE)

pattern UNICODE_JOINING_TYPE_RIGHT :: UnicodeJoiningType
pattern UNICODE_JOINING_TYPE_RIGHT = UnicodeJoiningType (#const KBTS_UNICODE_JOINING_TYPE_RIGHT)

pattern UNICODE_JOINING_TYPE_TRANSPARENT :: UnicodeJoiningType
pattern UNICODE_JOINING_TYPE_TRANSPARENT = UnicodeJoiningType (#const KBTS_UNICODE_JOINING_TYPE_TRANSPARENT)
