module KB.Text.Shape.FFI.API.Context where

import Prelude hiding (id, error)

import Foreign
import Foreign.C

import KB.Text.Shape.FFI.Allocator (Allocator)
import KB.Text.Shape.FFI.Handles
import KB.Text.Shape.FFI.Enums
import KB.Text.Shape.FFI.Structs

#include "kb_text_shape.h"

-- The context can do everything for you. It is pretty convenient!

-- | @int kbts_SizeOfShapeContext(void);@
foreign import ccall unsafe "kbts_SizeOfShapeContext" kbts_SizeOfShapeContext :: CInt

-- | @kbts_shape_context *kbts_PlaceShapeContext(kbts_allocator_function *Allocator, void *AllocatorData, void *Memory);@
foreign import ccall safe "kbts_PlaceShapeContext" kbts_PlaceShapeContext
  :: FunPtr Allocator
  -> Ptr () -- ^ AllocatorData
  -> Ptr () -- ^ Memory
  -> IO ShapeContext

-- | @kbts_shape_context *kbts_PlaceShapeContextFixedMemory(void *Memory, int Size);@
foreign import ccall unsafe "kbts_PlaceShapeContextFixedMemory" kbts_PlaceShapeContextFixedMemory
  :: Ptr () -- ^ Memory
  -> CInt -- ^ Size
  -> IO ShapeContext -- ^ kbts_shape_context *

-- | @kbts_shape_context *kbts_CreateShapeContext(kbts_allocator_function *Allocator, void *AllocatorData);@
foreign import ccall safe "kbts_CreateShapeContext" kbts_CreateShapeContext
  :: FunPtr Allocator
  -> Ptr () -- ^ AllocatorData
  -> IO ShapeContext

-- | @void kbts_DestroyShapeContext(kbts_shape_context *Context);@
foreign import ccall unsafe "kbts_DestroyShapeContext" kbts_DestroyShapeContext
  :: ShapeContext
  -> IO ()

#ifndef KB_TEXT_SHAPE_NO_CRT
-- | @kbts_font *kbts_ShapePushFontFromFile(kbts_shape_context *Context, const char *FileName, int FontIndex);@
foreign import ccall unsafe "kbts_ShapePushFontFromFile" kbts_ShapePushFontFromFile
  :: ShapeContext
  -> CString -- ^ FileName
  -> CInt -- ^ FontIndex
  -> IO Font
#endif

-- | @kbts_font *kbts_ShapePushFontFromMemory(kbts_shape_context *Context, void *Memory, int Size, int FontIndex);@
foreign import ccall unsafe "kbts_ShapePushFontFromMemory" kbts_ShapePushFontFromMemory
  :: ShapeContext
  -> Ptr () -- ^ Memory
  -> CSize -- ^ Size
  -> CInt -- ^ FontIndex
  -> IO Font

-- | @kbts_font *kbts_ShapePushFont(kbts_shape_context *Context, kbts_font *Font);@
foreign import ccall unsafe "kbts_ShapePushFont" kbts_ShapePushFont
  :: ShapeContext
  -> Font
  -> IO Font

-- | @kbts_font *kbts_ShapePopFont(kbts_shape_context *Context);@
foreign import ccall unsafe "kbts_ShapePopFont" kbts_ShapePopFont
  :: ShapeContext
  -> IO Font

-- | @void kbts_ShapeBegin(kbts_shape_context *Context, kbts_direction ParagraphDirection, kbts_language Language);@
foreign import ccall unsafe "kbts_ShapeBegin" kbts_ShapeBegin
  :: ShapeContext
  -> Direction
  -> Language
  -> IO ()

-- @void kbts_ShapeEnd(kbts_shape_context *Context);@
foreign import ccall unsafe "kbts_ShapeEnd" kbts_ShapeEnd
  :: ShapeContext
  -> IO ()

-- | @int kbts_ShapeRun(kbts_shape_context *Context, kbts_run *Run);@
foreign import ccall unsafe "kbts_ShapeRun" kbts_ShapeRun
  :: ShapeContext
  -> Ptr Run
  -> IO Int

-- | @void kbts_ShapePushFeature(kbts_shape_context *Context, kbts_u32 FeatureTag, int Value);@
foreign import ccall unsafe "kbts_ShapePushFeature" kbts_ShapePushFeature
  :: ShapeContext
  -> FeatureTag
  -> CInt -- ^ Value
  -> IO ()

-- | @int kbts_ShapePopFeature(kbts_shape_context *Context, kbts_u32 FeatureTag);@
foreign import ccall unsafe "kbts_ShapePopFeature" kbts_ShapePopFeature
  :: ShapeContext
  -> FeatureTag
  -> IO CInt

-- | @void kbts_ShapeCodepoint(kbts_shape_context *Context, int Codepoint);@
foreign import ccall unsafe "kbts_ShapeCodepoint" kbts_ShapeCodepoint
  :: ShapeContext
  -> CInt -- ^ Codepoint
  -> IO ()

-- | @void kbts_ShapeCodepointWithUserId(kbts_shape_context *Context, int Codepoint, int UserId);@
foreign import ccall unsafe "kbts_ShapeCodepointWithUserId" kbts_ShapeCodepointWithUserId
  :: ShapeContext
  -> CInt -- ^ Codepoint
  -> CInt -- ^ UserId
  -> IO ()

-- | @void kbts_ShapeUtf32(kbts_shape_context *Context, int *Utf32, int Length);@
foreign import ccall unsafe "kbts_ShapeUtf32" kbts_ShapeUtf32
  :: ShapeContext
  -> Ptr CInt -- ^ Utf32
  -> CInt -- ^ Length
  -> IO ()

-- | @void kbts_ShapeUtf32WithUserId(kbts_shape_context *Context, int *Utf32, int Length, int UserId, int UserIdIncrement);@
foreign import ccall unsafe "kbts_ShapeUtf32WithUserId" kbts_ShapeUtf32WithUserId
  :: ShapeContext
  -> Ptr CInt -- ^ Utf32
  -> CInt -- ^ Length
  -> CInt -- ^ UserId
  -> CInt -- ^ UserIdIncrement
  -> IO ()

-- | @void kbts_ShapeUtf8(kbts_shape_context *Context, const char *Utf8, int Length, kbts_user_id_generation_mode UserIdGenerationMode);@
foreign import ccall unsafe "kbts_ShapeUtf8" kbts_ShapeUtf8
  :: ShapeContext
  -> Ptr CChar
  -> CInt -- ^ Length
  -> UserIdGenerationMode
  -> IO ()

-- | @void kbts_ShapeUtf8WithUserId(kbts_shape_context *Context, const char *Utf8, int Length, int UserId, kbts_user_id_generation_mode UserIdGenerationMode);@
foreign import ccall unsafe "kbts_ShapeUtf8WithUserId" kbts_ShapeUtf8WithUserId
  :: ShapeContext
  -> Ptr CChar
  -> CInt -- ^ Length
  -> CInt -- ^ UserId
  -> UserIdGenerationMode
  -> IO ()

-- | @kbts_shape_error kbts_ShapeError(kbts_shape_context *Context);@
foreign import ccall unsafe "kbts_ShapeError" kbts_ShapeError
  :: ShapeContext
  -> ShapeError

-- | @void kbts_ShapeBeginManualRuns(kbts_shape_context *Context);@
foreign import ccall unsafe "kbts_ShapeBeginManualRuns" kbts_ShapeBeginManualRuns
  :: ShapeContext
  -> IO ()

-- | @void kbts_ShapeNextManualRun(kbts_shape_context *Context, kbts_direction Direction, kbts_script Script);@
foreign import ccall unsafe "kbts_ShapeNextManualRun" kbts_ShapeNextManualRun
  :: ShapeContext
  -> Direction
  -> Script
  -> IO ()

-- | @void kbts_ShapeEndManualRuns(kbts_shape_context *Context);@
foreign import ccall unsafe "kbts_ShapeEndManualRuns" kbts_ShapeEndManualRuns
  :: ShapeContext
  -> IO ()

-- | @void kbts_ShapeManualBreak(kbts_shape_context *Context);@
foreign import ccall unsafe "kbts_ShapeManualBreak" kbts_ShapeManualBreak
  :: ShapeContext
  -> IO ()

-- | Wrapped @kbts_shape_codepoint_iterator kbts_ShapeCurrentCodepointsIterator(kbts_shape_context *Context);@
--
-- The original returns struct by value.
foreign import ccall unsafe "hs_ShapeCurrentCodepointsIterator" hs_ShapeCurrentCodepointsIterator
  :: ShapeContext
  -> Ptr CodepointIterator
  -> IO ()

-- | @int kbts_ShapeCodepointIteratorIsValid(kbts_shape_codepoint_iterator *It);@
foreign import ccall unsafe "kbts_ShapeCodepointIteratorIsValid" kbts_ShapeCodepointIteratorIsValid
  :: Ptr CodepointIterator
  -> IO Int

-- | @int kbts_ShapeCodepointIteratorNext(kbts_shape_codepoint_iterator *It, kbts_shape_codepoint *Codepoint, int *CodepointIndex);@
foreign import ccall unsafe "kbts_ShapeCodepointIteratorNext" kbts_ShapeCodepointIteratorNext
  :: Ptr CodepointIterator
  -> Ptr Codepoint
  -> Ptr Int
  -> IO Int

-- | @int kbts_ShapeGetShapeCodepoint(kbts_shape_context *Context, int CodepointIndex, kbts_shape_codepoint *Codepoint);@
foreign import ccall unsafe "kbts_ShapeGetShapeCodepoint" kbts_ShapeGetShapeCodepoint
  :: ShapeContext
  -> CInt -- ^ CodepointIndex
  -> Ptr Codepoint
  -> IO Int
