module Main (main) where

import           Codec.Bz3
import qualified Data.ByteString.Lazy as BSL
import           System.Directory     (doesDirectoryExist, listDirectory)
import           System.Random        (randomRIO)
import           Test.Tasty           (defaultMain, testGroup)
import           Test.Tasty.HUnit     (assertBool, testCase)

main :: IO ()
main = do
    d <- do {e <- doesDirectoryExist "test/data"; if e then listDirectory "test/data" else pure []}
    defaultMain $ testGroup "bz3" [ roundtrip ("test/data/" ++ f) | f <- d ]

roundtrip fp = testCase ("roundtrip " ++ fp) $ do
    contents <- BSL.readFile fp
    eb <- randomRIO (2::Int,8)
    let bsz=2^eb*1024*1024
        d = decompressFile contents
        e = compressFile bsz d
        d1 = decompressFile e
    assertBool "doesn't error" (d1 `seq` True)
