{-# LANGUAGE EmptyDataDecls, ExistentialQuantification,
  FlexibleContexts, FlexibleInstances, ForeignFunctionInterface,
  MultiParamTypeClasses, ScopedTypeVariables, TypeFamilies,
  TypeSynonymInstances #-}
module HROOT.Graf.TView3D.Interface where
import Data.Word
import Data.Int
import Foreign.C
import Foreign.Ptr
import FFICXX.Runtime.Cast
import HROOT.Graf.TView3D.RawType
import HROOT.Graf.TView.Interface

class (ITView a) => ITView3D a where

upcastTView3D :: forall a . (FPtr a, ITView3D a) => a -> TView3D
upcastTView3D h
  = let fh = get_fptr h
        fh2 :: Ptr RawTView3D = castPtr fh
      in cast_fptr_to_obj fh2

downcastTView3D :: forall a . (FPtr a, ITView3D a) => TView3D -> a
downcastTView3D h
  = let fh = get_fptr h
        fh2 = castPtr fh
      in cast_fptr_to_obj fh2
