{-# LANGUAGE ForeignFunctionInterface, InterruptibleFFI #-}
module HROOT.Graf.TView3D.FFI where
import Data.Word
import Data.Int
import Foreign.C
import Foreign.Ptr
import HROOT.Graf.TView3D.RawType
import HROOT.Graf.TView3D.RawType
import HROOT.Core.TVirtualPad.RawType
import HROOT.Core.TObject.RawType
import HROOT.Core.TClass.RawType

foreign import ccall interruptible
               "HROOTGrafTView3D.h TView3D_Front" c_tview3d_front ::
               Ptr RawTView3D -> IO ()

foreign import ccall interruptible
               "HROOTGrafTView3D.h TView3D_FrontView" c_tview3d_frontview ::
               Ptr RawTView3D -> Ptr RawTVirtualPad -> IO ()

foreign import ccall interruptible
               "HROOTGrafTView3D.h TView3D_GetLatitude" c_tview3d_getlatitude ::
               Ptr RawTView3D -> IO CDouble

foreign import ccall interruptible
               "HROOTGrafTView3D.h TView3D_GetLongitude" c_tview3d_getlongitude ::
               Ptr RawTView3D -> IO CDouble

foreign import ccall interruptible
               "HROOTGrafTView3D.h TView3D_GetPsi" c_tview3d_getpsi ::
               Ptr RawTView3D -> IO CDouble

foreign import ccall interruptible
               "HROOTGrafTView3D.h TView3D_IsViewChanged" c_tview3d_isviewchanged
               :: Ptr RawTView3D -> IO CBool

foreign import ccall interruptible
               "HROOTGrafTView3D.h TView3D_RotateView" c_tview3d_rotateview ::
               Ptr RawTView3D -> CDouble -> CDouble -> IO ()

foreign import ccall interruptible
               "HROOTGrafTView3D.h TView3D_SetLatitude" c_tview3d_setlatitude ::
               Ptr RawTView3D -> CDouble -> IO ()

foreign import ccall interruptible
               "HROOTGrafTView3D.h TView3D_SetLongitude" c_tview3d_setlongitude ::
               Ptr RawTView3D -> CDouble -> IO ()

foreign import ccall interruptible
               "HROOTGrafTView3D.h TView3D_SetPsi" c_tview3d_setpsi ::
               Ptr RawTView3D -> CDouble -> IO ()

foreign import ccall interruptible
               "HROOTGrafTView3D.h TView3D_SetView1" c_tview3d_setview1 ::
               Ptr RawTView3D ->
                 CDouble -> CDouble -> CDouble -> Ptr CInt -> IO ()

foreign import ccall interruptible
               "HROOTGrafTView3D.h TView3D_SetViewChanged"
               c_tview3d_setviewchanged :: Ptr RawTView3D -> CBool -> IO ()

foreign import ccall interruptible
               "HROOTGrafTView3D.h TView3D_Side" c_tview3d_side ::
               Ptr RawTView3D -> IO ()

foreign import ccall interruptible
               "HROOTGrafTView3D.h TView3D_SideView" c_tview3d_sideview ::
               Ptr RawTView3D -> Ptr RawTVirtualPad -> IO ()

foreign import ccall interruptible "HROOTGrafTView3D.h TView3D_Top"
               c_tview3d_top :: Ptr RawTView3D -> IO ()

foreign import ccall interruptible
               "HROOTGrafTView3D.h TView3D_TopView" c_tview3d_topview ::
               Ptr RawTView3D -> Ptr RawTVirtualPad -> IO ()

foreign import ccall interruptible
               "HROOTGrafTView3D.h TView3D_Clear" c_tview3d_clear ::
               Ptr RawTView3D -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTView3D.h TView3D_Draw" c_tview3d_draw ::
               Ptr RawTView3D -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTView3D.h TView3D_FindObject" c_tview3d_findobject ::
               Ptr RawTView3D -> CString -> IO (Ptr RawTObject)

foreign import ccall interruptible
               "HROOTGrafTView3D.h TView3D_GetName" c_tview3d_getname ::
               Ptr RawTView3D -> IO CString

foreign import ccall interruptible "HROOTGrafTView3D.h TView3D_IsA"
               c_tview3d_isa :: Ptr RawTView3D -> IO (Ptr RawTClass)

foreign import ccall interruptible
               "HROOTGrafTView3D.h TView3D_Paint" c_tview3d_paint ::
               Ptr RawTView3D -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTView3D.h TView3D_printObj" c_tview3d_printobj ::
               Ptr RawTView3D -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTView3D.h TView3D_SaveAs" c_tview3d_saveas ::
               Ptr RawTView3D -> CString -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTView3D.h TView3D_Write" c_tview3d_write ::
               Ptr RawTView3D -> CString -> CInt -> CInt -> IO CInt

foreign import ccall interruptible
               "HROOTGrafTView3D.h TView3D_Write_" c_tview3d_write_ ::
               Ptr RawTView3D -> IO CInt

foreign import ccall interruptible
               "HROOTGrafTView3D.h TView3D_GetLineColor" c_tview3d_getlinecolor ::
               Ptr RawTView3D -> IO CShort

foreign import ccall interruptible
               "HROOTGrafTView3D.h TView3D_GetLineStyle" c_tview3d_getlinestyle ::
               Ptr RawTView3D -> IO CShort

foreign import ccall interruptible
               "HROOTGrafTView3D.h TView3D_GetLineWidth" c_tview3d_getlinewidth ::
               Ptr RawTView3D -> IO CShort

foreign import ccall interruptible
               "HROOTGrafTView3D.h TView3D_ResetAttLine" c_tview3d_resetattline ::
               Ptr RawTView3D -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTView3D.h TView3D_SetLineAttributes"
               c_tview3d_setlineattributes :: Ptr RawTView3D -> IO ()

foreign import ccall interruptible
               "HROOTGrafTView3D.h TView3D_SetLineColor" c_tview3d_setlinecolor ::
               Ptr RawTView3D -> CShort -> IO ()

foreign import ccall interruptible
               "HROOTGrafTView3D.h TView3D_SetLineStyle" c_tview3d_setlinestyle ::
               Ptr RawTView3D -> CShort -> IO ()

foreign import ccall interruptible
               "HROOTGrafTView3D.h TView3D_SetLineWidth" c_tview3d_setlinewidth ::
               Ptr RawTView3D -> CShort -> IO ()

foreign import ccall interruptible
               "HROOTGrafTView3D.h TView3D_delete" c_tview3d_delete ::
               Ptr RawTView3D -> IO ()
