{-# LANGUAGE EmptyDataDecls, ExistentialQuantification,
  FlexibleContexts, FlexibleInstances, ForeignFunctionInterface,
  MultiParamTypeClasses, ScopedTypeVariables, TypeFamilies,
  TypeSynonymInstances #-}
module HROOT.Graf.TView.Interface where
import Data.Word
import Data.Int
import Foreign.C
import Foreign.Ptr
import FFICXX.Runtime.Cast
import HROOT.Graf.TView.RawType
import HROOT.Core.TObject.Interface
import HROOT.Core.TAttLine.Interface
import HROOT.Core.TVirtualPad.Interface

class (ITObject a, ITAttLine a) => ITView a where
        front :: () => a -> IO ()
        
        frontView :: (ITVirtualPad c0, FPtr c0) => a -> c0 -> IO ()
        
        getLatitude :: () => a -> IO CDouble
        
        getLongitude :: () => a -> IO CDouble
        
        getPsi :: () => a -> IO CDouble
        
        isViewChanged :: () => a -> IO CBool
        
        rotateView :: () => a -> CDouble -> CDouble -> IO ()
        
        setLatitude :: () => a -> CDouble -> IO ()
        
        setLongitude :: () => a -> CDouble -> IO ()
        
        setPsi :: () => a -> CDouble -> IO ()
        
        setView1 ::
                   () => a -> CDouble -> CDouble -> CDouble -> Ptr CInt -> IO ()
        
        setViewChanged :: () => a -> CBool -> IO ()
        
        side :: () => a -> IO ()
        
        sideView :: (ITVirtualPad c0, FPtr c0) => a -> c0 -> IO ()
        
        top :: () => a -> IO ()
        
        topView :: (ITVirtualPad c0, FPtr c0) => a -> c0 -> IO ()

upcastTView :: forall a . (FPtr a, ITView a) => a -> TView
upcastTView h
  = let fh = get_fptr h
        fh2 :: Ptr RawTView = castPtr fh
      in cast_fptr_to_obj fh2

downcastTView :: forall a . (FPtr a, ITView a) => TView -> a
downcastTView h
  = let fh = get_fptr h
        fh2 = castPtr fh
      in cast_fptr_to_obj fh2
