{-# LANGUAGE ForeignFunctionInterface, InterruptibleFFI #-}
module HROOT.Graf.TView.FFI where
import Data.Word
import Data.Int
import Foreign.C
import Foreign.Ptr
import HROOT.Graf.TView.RawType
import HROOT.Graf.TView.RawType
import HROOT.Core.TObject.RawType
import HROOT.Core.TClass.RawType
import HROOT.Core.TVirtualPad.RawType

foreign import ccall interruptible "HROOTGrafTView.h TView_Clear"
               c_tview_clear :: Ptr RawTView -> CString -> IO ()

foreign import ccall interruptible "HROOTGrafTView.h TView_Draw"
               c_tview_draw :: Ptr RawTView -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTView.h TView_FindObject" c_tview_findobject ::
               Ptr RawTView -> CString -> IO (Ptr RawTObject)

foreign import ccall interruptible "HROOTGrafTView.h TView_GetName"
               c_tview_getname :: Ptr RawTView -> IO CString

foreign import ccall interruptible "HROOTGrafTView.h TView_IsA"
               c_tview_isa :: Ptr RawTView -> IO (Ptr RawTClass)

foreign import ccall interruptible "HROOTGrafTView.h TView_Paint"
               c_tview_paint :: Ptr RawTView -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTView.h TView_printObj" c_tview_printobj ::
               Ptr RawTView -> CString -> IO ()

foreign import ccall interruptible "HROOTGrafTView.h TView_SaveAs"
               c_tview_saveas :: Ptr RawTView -> CString -> CString -> IO ()

foreign import ccall interruptible "HROOTGrafTView.h TView_Write"
               c_tview_write :: Ptr RawTView -> CString -> CInt -> CInt -> IO CInt

foreign import ccall interruptible "HROOTGrafTView.h TView_Write_"
               c_tview_write_ :: Ptr RawTView -> IO CInt

foreign import ccall interruptible
               "HROOTGrafTView.h TView_GetLineColor" c_tview_getlinecolor ::
               Ptr RawTView -> IO CShort

foreign import ccall interruptible
               "HROOTGrafTView.h TView_GetLineStyle" c_tview_getlinestyle ::
               Ptr RawTView -> IO CShort

foreign import ccall interruptible
               "HROOTGrafTView.h TView_GetLineWidth" c_tview_getlinewidth ::
               Ptr RawTView -> IO CShort

foreign import ccall interruptible
               "HROOTGrafTView.h TView_ResetAttLine" c_tview_resetattline ::
               Ptr RawTView -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTView.h TView_SetLineAttributes"
               c_tview_setlineattributes :: Ptr RawTView -> IO ()

foreign import ccall interruptible
               "HROOTGrafTView.h TView_SetLineColor" c_tview_setlinecolor ::
               Ptr RawTView -> CShort -> IO ()

foreign import ccall interruptible
               "HROOTGrafTView.h TView_SetLineStyle" c_tview_setlinestyle ::
               Ptr RawTView -> CShort -> IO ()

foreign import ccall interruptible
               "HROOTGrafTView.h TView_SetLineWidth" c_tview_setlinewidth ::
               Ptr RawTView -> CShort -> IO ()

foreign import ccall interruptible "HROOTGrafTView.h TView_delete"
               c_tview_delete :: Ptr RawTView -> IO ()

foreign import ccall interruptible "HROOTGrafTView.h TView_Front"
               c_tview_front :: Ptr RawTView -> IO ()

foreign import ccall interruptible
               "HROOTGrafTView.h TView_FrontView" c_tview_frontview ::
               Ptr RawTView -> Ptr RawTVirtualPad -> IO ()

foreign import ccall interruptible
               "HROOTGrafTView.h TView_GetLatitude" c_tview_getlatitude ::
               Ptr RawTView -> IO CDouble

foreign import ccall interruptible
               "HROOTGrafTView.h TView_GetLongitude" c_tview_getlongitude ::
               Ptr RawTView -> IO CDouble

foreign import ccall interruptible "HROOTGrafTView.h TView_GetPsi"
               c_tview_getpsi :: Ptr RawTView -> IO CDouble

foreign import ccall interruptible
               "HROOTGrafTView.h TView_IsViewChanged" c_tview_isviewchanged ::
               Ptr RawTView -> IO CBool

foreign import ccall interruptible
               "HROOTGrafTView.h TView_RotateView" c_tview_rotateview ::
               Ptr RawTView -> CDouble -> CDouble -> IO ()

foreign import ccall interruptible
               "HROOTGrafTView.h TView_SetLatitude" c_tview_setlatitude ::
               Ptr RawTView -> CDouble -> IO ()

foreign import ccall interruptible
               "HROOTGrafTView.h TView_SetLongitude" c_tview_setlongitude ::
               Ptr RawTView -> CDouble -> IO ()

foreign import ccall interruptible "HROOTGrafTView.h TView_SetPsi"
               c_tview_setpsi :: Ptr RawTView -> CDouble -> IO ()

foreign import ccall interruptible
               "HROOTGrafTView.h TView_SetView1" c_tview_setview1 ::
               Ptr RawTView -> CDouble -> CDouble -> CDouble -> Ptr CInt -> IO ()

foreign import ccall interruptible
               "HROOTGrafTView.h TView_SetViewChanged" c_tview_setviewchanged ::
               Ptr RawTView -> CBool -> IO ()

foreign import ccall interruptible "HROOTGrafTView.h TView_Side"
               c_tview_side :: Ptr RawTView -> IO ()

foreign import ccall interruptible
               "HROOTGrafTView.h TView_SideView" c_tview_sideview ::
               Ptr RawTView -> Ptr RawTVirtualPad -> IO ()

foreign import ccall interruptible "HROOTGrafTView.h TView_Top"
               c_tview_top :: Ptr RawTView -> IO ()

foreign import ccall interruptible "HROOTGrafTView.h TView_TopView"
               c_tview_topview :: Ptr RawTView -> Ptr RawTVirtualPad -> IO ()
