{-# LANGUAGE EmptyDataDecls, ExistentialQuantification,
  FlexibleContexts, FlexibleInstances, ForeignFunctionInterface,
  MultiParamTypeClasses, ScopedTypeVariables, TypeFamilies,
  TypeSynonymInstances #-}
module HROOT.Graf.TShape.Interface where
import Data.Word
import Data.Int
import Foreign.C
import Foreign.Ptr
import FFICXX.Runtime.Cast
import HROOT.Graf.TShape.RawType
import HROOT.Core.TNamed.Interface
import HROOT.Core.TAttLine.Interface
import HROOT.Core.TAttFill.Interface
import HROOT.Core.TAtt3D.Interface

class (ITNamed a, ITAttLine a, ITAttFill a, ITAtt3D a) => ITShape a
      where

upcastTShape :: forall a . (FPtr a, ITShape a) => a -> TShape
upcastTShape h
  = let fh = get_fptr h
        fh2 :: Ptr RawTShape = castPtr fh
      in cast_fptr_to_obj fh2

downcastTShape :: forall a . (FPtr a, ITShape a) => TShape -> a
downcastTShape h
  = let fh = get_fptr h
        fh2 = castPtr fh
      in cast_fptr_to_obj fh2
