{-# LANGUAGE EmptyDataDecls, FlexibleContexts, FlexibleInstances,
  ForeignFunctionInterface, IncoherentInstances,
  MultiParamTypeClasses, OverlappingInstances, TemplateHaskell,
  TypeFamilies, TypeSynonymInstances #-}
module HROOT.Graf.TShape.Implementation where
import Data.Monoid
import Data.Word
import Data.Int
import Foreign.C
import Foreign.Ptr
import Language.Haskell.TH
import Language.Haskell.TH.Syntax
import System.IO.Unsafe
import FFICXX.Runtime.Cast
import FFICXX.Runtime.CodeGen.Cxx
import FFICXX.Runtime.TH
import HROOT.Graf.TShape.RawType
import HROOT.Graf.TShape.FFI
import HROOT.Graf.TShape.Interface
import HROOT.Graf.TShape.Cast
import HROOT.Graf.TShape.RawType
import HROOT.Graf.TShape.Cast
import HROOT.Graf.TShape.Interface
import HROOT.Core.TClass.RawType
import HROOT.Core.TClass.Cast
import HROOT.Core.TClass.Interface
import HROOT.Core.TNamed.RawType
import HROOT.Core.TNamed.Cast
import HROOT.Core.TNamed.Interface
import HROOT.Core.TAttLine.RawType
import HROOT.Core.TAttLine.Cast
import HROOT.Core.TAttLine.Interface
import HROOT.Core.TAttFill.RawType
import HROOT.Core.TAttFill.Cast
import HROOT.Core.TAttFill.Interface
import HROOT.Core.TAtt3D.RawType
import HROOT.Core.TAtt3D.Cast
import HROOT.Core.TAtt3D.Interface
import HROOT.Core.TObject.RawType
import HROOT.Core.TObject.Cast
import HROOT.Core.TObject.Interface
import STD.Deletable.RawType
import STD.Deletable.Cast
import STD.Deletable.Interface

instance () => ITShape (TShape) where

instance () => ITNamed (TShape) where
        setName = xform1 c_tshape_setname
        setNameTitle = xform2 c_tshape_setnametitle
        setTitle = xform1 c_tshape_settitle

instance () => ITAttLine (TShape) where
        getLineColor = xform0 c_tshape_getlinecolor
        getLineStyle = xform0 c_tshape_getlinestyle
        getLineWidth = xform0 c_tshape_getlinewidth
        resetAttLine = xform1 c_tshape_resetattline
        setLineAttributes = xform0 c_tshape_setlineattributes
        setLineColor = xform1 c_tshape_setlinecolor
        setLineStyle = xform1 c_tshape_setlinestyle
        setLineWidth = xform1 c_tshape_setlinewidth

instance () => ITAttFill (TShape) where
        setFillColor = xform1 c_tshape_setfillcolor
        setFillStyle = xform1 c_tshape_setfillstyle

instance () => ITAtt3D (TShape) where

instance () => ITObject (TShape) where
        clear = xform1 c_tshape_clear
        draw = xform1 c_tshape_draw
        findObject = xform1 c_tshape_findobject
        getName = xform0 c_tshape_getname
        isA = xform0 c_tshape_isa
        paint = xform1 c_tshape_paint
        printObj = xform1 c_tshape_printobj
        saveAs = xform2 c_tshape_saveas
        write = xform3 c_tshape_write
        write_ = xform0 c_tshape_write_

instance () => IDeletable (TShape) where
        delete = xform0 c_tshape_delete

newTShape ::
            (Castable c2 CString, Castable c1 CString, Castable c0 CString) =>
            c0 -> c1 -> c2 -> IO TShape
newTShape = xform2 c_tshape_newtshape
