{-# LANGUAGE EmptyDataDecls, ExistentialQuantification,
  FlexibleContexts, FlexibleInstances, ForeignFunctionInterface,
  MultiParamTypeClasses, ScopedTypeVariables, TypeFamilies,
  TypeSynonymInstances #-}
module HROOT.Graf.TPad.Interface where
import Data.Word
import Data.Int
import Foreign.C
import Foreign.Ptr
import FFICXX.Runtime.Cast
import HROOT.Graf.TPad.RawType
import HROOT.Hist.TH1F.RawType
import HROOT.Graf.TView.RawType
import HROOT.Core.TVirtualPad.Interface
import HROOT.Graf.TView.Interface

class (ITVirtualPad a) => ITPad a where
        drawFrame ::
                    (Castable c0 CString) =>
                    a -> CDouble -> CDouble -> CDouble -> CDouble -> c0 -> IO TH1F
        
        getView :: () => a -> IO TView
        
        setView0 :: () => a -> IO ()
        
        setView :: (ITView c0, FPtr c0) => a -> c0 -> IO ()

upcastTPad :: forall a . (FPtr a, ITPad a) => a -> TPad
upcastTPad h
  = let fh = get_fptr h
        fh2 :: Ptr RawTPad = castPtr fh
      in cast_fptr_to_obj fh2

downcastTPad :: forall a . (FPtr a, ITPad a) => TPad -> a
downcastTPad h
  = let fh = get_fptr h
        fh2 = castPtr fh
      in cast_fptr_to_obj fh2
