{-# LANGUAGE ForeignFunctionInterface, InterruptibleFFI #-}
module HROOT.Graf.TPad.FFI where
import Data.Word
import Data.Int
import Foreign.C
import Foreign.Ptr
import HROOT.Graf.TPad.RawType
import HROOT.Graf.TPad.RawType
import HROOT.Core.TObject.RawType
import HROOT.Core.TClass.RawType
import HROOT.Hist.TH1F.RawType
import HROOT.Graf.TView.RawType

foreign import ccall interruptible "HROOTGrafTPad.h TPad_cd"
               c_tpad_cd :: Ptr RawTPad -> CInt -> IO (Ptr RawTPad)

foreign import ccall interruptible
               "HROOTGrafTPad.h TPad_divide_tvirtualpad" c_tpad_divide_tvirtualpad
               :: Ptr RawTPad -> CInt -> CInt -> CFloat -> CFloat -> CInt -> IO ()

foreign import ccall interruptible "HROOTGrafTPad.h TPad_Modified"
               c_tpad_modified :: Ptr RawTPad -> CBool -> IO ()

foreign import ccall interruptible "HROOTGrafTPad.h TPad_Range"
               c_tpad_range ::
               Ptr RawTPad -> CDouble -> CDouble -> CDouble -> CDouble -> IO ()

foreign import ccall interruptible "HROOTGrafTPad.h TPad_SetLogx"
               c_tpad_setlogx :: Ptr RawTPad -> CInt -> IO ()

foreign import ccall interruptible "HROOTGrafTPad.h TPad_SetLogy"
               c_tpad_setlogy :: Ptr RawTPad -> CInt -> IO ()

foreign import ccall interruptible "HROOTGrafTPad.h TPad_SetLogz"
               c_tpad_setlogz :: Ptr RawTPad -> CInt -> IO ()

foreign import ccall interruptible "HROOTGrafTPad.h TPad_Update"
               c_tpad_update :: Ptr RawTPad -> IO ()

foreign import ccall interruptible "HROOTGrafTPad.h TPad_Clear"
               c_tpad_clear :: Ptr RawTPad -> CString -> IO ()

foreign import ccall interruptible "HROOTGrafTPad.h TPad_Draw"
               c_tpad_draw :: Ptr RawTPad -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTPad.h TPad_FindObject" c_tpad_findobject ::
               Ptr RawTPad -> CString -> IO (Ptr RawTObject)

foreign import ccall interruptible "HROOTGrafTPad.h TPad_GetName"
               c_tpad_getname :: Ptr RawTPad -> IO CString

foreign import ccall interruptible "HROOTGrafTPad.h TPad_IsA"
               c_tpad_isa :: Ptr RawTPad -> IO (Ptr RawTClass)

foreign import ccall interruptible "HROOTGrafTPad.h TPad_Paint"
               c_tpad_paint :: Ptr RawTPad -> CString -> IO ()

foreign import ccall interruptible "HROOTGrafTPad.h TPad_printObj"
               c_tpad_printobj :: Ptr RawTPad -> CString -> IO ()

foreign import ccall interruptible "HROOTGrafTPad.h TPad_SaveAs"
               c_tpad_saveas :: Ptr RawTPad -> CString -> CString -> IO ()

foreign import ccall interruptible "HROOTGrafTPad.h TPad_Write"
               c_tpad_write :: Ptr RawTPad -> CString -> CInt -> CInt -> IO CInt

foreign import ccall interruptible "HROOTGrafTPad.h TPad_Write_"
               c_tpad_write_ :: Ptr RawTPad -> IO CInt

foreign import ccall interruptible
               "HROOTGrafTPad.h TPad_GetLineColor" c_tpad_getlinecolor ::
               Ptr RawTPad -> IO CShort

foreign import ccall interruptible
               "HROOTGrafTPad.h TPad_GetLineStyle" c_tpad_getlinestyle ::
               Ptr RawTPad -> IO CShort

foreign import ccall interruptible
               "HROOTGrafTPad.h TPad_GetLineWidth" c_tpad_getlinewidth ::
               Ptr RawTPad -> IO CShort

foreign import ccall interruptible
               "HROOTGrafTPad.h TPad_ResetAttLine" c_tpad_resetattline ::
               Ptr RawTPad -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTPad.h TPad_SetLineAttributes" c_tpad_setlineattributes
               :: Ptr RawTPad -> IO ()

foreign import ccall interruptible
               "HROOTGrafTPad.h TPad_SetLineColor" c_tpad_setlinecolor ::
               Ptr RawTPad -> CShort -> IO ()

foreign import ccall interruptible
               "HROOTGrafTPad.h TPad_SetLineStyle" c_tpad_setlinestyle ::
               Ptr RawTPad -> CShort -> IO ()

foreign import ccall interruptible
               "HROOTGrafTPad.h TPad_SetLineWidth" c_tpad_setlinewidth ::
               Ptr RawTPad -> CShort -> IO ()

foreign import ccall interruptible
               "HROOTGrafTPad.h TPad_SetFillColor" c_tpad_setfillcolor ::
               Ptr RawTPad -> CInt -> IO ()

foreign import ccall interruptible
               "HROOTGrafTPad.h TPad_SetFillStyle" c_tpad_setfillstyle ::
               Ptr RawTPad -> CInt -> IO ()

foreign import ccall interruptible
               "HROOTGrafTPad.h TPad_ResetAttPad" c_tpad_resetattpad ::
               Ptr RawTPad -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTPad.h TPad_SetBottomMargin" c_tpad_setbottommargin ::
               Ptr RawTPad -> CFloat -> IO ()

foreign import ccall interruptible
               "HROOTGrafTPad.h TPad_SetLeftMargin" c_tpad_setleftmargin ::
               Ptr RawTPad -> CFloat -> IO ()

foreign import ccall interruptible
               "HROOTGrafTPad.h TPad_SetRightMargin" c_tpad_setrightmargin ::
               Ptr RawTPad -> CFloat -> IO ()

foreign import ccall interruptible
               "HROOTGrafTPad.h TPad_SetTopMargin" c_tpad_settopmargin ::
               Ptr RawTPad -> CFloat -> IO ()

foreign import ccall interruptible "HROOTGrafTPad.h TPad_SetMargin"
               c_tpad_setmargin ::
               Ptr RawTPad -> CFloat -> CFloat -> CFloat -> CFloat -> IO ()

foreign import ccall interruptible "HROOTGrafTPad.h TPad_SetAfile"
               c_tpad_setafile :: Ptr RawTPad -> CFloat -> IO ()

foreign import ccall interruptible "HROOTGrafTPad.h TPad_SetXfile"
               c_tpad_setxfile :: Ptr RawTPad -> CFloat -> IO ()

foreign import ccall interruptible "HROOTGrafTPad.h TPad_SetYfile"
               c_tpad_setyfile :: Ptr RawTPad -> CFloat -> IO ()

foreign import ccall interruptible "HROOTGrafTPad.h TPad_SetAstat"
               c_tpad_setastat :: Ptr RawTPad -> CFloat -> IO ()

foreign import ccall interruptible "HROOTGrafTPad.h TPad_SetXstat"
               c_tpad_setxstat :: Ptr RawTPad -> CFloat -> IO ()

foreign import ccall interruptible "HROOTGrafTPad.h TPad_SetYstat"
               c_tpad_setystat :: Ptr RawTPad -> CFloat -> IO ()

foreign import ccall interruptible "HROOTGrafTPad.h TPad_delete"
               c_tpad_delete :: Ptr RawTPad -> IO ()

foreign import ccall interruptible "HROOTGrafTPad.h TPad_newTPad"
               c_tpad_newtpad ::
               CString ->
                 CString ->
                   CDouble -> CDouble -> CDouble -> CDouble -> IO (Ptr RawTPad)

foreign import ccall interruptible "HROOTGrafTPad.h TPad_DrawFrame"
               c_tpad_drawframe ::
               Ptr RawTPad ->
                 CDouble ->
                   CDouble -> CDouble -> CDouble -> CString -> IO (Ptr RawTH1F)

foreign import ccall interruptible "HROOTGrafTPad.h TPad_GetView"
               c_tpad_getview :: Ptr RawTPad -> IO (Ptr RawTView)

foreign import ccall interruptible "HROOTGrafTPad.h TPad_SetView0"
               c_tpad_setview0 :: Ptr RawTPad -> IO ()

foreign import ccall interruptible "HROOTGrafTPad.h TPad_SetView"
               c_tpad_setview :: Ptr RawTPad -> Ptr RawTView -> IO ()
