{-# LANGUAGE EmptyDataDecls, ExistentialQuantification,
  FlexibleContexts, FlexibleInstances, ForeignFunctionInterface,
  MultiParamTypeClasses, ScopedTypeVariables, TypeFamilies,
  TypeSynonymInstances #-}
module HROOT.Graf.TMarker.Interface where
import Data.Word
import Data.Int
import Foreign.C
import Foreign.Ptr
import FFICXX.Runtime.Cast
import HROOT.Graf.TMarker.RawType
import HROOT.Core.TObject.Interface
import HROOT.Core.TAttMarker.Interface
import HROOT.Core.TAttBBox2D.Interface

class (ITObject a, ITAttMarker a, ITAttBBox2D a) => ITMarker a
      where
        setX :: () => a -> CDouble -> IO ()
        
        setY :: () => a -> CDouble -> IO ()

upcastTMarker :: forall a . (FPtr a, ITMarker a) => a -> TMarker
upcastTMarker h
  = let fh = get_fptr h
        fh2 :: Ptr RawTMarker = castPtr fh
      in cast_fptr_to_obj fh2

downcastTMarker :: forall a . (FPtr a, ITMarker a) => TMarker -> a
downcastTMarker h
  = let fh = get_fptr h
        fh2 = castPtr fh
      in cast_fptr_to_obj fh2
