{-# LANGUAGE EmptyDataDecls, FlexibleContexts, FlexibleInstances,
  ForeignFunctionInterface, IncoherentInstances,
  MultiParamTypeClasses, OverlappingInstances, TemplateHaskell,
  TypeFamilies, TypeSynonymInstances #-}
module HROOT.Graf.TMarker.Implementation where
import Data.Monoid
import Data.Word
import Data.Int
import Foreign.C
import Foreign.Ptr
import Language.Haskell.TH
import Language.Haskell.TH.Syntax
import System.IO.Unsafe
import FFICXX.Runtime.Cast
import FFICXX.Runtime.CodeGen.Cxx
import FFICXX.Runtime.TH
import HROOT.Graf.TMarker.RawType
import HROOT.Graf.TMarker.FFI
import HROOT.Graf.TMarker.Interface
import HROOT.Graf.TMarker.Cast
import HROOT.Graf.TMarker.RawType
import HROOT.Graf.TMarker.Cast
import HROOT.Graf.TMarker.Interface
import HROOT.Core.TClass.RawType
import HROOT.Core.TClass.Cast
import HROOT.Core.TClass.Interface
import HROOT.Core.Rectangle_t.RawType
import HROOT.Core.Rectangle_t.Cast
import HROOT.Core.Rectangle_t.Interface
import HROOT.Core.TObject.RawType
import HROOT.Core.TObject.Cast
import HROOT.Core.TObject.Interface
import HROOT.Core.TAttMarker.RawType
import HROOT.Core.TAttMarker.Cast
import HROOT.Core.TAttMarker.Interface
import HROOT.Core.TAttBBox2D.RawType
import HROOT.Core.TAttBBox2D.Cast
import HROOT.Core.TAttBBox2D.Interface
import STD.Deletable.RawType
import STD.Deletable.Cast
import STD.Deletable.Interface

instance () => ITMarker (TMarker) where
        setX = xform1 c_tmarker_setx
        setY = xform1 c_tmarker_sety

instance () => ITObject (TMarker) where
        clear = xform1 c_tmarker_clear
        draw = xform1 c_tmarker_draw
        findObject = xform1 c_tmarker_findobject
        getName = xform0 c_tmarker_getname
        isA = xform0 c_tmarker_isa
        paint = xform1 c_tmarker_paint
        printObj = xform1 c_tmarker_printobj
        saveAs = xform2 c_tmarker_saveas
        write = xform3 c_tmarker_write
        write_ = xform0 c_tmarker_write_

instance () => ITAttMarker (TMarker) where
        getMarkerColor = xform0 c_tmarker_getmarkercolor
        getMarkerStyle = xform0 c_tmarker_getmarkerstyle
        getMarkerSize = xform0 c_tmarker_getmarkersize
        resetAttMarker = xform1 c_tmarker_resetattmarker
        setMarkerAttributes = xform0 c_tmarker_setmarkerattributes
        setMarkerColor = xform1 c_tmarker_setmarkercolor
        setMarkerStyle = xform1 c_tmarker_setmarkerstyle
        setMarkerSize = xform1 c_tmarker_setmarkersize

instance () => ITAttBBox2D (TMarker) where
        getBBox = xform0 c_tmarker_getbbox
        setBBoxX1 = xform1 c_tmarker_setbboxx1
        setBBoxX2 = xform1 c_tmarker_setbboxx2
        setBBoxY1 = xform1 c_tmarker_setbboxy1
        setBBoxY2 = xform1 c_tmarker_setbboxy2

instance () => IDeletable (TMarker) where
        delete = xform0 c_tmarker_delete

newTMarker :: () => CDouble -> CDouble -> CInt -> IO TMarker
newTMarker = xform2 c_tmarker_newtmarker

tMarker_GetX :: () => TMarker -> IO CDouble
tMarker_GetX = xform0 c_tmarker_tmarker_getx

tMarker_GetY :: () => TMarker -> IO CDouble
tMarker_GetY = xform0 c_tmarker_tmarker_gety
