{-# LANGUAGE ForeignFunctionInterface, InterruptibleFFI #-}
module HROOT.Graf.TMarker.FFI where
import Data.Word
import Data.Int
import Foreign.C
import Foreign.Ptr
import HROOT.Graf.TMarker.RawType
import HROOT.Graf.TMarker.RawType
import HROOT.Core.TObject.RawType
import HROOT.Core.TClass.RawType
import HROOT.Core.Rectangle_t.RawType

foreign import ccall interruptible
               "HROOTGrafTMarker.h TMarker_Clear" c_tmarker_clear ::
               Ptr RawTMarker -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTMarker.h TMarker_Draw" c_tmarker_draw ::
               Ptr RawTMarker -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTMarker.h TMarker_FindObject" c_tmarker_findobject ::
               Ptr RawTMarker -> CString -> IO (Ptr RawTObject)

foreign import ccall interruptible
               "HROOTGrafTMarker.h TMarker_GetName" c_tmarker_getname ::
               Ptr RawTMarker -> IO CString

foreign import ccall interruptible "HROOTGrafTMarker.h TMarker_IsA"
               c_tmarker_isa :: Ptr RawTMarker -> IO (Ptr RawTClass)

foreign import ccall interruptible
               "HROOTGrafTMarker.h TMarker_Paint" c_tmarker_paint ::
               Ptr RawTMarker -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTMarker.h TMarker_printObj" c_tmarker_printobj ::
               Ptr RawTMarker -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTMarker.h TMarker_SaveAs" c_tmarker_saveas ::
               Ptr RawTMarker -> CString -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTMarker.h TMarker_Write" c_tmarker_write ::
               Ptr RawTMarker -> CString -> CInt -> CInt -> IO CInt

foreign import ccall interruptible
               "HROOTGrafTMarker.h TMarker_Write_" c_tmarker_write_ ::
               Ptr RawTMarker -> IO CInt

foreign import ccall interruptible
               "HROOTGrafTMarker.h TMarker_GetMarkerColor"
               c_tmarker_getmarkercolor :: Ptr RawTMarker -> IO CShort

foreign import ccall interruptible
               "HROOTGrafTMarker.h TMarker_GetMarkerStyle"
               c_tmarker_getmarkerstyle :: Ptr RawTMarker -> IO CShort

foreign import ccall interruptible
               "HROOTGrafTMarker.h TMarker_GetMarkerSize" c_tmarker_getmarkersize
               :: Ptr RawTMarker -> IO CFloat

foreign import ccall interruptible
               "HROOTGrafTMarker.h TMarker_ResetAttMarker"
               c_tmarker_resetattmarker :: Ptr RawTMarker -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTMarker.h TMarker_SetMarkerAttributes"
               c_tmarker_setmarkerattributes :: Ptr RawTMarker -> IO ()

foreign import ccall interruptible
               "HROOTGrafTMarker.h TMarker_SetMarkerColor"
               c_tmarker_setmarkercolor :: Ptr RawTMarker -> CShort -> IO ()

foreign import ccall interruptible
               "HROOTGrafTMarker.h TMarker_SetMarkerStyle"
               c_tmarker_setmarkerstyle :: Ptr RawTMarker -> CShort -> IO ()

foreign import ccall interruptible
               "HROOTGrafTMarker.h TMarker_SetMarkerSize" c_tmarker_setmarkersize
               :: Ptr RawTMarker -> CShort -> IO ()

foreign import ccall interruptible
               "HROOTGrafTMarker.h TMarker_GetBBox" c_tmarker_getbbox ::
               Ptr RawTMarker -> IO (Ptr RawRectangle_t)

foreign import ccall interruptible
               "HROOTGrafTMarker.h TMarker_SetBBoxX1" c_tmarker_setbboxx1 ::
               Ptr RawTMarker -> CInt -> IO ()

foreign import ccall interruptible
               "HROOTGrafTMarker.h TMarker_SetBBoxX2" c_tmarker_setbboxx2 ::
               Ptr RawTMarker -> CInt -> IO ()

foreign import ccall interruptible
               "HROOTGrafTMarker.h TMarker_SetBBoxY1" c_tmarker_setbboxy1 ::
               Ptr RawTMarker -> CInt -> IO ()

foreign import ccall interruptible
               "HROOTGrafTMarker.h TMarker_SetBBoxY2" c_tmarker_setbboxy2 ::
               Ptr RawTMarker -> CInt -> IO ()

foreign import ccall interruptible
               "HROOTGrafTMarker.h TMarker_delete" c_tmarker_delete ::
               Ptr RawTMarker -> IO ()

foreign import ccall interruptible
               "HROOTGrafTMarker.h TMarker_newTMarker" c_tmarker_newtmarker ::
               CDouble -> CDouble -> CInt -> IO (Ptr RawTMarker)

foreign import ccall interruptible
               "HROOTGrafTMarker.h TMarker_tMarker_GetX" c_tmarker_tmarker_getx ::
               Ptr RawTMarker -> IO CDouble

foreign import ccall interruptible
               "HROOTGrafTMarker.h TMarker_tMarker_GetY" c_tmarker_tmarker_gety ::
               Ptr RawTMarker -> IO CDouble

foreign import ccall interruptible
               "HROOTGrafTMarker.h TMarker_SetX" c_tmarker_setx ::
               Ptr RawTMarker -> CDouble -> IO ()

foreign import ccall interruptible
               "HROOTGrafTMarker.h TMarker_SetY" c_tmarker_sety ::
               Ptr RawTMarker -> CDouble -> IO ()
