{-# LANGUAGE EmptyDataDecls, ExistentialQuantification,
  FlexibleContexts, FlexibleInstances, ForeignFunctionInterface,
  MultiParamTypeClasses, ScopedTypeVariables, TypeFamilies,
  TypeSynonymInstances #-}
module HROOT.Graf.TLine.Interface where
import Data.Word
import Data.Int
import Foreign.C
import Foreign.Ptr
import FFICXX.Runtime.Cast
import HROOT.Graf.TLine.RawType
import HROOT.Core.TObject.Interface
import HROOT.Core.TAttLine.Interface

class (ITObject a, ITAttLine a) => ITLine a where
        drawLine ::
                   () => a -> CDouble -> CDouble -> CDouble -> CDouble -> IO TLine
        
        drawLineNDC ::
                      () => a -> CDouble -> CDouble -> CDouble -> CDouble -> IO TLine
        
        paintLine ::
                    () => a -> CDouble -> CDouble -> CDouble -> CDouble -> IO ()
        
        paintLineNDC ::
                       () => a -> CDouble -> CDouble -> CDouble -> CDouble -> IO ()
        
        setX1 :: () => a -> CDouble -> IO ()
        
        setX2 :: () => a -> CDouble -> IO ()
        
        setY1 :: () => a -> CDouble -> IO ()
        
        setY2 :: () => a -> CDouble -> IO ()

upcastTLine :: forall a . (FPtr a, ITLine a) => a -> TLine
upcastTLine h
  = let fh = get_fptr h
        fh2 :: Ptr RawTLine = castPtr fh
      in cast_fptr_to_obj fh2

downcastTLine :: forall a . (FPtr a, ITLine a) => TLine -> a
downcastTLine h
  = let fh = get_fptr h
        fh2 = castPtr fh
      in cast_fptr_to_obj fh2
