{-# LANGUAGE EmptyDataDecls, FlexibleContexts, FlexibleInstances,
  ForeignFunctionInterface, IncoherentInstances,
  MultiParamTypeClasses, OverlappingInstances, TemplateHaskell,
  TypeFamilies, TypeSynonymInstances #-}
module HROOT.Graf.TLine.Implementation where
import Data.Monoid
import Data.Word
import Data.Int
import Foreign.C
import Foreign.Ptr
import Language.Haskell.TH
import Language.Haskell.TH.Syntax
import System.IO.Unsafe
import FFICXX.Runtime.Cast
import FFICXX.Runtime.CodeGen.Cxx
import FFICXX.Runtime.TH
import HROOT.Graf.TLine.RawType
import HROOT.Graf.TLine.FFI
import HROOT.Graf.TLine.Interface
import HROOT.Graf.TLine.Cast
import HROOT.Graf.TLine.RawType
import HROOT.Graf.TLine.Cast
import HROOT.Graf.TLine.Interface
import HROOT.Core.TClass.RawType
import HROOT.Core.TClass.Cast
import HROOT.Core.TClass.Interface
import HROOT.Core.TObject.RawType
import HROOT.Core.TObject.Cast
import HROOT.Core.TObject.Interface
import HROOT.Core.TAttLine.RawType
import HROOT.Core.TAttLine.Cast
import HROOT.Core.TAttLine.Interface
import STD.Deletable.RawType
import STD.Deletable.Cast
import STD.Deletable.Interface

instance () => ITLine (TLine) where
        drawLine = xform4 c_tline_drawline
        drawLineNDC = xform4 c_tline_drawlinendc
        paintLine = xform4 c_tline_paintline
        paintLineNDC = xform4 c_tline_paintlinendc
        setX1 = xform1 c_tline_setx1
        setX2 = xform1 c_tline_setx2
        setY1 = xform1 c_tline_sety1
        setY2 = xform1 c_tline_sety2

instance () => ITObject (TLine) where
        clear = xform1 c_tline_clear
        draw = xform1 c_tline_draw
        findObject = xform1 c_tline_findobject
        getName = xform0 c_tline_getname
        isA = xform0 c_tline_isa
        paint = xform1 c_tline_paint
        printObj = xform1 c_tline_printobj
        saveAs = xform2 c_tline_saveas
        write = xform3 c_tline_write
        write_ = xform0 c_tline_write_

instance () => ITAttLine (TLine) where
        getLineColor = xform0 c_tline_getlinecolor
        getLineStyle = xform0 c_tline_getlinestyle
        getLineWidth = xform0 c_tline_getlinewidth
        resetAttLine = xform1 c_tline_resetattline
        setLineAttributes = xform0 c_tline_setlineattributes
        setLineColor = xform1 c_tline_setlinecolor
        setLineStyle = xform1 c_tline_setlinestyle
        setLineWidth = xform1 c_tline_setlinewidth

instance () => IDeletable (TLine) where
        delete = xform0 c_tline_delete

newTLine ::
           () => CDouble -> CDouble -> CDouble -> CDouble -> IO TLine
newTLine = xform3 c_tline_newtline

tLine_GetX1 :: () => TLine -> IO CDouble
tLine_GetX1 = xform0 c_tline_tline_getx1

tLine_GetX2 :: () => TLine -> IO CDouble
tLine_GetX2 = xform0 c_tline_tline_getx2

tLine_GetY1 :: () => TLine -> IO CDouble
tLine_GetY1 = xform0 c_tline_tline_gety1

tLine_GetY2 :: () => TLine -> IO CDouble
tLine_GetY2 = xform0 c_tline_tline_gety2

tLine_IsHorizontal :: () => TLine -> IO CBool
tLine_IsHorizontal = xform0 c_tline_tline_ishorizontal

tLine_IsVertical :: () => TLine -> IO CBool
tLine_IsVertical = xform0 c_tline_tline_isvertical

tLine_SetHorizontal :: () => TLine -> CBool -> IO ()
tLine_SetHorizontal = xform1 c_tline_tline_sethorizontal

tLine_SetVertical :: () => TLine -> CBool -> IO ()
tLine_SetVertical = xform1 c_tline_tline_setvertical
