{-# LANGUAGE ForeignFunctionInterface, InterruptibleFFI #-}
module HROOT.Graf.TLine.FFI where
import Data.Word
import Data.Int
import Foreign.C
import Foreign.Ptr
import HROOT.Graf.TLine.RawType
import HROOT.Graf.TLine.RawType
import HROOT.Core.TObject.RawType
import HROOT.Core.TClass.RawType

foreign import ccall interruptible "HROOTGrafTLine.h TLine_Clear"
               c_tline_clear :: Ptr RawTLine -> CString -> IO ()

foreign import ccall interruptible "HROOTGrafTLine.h TLine_Draw"
               c_tline_draw :: Ptr RawTLine -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTLine.h TLine_FindObject" c_tline_findobject ::
               Ptr RawTLine -> CString -> IO (Ptr RawTObject)

foreign import ccall interruptible "HROOTGrafTLine.h TLine_GetName"
               c_tline_getname :: Ptr RawTLine -> IO CString

foreign import ccall interruptible "HROOTGrafTLine.h TLine_IsA"
               c_tline_isa :: Ptr RawTLine -> IO (Ptr RawTClass)

foreign import ccall interruptible "HROOTGrafTLine.h TLine_Paint"
               c_tline_paint :: Ptr RawTLine -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTLine.h TLine_printObj" c_tline_printobj ::
               Ptr RawTLine -> CString -> IO ()

foreign import ccall interruptible "HROOTGrafTLine.h TLine_SaveAs"
               c_tline_saveas :: Ptr RawTLine -> CString -> CString -> IO ()

foreign import ccall interruptible "HROOTGrafTLine.h TLine_Write"
               c_tline_write :: Ptr RawTLine -> CString -> CInt -> CInt -> IO CInt

foreign import ccall interruptible "HROOTGrafTLine.h TLine_Write_"
               c_tline_write_ :: Ptr RawTLine -> IO CInt

foreign import ccall interruptible
               "HROOTGrafTLine.h TLine_GetLineColor" c_tline_getlinecolor ::
               Ptr RawTLine -> IO CShort

foreign import ccall interruptible
               "HROOTGrafTLine.h TLine_GetLineStyle" c_tline_getlinestyle ::
               Ptr RawTLine -> IO CShort

foreign import ccall interruptible
               "HROOTGrafTLine.h TLine_GetLineWidth" c_tline_getlinewidth ::
               Ptr RawTLine -> IO CShort

foreign import ccall interruptible
               "HROOTGrafTLine.h TLine_ResetAttLine" c_tline_resetattline ::
               Ptr RawTLine -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTLine.h TLine_SetLineAttributes"
               c_tline_setlineattributes :: Ptr RawTLine -> IO ()

foreign import ccall interruptible
               "HROOTGrafTLine.h TLine_SetLineColor" c_tline_setlinecolor ::
               Ptr RawTLine -> CShort -> IO ()

foreign import ccall interruptible
               "HROOTGrafTLine.h TLine_SetLineStyle" c_tline_setlinestyle ::
               Ptr RawTLine -> CShort -> IO ()

foreign import ccall interruptible
               "HROOTGrafTLine.h TLine_SetLineWidth" c_tline_setlinewidth ::
               Ptr RawTLine -> CShort -> IO ()

foreign import ccall interruptible "HROOTGrafTLine.h TLine_delete"
               c_tline_delete :: Ptr RawTLine -> IO ()

foreign import ccall interruptible
               "HROOTGrafTLine.h TLine_newTLine" c_tline_newtline ::
               CDouble -> CDouble -> CDouble -> CDouble -> IO (Ptr RawTLine)

foreign import ccall interruptible
               "HROOTGrafTLine.h TLine_DrawLine" c_tline_drawline ::
               Ptr RawTLine ->
                 CDouble -> CDouble -> CDouble -> CDouble -> IO (Ptr RawTLine)

foreign import ccall interruptible
               "HROOTGrafTLine.h TLine_DrawLineNDC" c_tline_drawlinendc ::
               Ptr RawTLine ->
                 CDouble -> CDouble -> CDouble -> CDouble -> IO (Ptr RawTLine)

foreign import ccall interruptible
               "HROOTGrafTLine.h TLine_tLine_GetX1" c_tline_tline_getx1 ::
               Ptr RawTLine -> IO CDouble

foreign import ccall interruptible
               "HROOTGrafTLine.h TLine_tLine_GetX2" c_tline_tline_getx2 ::
               Ptr RawTLine -> IO CDouble

foreign import ccall interruptible
               "HROOTGrafTLine.h TLine_tLine_GetY1" c_tline_tline_gety1 ::
               Ptr RawTLine -> IO CDouble

foreign import ccall interruptible
               "HROOTGrafTLine.h TLine_tLine_GetY2" c_tline_tline_gety2 ::
               Ptr RawTLine -> IO CDouble

foreign import ccall interruptible
               "HROOTGrafTLine.h TLine_tLine_IsHorizontal"
               c_tline_tline_ishorizontal :: Ptr RawTLine -> IO CBool

foreign import ccall interruptible
               "HROOTGrafTLine.h TLine_tLine_IsVertical" c_tline_tline_isvertical
               :: Ptr RawTLine -> IO CBool

foreign import ccall interruptible
               "HROOTGrafTLine.h TLine_PaintLine" c_tline_paintline ::
               Ptr RawTLine -> CDouble -> CDouble -> CDouble -> CDouble -> IO ()

foreign import ccall interruptible
               "HROOTGrafTLine.h TLine_PaintLineNDC" c_tline_paintlinendc ::
               Ptr RawTLine -> CDouble -> CDouble -> CDouble -> CDouble -> IO ()

foreign import ccall interruptible
               "HROOTGrafTLine.h TLine_tLine_SetHorizontal"
               c_tline_tline_sethorizontal :: Ptr RawTLine -> CBool -> IO ()

foreign import ccall interruptible
               "HROOTGrafTLine.h TLine_tLine_SetVertical"
               c_tline_tline_setvertical :: Ptr RawTLine -> CBool -> IO ()

foreign import ccall interruptible "HROOTGrafTLine.h TLine_SetX1"
               c_tline_setx1 :: Ptr RawTLine -> CDouble -> IO ()

foreign import ccall interruptible "HROOTGrafTLine.h TLine_SetX2"
               c_tline_setx2 :: Ptr RawTLine -> CDouble -> IO ()

foreign import ccall interruptible "HROOTGrafTLine.h TLine_SetY1"
               c_tline_sety1 :: Ptr RawTLine -> CDouble -> IO ()

foreign import ccall interruptible "HROOTGrafTLine.h TLine_SetY2"
               c_tline_sety2 :: Ptr RawTLine -> CDouble -> IO ()
