{-# LANGUAGE EmptyDataDecls, ExistentialQuantification,
  FlexibleContexts, FlexibleInstances, ForeignFunctionInterface,
  MultiParamTypeClasses, ScopedTypeVariables, TypeFamilies,
  TypeSynonymInstances #-}
module HROOT.Graf.TGraphQQ.Interface where
import Data.Word
import Data.Int
import Foreign.C
import Foreign.Ptr
import FFICXX.Runtime.Cast
import HROOT.Graf.TGraphQQ.RawType
import HROOT.Hist.TGraph.Interface

class (ITGraph a) => ITGraphQQ a where

upcastTGraphQQ :: forall a . (FPtr a, ITGraphQQ a) => a -> TGraphQQ
upcastTGraphQQ h
  = let fh = get_fptr h
        fh2 :: Ptr RawTGraphQQ = castPtr fh
      in cast_fptr_to_obj fh2

downcastTGraphQQ ::
                 forall a . (FPtr a, ITGraphQQ a) => TGraphQQ -> a
downcastTGraphQQ h
  = let fh = get_fptr h
        fh2 = castPtr fh
      in cast_fptr_to_obj fh2
