{-# LANGUAGE ForeignFunctionInterface, InterruptibleFFI #-}
module HROOT.Graf.TGraphPolar.FFI where
import Data.Word
import Data.Int
import Foreign.C
import Foreign.Ptr
import HROOT.Graf.TGraphPolar.RawType
import HROOT.Graf.TGraphPolar.RawType
import HROOT.Hist.TF1.RawType
import HROOT.Hist.TH1F.RawType
import HROOT.Hist.TAxis.RawType
import HROOT.Core.TObject.RawType
import HROOT.Core.TClass.RawType

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_SetPointError"
               c_tgraphpolar_setpointerror ::
               Ptr RawTGraphPolar -> CInt -> CDouble -> CDouble -> IO ()

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_Apply" c_tgraphpolar_apply ::
               Ptr RawTGraphPolar -> Ptr RawTF1 -> IO ()

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_Chisquare"
               c_tgraphpolar_chisquare ::
               Ptr RawTGraphPolar -> Ptr RawTF1 -> IO CDouble

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_DrawGraph"
               c_tgraphpolar_drawgraph ::
               Ptr RawTGraphPolar ->
                 CInt -> Ptr CDouble -> Ptr CDouble -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_drawPanelTGraph"
               c_tgraphpolar_drawpaneltgraph :: Ptr RawTGraphPolar -> IO ()

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_Expand" c_tgraphpolar_expand ::
               Ptr RawTGraphPolar -> CInt -> CInt -> IO ()

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_FitPanelTGraph"
               c_tgraphpolar_fitpaneltgraph :: Ptr RawTGraphPolar -> IO ()

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_getCorrelationFactorTGraph"
               c_tgraphpolar_getcorrelationfactortgraph ::
               Ptr RawTGraphPolar -> IO CDouble

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_getCovarianceTGraph"
               c_tgraphpolar_getcovariancetgraph ::
               Ptr RawTGraphPolar -> IO CDouble

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_getMeanTGraph"
               c_tgraphpolar_getmeantgraph ::
               Ptr RawTGraphPolar -> CInt -> IO CDouble

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_getRMSTGraph"
               c_tgraphpolar_getrmstgraph ::
               Ptr RawTGraphPolar -> CInt -> IO CDouble

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_GetErrorX"
               c_tgraphpolar_geterrorx :: Ptr RawTGraphPolar -> CInt -> IO CDouble

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_GetErrorY"
               c_tgraphpolar_geterrory :: Ptr RawTGraphPolar -> CInt -> IO CDouble

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_GetErrorXhigh"
               c_tgraphpolar_geterrorxhigh ::
               Ptr RawTGraphPolar -> CInt -> IO CDouble

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_GetErrorXlow"
               c_tgraphpolar_geterrorxlow ::
               Ptr RawTGraphPolar -> CInt -> IO CDouble

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_GetErrorYhigh"
               c_tgraphpolar_geterroryhigh ::
               Ptr RawTGraphPolar -> CInt -> IO CDouble

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_GetErrorYlow"
               c_tgraphpolar_geterrorylow ::
               Ptr RawTGraphPolar -> CInt -> IO CDouble

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_InitExpo"
               c_tgraphpolar_initexpo ::
               Ptr RawTGraphPolar -> CDouble -> CDouble -> IO ()

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_InitGaus"
               c_tgraphpolar_initgaus ::
               Ptr RawTGraphPolar -> CDouble -> CDouble -> IO ()

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_InitPolynom"
               c_tgraphpolar_initpolynom ::
               Ptr RawTGraphPolar -> CDouble -> CDouble -> IO ()

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_InsertPoint"
               c_tgraphpolar_insertpoint :: Ptr RawTGraphPolar -> IO CInt

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_integralTGraph"
               c_tgraphpolar_integraltgraph ::
               Ptr RawTGraphPolar -> CInt -> CInt -> IO CDouble

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_IsEditable"
               c_tgraphpolar_iseditable :: Ptr RawTGraphPolar -> IO CBool

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_isInsideTGraph"
               c_tgraphpolar_isinsidetgraph ::
               Ptr RawTGraphPolar -> CDouble -> CDouble -> IO CInt

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_LeastSquareFit"
               c_tgraphpolar_leastsquarefit ::
               Ptr RawTGraphPolar ->
                 CInt -> Ptr CDouble -> CDouble -> CDouble -> IO ()

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_PaintStats"
               c_tgraphpolar_paintstats ::
               Ptr RawTGraphPolar -> Ptr RawTF1 -> IO ()

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_RemovePoint"
               c_tgraphpolar_removepoint :: Ptr RawTGraphPolar -> CInt -> IO CInt

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_SetEditable"
               c_tgraphpolar_seteditable :: Ptr RawTGraphPolar -> CBool -> IO ()

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_SetHistogram"
               c_tgraphpolar_sethistogram ::
               Ptr RawTGraphPolar -> Ptr RawTH1F -> IO ()

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_setMaximumTGraph"
               c_tgraphpolar_setmaximumtgraph ::
               Ptr RawTGraphPolar -> CDouble -> IO ()

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_setMinimumTGraph"
               c_tgraphpolar_setminimumtgraph ::
               Ptr RawTGraphPolar -> CDouble -> IO ()

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_Set" c_tgraphpolar_set ::
               Ptr RawTGraphPolar -> CInt -> IO ()

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_SetPoint"
               c_tgraphpolar_setpoint ::
               Ptr RawTGraphPolar -> CInt -> CDouble -> CDouble -> IO ()

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_SetName" c_tgraphpolar_setname
               :: Ptr RawTGraphPolar -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_SetNameTitle"
               c_tgraphpolar_setnametitle ::
               Ptr RawTGraphPolar -> CString -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_SetTitle"
               c_tgraphpolar_settitle :: Ptr RawTGraphPolar -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_GetLineColor"
               c_tgraphpolar_getlinecolor :: Ptr RawTGraphPolar -> IO CShort

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_GetLineStyle"
               c_tgraphpolar_getlinestyle :: Ptr RawTGraphPolar -> IO CShort

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_GetLineWidth"
               c_tgraphpolar_getlinewidth :: Ptr RawTGraphPolar -> IO CShort

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_ResetAttLine"
               c_tgraphpolar_resetattline ::
               Ptr RawTGraphPolar -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_SetLineAttributes"
               c_tgraphpolar_setlineattributes :: Ptr RawTGraphPolar -> IO ()

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_SetLineColor"
               c_tgraphpolar_setlinecolor :: Ptr RawTGraphPolar -> CShort -> IO ()

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_SetLineStyle"
               c_tgraphpolar_setlinestyle :: Ptr RawTGraphPolar -> CShort -> IO ()

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_SetLineWidth"
               c_tgraphpolar_setlinewidth :: Ptr RawTGraphPolar -> CShort -> IO ()

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_SetFillColor"
               c_tgraphpolar_setfillcolor :: Ptr RawTGraphPolar -> CInt -> IO ()

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_SetFillStyle"
               c_tgraphpolar_setfillstyle :: Ptr RawTGraphPolar -> CInt -> IO ()

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_GetMarkerColor"
               c_tgraphpolar_getmarkercolor :: Ptr RawTGraphPolar -> IO CShort

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_GetMarkerStyle"
               c_tgraphpolar_getmarkerstyle :: Ptr RawTGraphPolar -> IO CShort

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_GetMarkerSize"
               c_tgraphpolar_getmarkersize :: Ptr RawTGraphPolar -> IO CFloat

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_ResetAttMarker"
               c_tgraphpolar_resetattmarker ::
               Ptr RawTGraphPolar -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_SetMarkerAttributes"
               c_tgraphpolar_setmarkerattributes :: Ptr RawTGraphPolar -> IO ()

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_SetMarkerColor"
               c_tgraphpolar_setmarkercolor ::
               Ptr RawTGraphPolar -> CShort -> IO ()

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_SetMarkerStyle"
               c_tgraphpolar_setmarkerstyle ::
               Ptr RawTGraphPolar -> CShort -> IO ()

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_SetMarkerSize"
               c_tgraphpolar_setmarkersize ::
               Ptr RawTGraphPolar -> CShort -> IO ()

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_Clear" c_tgraphpolar_clear ::
               Ptr RawTGraphPolar -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_Draw" c_tgraphpolar_draw ::
               Ptr RawTGraphPolar -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_FindObject"
               c_tgraphpolar_findobject ::
               Ptr RawTGraphPolar -> CString -> IO (Ptr RawTObject)

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_GetName" c_tgraphpolar_getname
               :: Ptr RawTGraphPolar -> IO CString

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_IsA" c_tgraphpolar_isa ::
               Ptr RawTGraphPolar -> IO (Ptr RawTClass)

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_Paint" c_tgraphpolar_paint ::
               Ptr RawTGraphPolar -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_printObj"
               c_tgraphpolar_printobj :: Ptr RawTGraphPolar -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_SaveAs" c_tgraphpolar_saveas ::
               Ptr RawTGraphPolar -> CString -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_Write" c_tgraphpolar_write ::
               Ptr RawTGraphPolar -> CString -> CInt -> CInt -> IO CInt

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_Write_" c_tgraphpolar_write_ ::
               Ptr RawTGraphPolar -> IO CInt

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_delete" c_tgraphpolar_delete ::
               Ptr RawTGraphPolar -> IO ()

foreign import ccall interruptible
               "HROOTGrafTGraphPolar.h TGraphPolar_newTGraphPolar"
               c_tgraphpolar_newtgraphpolar ::
               CInt ->
                 Ptr CDouble ->
                   Ptr CDouble ->
                     Ptr CDouble -> Ptr CDouble -> IO (Ptr RawTGraphPolar)
