{-# LANGUAGE ForeignFunctionInterface, InterruptibleFFI #-}
module HROOT.Graf.TCrown.FFI where
import Data.Word
import Data.Int
import Foreign.C
import Foreign.Ptr
import HROOT.Graf.TCrown.RawType
import HROOT.Graf.TCrown.RawType
import HROOT.Core.TObject.RawType
import HROOT.Core.TClass.RawType

foreign import ccall interruptible "HROOTGrafTCrown.h TCrown_Clear"
               c_tcrown_clear :: Ptr RawTCrown -> CString -> IO ()

foreign import ccall interruptible "HROOTGrafTCrown.h TCrown_Draw"
               c_tcrown_draw :: Ptr RawTCrown -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCrown.h TCrown_FindObject" c_tcrown_findobject ::
               Ptr RawTCrown -> CString -> IO (Ptr RawTObject)

foreign import ccall interruptible
               "HROOTGrafTCrown.h TCrown_GetName" c_tcrown_getname ::
               Ptr RawTCrown -> IO CString

foreign import ccall interruptible "HROOTGrafTCrown.h TCrown_IsA"
               c_tcrown_isa :: Ptr RawTCrown -> IO (Ptr RawTClass)

foreign import ccall interruptible "HROOTGrafTCrown.h TCrown_Paint"
               c_tcrown_paint :: Ptr RawTCrown -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCrown.h TCrown_printObj" c_tcrown_printobj ::
               Ptr RawTCrown -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCrown.h TCrown_SaveAs" c_tcrown_saveas ::
               Ptr RawTCrown -> CString -> CString -> IO ()

foreign import ccall interruptible "HROOTGrafTCrown.h TCrown_Write"
               c_tcrown_write ::
               Ptr RawTCrown -> CString -> CInt -> CInt -> IO CInt

foreign import ccall interruptible
               "HROOTGrafTCrown.h TCrown_Write_" c_tcrown_write_ ::
               Ptr RawTCrown -> IO CInt

foreign import ccall interruptible
               "HROOTGrafTCrown.h TCrown_GetLineColor" c_tcrown_getlinecolor ::
               Ptr RawTCrown -> IO CShort

foreign import ccall interruptible
               "HROOTGrafTCrown.h TCrown_GetLineStyle" c_tcrown_getlinestyle ::
               Ptr RawTCrown -> IO CShort

foreign import ccall interruptible
               "HROOTGrafTCrown.h TCrown_GetLineWidth" c_tcrown_getlinewidth ::
               Ptr RawTCrown -> IO CShort

foreign import ccall interruptible
               "HROOTGrafTCrown.h TCrown_ResetAttLine" c_tcrown_resetattline ::
               Ptr RawTCrown -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCrown.h TCrown_SetLineAttributes"
               c_tcrown_setlineattributes :: Ptr RawTCrown -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCrown.h TCrown_SetLineColor" c_tcrown_setlinecolor ::
               Ptr RawTCrown -> CShort -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCrown.h TCrown_SetLineStyle" c_tcrown_setlinestyle ::
               Ptr RawTCrown -> CShort -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCrown.h TCrown_SetLineWidth" c_tcrown_setlinewidth ::
               Ptr RawTCrown -> CShort -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCrown.h TCrown_SetFillColor" c_tcrown_setfillcolor ::
               Ptr RawTCrown -> CInt -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCrown.h TCrown_SetFillStyle" c_tcrown_setfillstyle ::
               Ptr RawTCrown -> CInt -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCrown.h TCrown_delete" c_tcrown_delete ::
               Ptr RawTCrown -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCrown.h TCrown_newTCrown" c_tcrown_newtcrown ::
               CDouble ->
                 CDouble ->
                   CDouble -> CDouble -> CDouble -> CDouble -> IO (Ptr RawTCrown)
