{-# LANGUAGE EmptyDataDecls, ExistentialQuantification,
  FlexibleContexts, FlexibleInstances, ForeignFunctionInterface,
  MultiParamTypeClasses, ScopedTypeVariables, TypeFamilies,
  TypeSynonymInstances #-}
module HROOT.Graf.TCanvas.Interface where
import Data.Word
import Data.Int
import Foreign.C
import Foreign.Ptr
import FFICXX.Runtime.Cast
import HROOT.Graf.TCanvas.RawType
import HROOT.Graf.TPad.Interface

class (ITPad a) => ITCanvas a where
        toggleEditor :: () => a -> IO ()
        
        toggleEventStatus :: () => a -> IO ()
        
        toggleToolBar :: () => a -> IO ()
        
        toggleToolTips :: () => a -> IO ()

upcastTCanvas :: forall a . (FPtr a, ITCanvas a) => a -> TCanvas
upcastTCanvas h
  = let fh = get_fptr h
        fh2 :: Ptr RawTCanvas = castPtr fh
      in cast_fptr_to_obj fh2

downcastTCanvas :: forall a . (FPtr a, ITCanvas a) => TCanvas -> a
downcastTCanvas h
  = let fh = get_fptr h
        fh2 = castPtr fh
      in cast_fptr_to_obj fh2
