{-# LANGUAGE ForeignFunctionInterface, InterruptibleFFI #-}
module HROOT.Graf.TCanvas.FFI where
import Data.Word
import Data.Int
import Foreign.C
import Foreign.Ptr
import HROOT.Graf.TCanvas.RawType
import HROOT.Graf.TCanvas.RawType
import HROOT.Hist.TH1F.RawType
import HROOT.Graf.TView.RawType
import HROOT.Core.TObject.RawType
import HROOT.Core.TClass.RawType

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_DrawFrame" c_tcanvas_drawframe ::
               Ptr RawTCanvas ->
                 CDouble ->
                   CDouble -> CDouble -> CDouble -> CString -> IO (Ptr RawTH1F)

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_GetView" c_tcanvas_getview ::
               Ptr RawTCanvas -> IO (Ptr RawTView)

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_SetView0" c_tcanvas_setview0 ::
               Ptr RawTCanvas -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_SetView" c_tcanvas_setview ::
               Ptr RawTCanvas -> Ptr RawTView -> IO ()

foreign import ccall interruptible "HROOTGrafTCanvas.h TCanvas_cd"
               c_tcanvas_cd :: Ptr RawTCanvas -> CInt -> IO (Ptr RawTCanvas)

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_divide_tvirtualpad"
               c_tcanvas_divide_tvirtualpad ::
               Ptr RawTCanvas -> CInt -> CInt -> CFloat -> CFloat -> CInt -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_Modified" c_tcanvas_modified ::
               Ptr RawTCanvas -> CBool -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_Range" c_tcanvas_range ::
               Ptr RawTCanvas -> CDouble -> CDouble -> CDouble -> CDouble -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_SetLogx" c_tcanvas_setlogx ::
               Ptr RawTCanvas -> CInt -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_SetLogy" c_tcanvas_setlogy ::
               Ptr RawTCanvas -> CInt -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_SetLogz" c_tcanvas_setlogz ::
               Ptr RawTCanvas -> CInt -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_Update" c_tcanvas_update ::
               Ptr RawTCanvas -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_Clear" c_tcanvas_clear ::
               Ptr RawTCanvas -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_Draw" c_tcanvas_draw ::
               Ptr RawTCanvas -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_FindObject" c_tcanvas_findobject ::
               Ptr RawTCanvas -> CString -> IO (Ptr RawTObject)

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_GetName" c_tcanvas_getname ::
               Ptr RawTCanvas -> IO CString

foreign import ccall interruptible "HROOTGrafTCanvas.h TCanvas_IsA"
               c_tcanvas_isa :: Ptr RawTCanvas -> IO (Ptr RawTClass)

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_Paint" c_tcanvas_paint ::
               Ptr RawTCanvas -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_printObj" c_tcanvas_printobj ::
               Ptr RawTCanvas -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_SaveAs" c_tcanvas_saveas ::
               Ptr RawTCanvas -> CString -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_Write" c_tcanvas_write ::
               Ptr RawTCanvas -> CString -> CInt -> CInt -> IO CInt

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_Write_" c_tcanvas_write_ ::
               Ptr RawTCanvas -> IO CInt

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_GetLineColor" c_tcanvas_getlinecolor ::
               Ptr RawTCanvas -> IO CShort

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_GetLineStyle" c_tcanvas_getlinestyle ::
               Ptr RawTCanvas -> IO CShort

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_GetLineWidth" c_tcanvas_getlinewidth ::
               Ptr RawTCanvas -> IO CShort

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_ResetAttLine" c_tcanvas_resetattline ::
               Ptr RawTCanvas -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_SetLineAttributes"
               c_tcanvas_setlineattributes :: Ptr RawTCanvas -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_SetLineColor" c_tcanvas_setlinecolor ::
               Ptr RawTCanvas -> CShort -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_SetLineStyle" c_tcanvas_setlinestyle ::
               Ptr RawTCanvas -> CShort -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_SetLineWidth" c_tcanvas_setlinewidth ::
               Ptr RawTCanvas -> CShort -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_SetFillColor" c_tcanvas_setfillcolor ::
               Ptr RawTCanvas -> CInt -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_SetFillStyle" c_tcanvas_setfillstyle ::
               Ptr RawTCanvas -> CInt -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_ResetAttPad" c_tcanvas_resetattpad ::
               Ptr RawTCanvas -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_SetBottomMargin"
               c_tcanvas_setbottommargin :: Ptr RawTCanvas -> CFloat -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_SetLeftMargin" c_tcanvas_setleftmargin
               :: Ptr RawTCanvas -> CFloat -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_SetRightMargin"
               c_tcanvas_setrightmargin :: Ptr RawTCanvas -> CFloat -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_SetTopMargin" c_tcanvas_settopmargin ::
               Ptr RawTCanvas -> CFloat -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_SetMargin" c_tcanvas_setmargin ::
               Ptr RawTCanvas -> CFloat -> CFloat -> CFloat -> CFloat -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_SetAfile" c_tcanvas_setafile ::
               Ptr RawTCanvas -> CFloat -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_SetXfile" c_tcanvas_setxfile ::
               Ptr RawTCanvas -> CFloat -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_SetYfile" c_tcanvas_setyfile ::
               Ptr RawTCanvas -> CFloat -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_SetAstat" c_tcanvas_setastat ::
               Ptr RawTCanvas -> CFloat -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_SetXstat" c_tcanvas_setxstat ::
               Ptr RawTCanvas -> CFloat -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_SetYstat" c_tcanvas_setystat ::
               Ptr RawTCanvas -> CFloat -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_delete" c_tcanvas_delete ::
               Ptr RawTCanvas -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_newTCanvas" c_tcanvas_newtcanvas ::
               CString -> CString -> CInt -> CInt -> IO (Ptr RawTCanvas)

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_ToggleEditor" c_tcanvas_toggleeditor ::
               Ptr RawTCanvas -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_ToggleEventStatus"
               c_tcanvas_toggleeventstatus :: Ptr RawTCanvas -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_ToggleToolBar" c_tcanvas_toggletoolbar
               :: Ptr RawTCanvas -> IO ()

foreign import ccall interruptible
               "HROOTGrafTCanvas.h TCanvas_ToggleToolTips"
               c_tcanvas_toggletooltips :: Ptr RawTCanvas -> IO ()
