{-# LANGUAGE EmptyDataDecls, ExistentialQuantification,
  FlexibleContexts, FlexibleInstances, ForeignFunctionInterface,
  MultiParamTypeClasses, ScopedTypeVariables, TypeFamilies,
  TypeSynonymInstances #-}
module HROOT.Graf.TBox.Interface where
import Data.Word
import Data.Int
import Foreign.C
import Foreign.Ptr
import FFICXX.Runtime.Cast
import HROOT.Graf.TBox.RawType
import HROOT.Core.TObject.Interface
import HROOT.Core.TAttLine.Interface
import HROOT.Core.TAttFill.Interface

class (ITObject a, ITAttLine a, ITAttFill a) => ITBox a where

upcastTBox :: forall a . (FPtr a, ITBox a) => a -> TBox
upcastTBox h
  = let fh = get_fptr h
        fh2 :: Ptr RawTBox = castPtr fh
      in cast_fptr_to_obj fh2

downcastTBox :: forall a . (FPtr a, ITBox a) => TBox -> a
downcastTBox h
  = let fh = get_fptr h
        fh2 = castPtr fh
      in cast_fptr_to_obj fh2
