{-# LANGUAGE EmptyDataDecls, FlexibleContexts, FlexibleInstances,
  ForeignFunctionInterface, IncoherentInstances,
  MultiParamTypeClasses, OverlappingInstances, TemplateHaskell,
  TypeFamilies, TypeSynonymInstances #-}
module HROOT.Graf.TBox.Implementation where
import Data.Monoid
import Data.Word
import Data.Int
import Foreign.C
import Foreign.Ptr
import Language.Haskell.TH
import Language.Haskell.TH.Syntax
import System.IO.Unsafe
import FFICXX.Runtime.Cast
import FFICXX.Runtime.CodeGen.Cxx
import FFICXX.Runtime.TH
import HROOT.Graf.TBox.RawType
import HROOT.Graf.TBox.FFI
import HROOT.Graf.TBox.Interface
import HROOT.Graf.TBox.Cast
import HROOT.Graf.TBox.RawType
import HROOT.Graf.TBox.Cast
import HROOT.Graf.TBox.Interface
import HROOT.Core.TClass.RawType
import HROOT.Core.TClass.Cast
import HROOT.Core.TClass.Interface
import HROOT.Core.TObject.RawType
import HROOT.Core.TObject.Cast
import HROOT.Core.TObject.Interface
import HROOT.Core.TAttLine.RawType
import HROOT.Core.TAttLine.Cast
import HROOT.Core.TAttLine.Interface
import HROOT.Core.TAttFill.RawType
import HROOT.Core.TAttFill.Cast
import HROOT.Core.TAttFill.Interface
import STD.Deletable.RawType
import STD.Deletable.Cast
import STD.Deletable.Interface

instance () => ITBox (TBox) where

instance () => ITObject (TBox) where
        clear = xform1 c_tbox_clear
        draw = xform1 c_tbox_draw
        findObject = xform1 c_tbox_findobject
        getName = xform0 c_tbox_getname
        isA = xform0 c_tbox_isa
        paint = xform1 c_tbox_paint
        printObj = xform1 c_tbox_printobj
        saveAs = xform2 c_tbox_saveas
        write = xform3 c_tbox_write
        write_ = xform0 c_tbox_write_

instance () => ITAttLine (TBox) where
        getLineColor = xform0 c_tbox_getlinecolor
        getLineStyle = xform0 c_tbox_getlinestyle
        getLineWidth = xform0 c_tbox_getlinewidth
        resetAttLine = xform1 c_tbox_resetattline
        setLineAttributes = xform0 c_tbox_setlineattributes
        setLineColor = xform1 c_tbox_setlinecolor
        setLineStyle = xform1 c_tbox_setlinestyle
        setLineWidth = xform1 c_tbox_setlinewidth

instance () => ITAttFill (TBox) where
        setFillColor = xform1 c_tbox_setfillcolor
        setFillStyle = xform1 c_tbox_setfillstyle

instance () => IDeletable (TBox) where
        delete = xform0 c_tbox_delete

newTBox ::
          () => CDouble -> CDouble -> CDouble -> CDouble -> IO TBox
newTBox = xform3 c_tbox_newtbox
