{-# LANGUAGE ForeignFunctionInterface, InterruptibleFFI #-}
module HROOT.Graf.TBox.FFI where
import Data.Word
import Data.Int
import Foreign.C
import Foreign.Ptr
import HROOT.Graf.TBox.RawType
import HROOT.Graf.TBox.RawType
import HROOT.Core.TObject.RawType
import HROOT.Core.TClass.RawType

foreign import ccall interruptible "HROOTGrafTBox.h TBox_Clear"
               c_tbox_clear :: Ptr RawTBox -> CString -> IO ()

foreign import ccall interruptible "HROOTGrafTBox.h TBox_Draw"
               c_tbox_draw :: Ptr RawTBox -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTBox.h TBox_FindObject" c_tbox_findobject ::
               Ptr RawTBox -> CString -> IO (Ptr RawTObject)

foreign import ccall interruptible "HROOTGrafTBox.h TBox_GetName"
               c_tbox_getname :: Ptr RawTBox -> IO CString

foreign import ccall interruptible "HROOTGrafTBox.h TBox_IsA"
               c_tbox_isa :: Ptr RawTBox -> IO (Ptr RawTClass)

foreign import ccall interruptible "HROOTGrafTBox.h TBox_Paint"
               c_tbox_paint :: Ptr RawTBox -> CString -> IO ()

foreign import ccall interruptible "HROOTGrafTBox.h TBox_printObj"
               c_tbox_printobj :: Ptr RawTBox -> CString -> IO ()

foreign import ccall interruptible "HROOTGrafTBox.h TBox_SaveAs"
               c_tbox_saveas :: Ptr RawTBox -> CString -> CString -> IO ()

foreign import ccall interruptible "HROOTGrafTBox.h TBox_Write"
               c_tbox_write :: Ptr RawTBox -> CString -> CInt -> CInt -> IO CInt

foreign import ccall interruptible "HROOTGrafTBox.h TBox_Write_"
               c_tbox_write_ :: Ptr RawTBox -> IO CInt

foreign import ccall interruptible
               "HROOTGrafTBox.h TBox_GetLineColor" c_tbox_getlinecolor ::
               Ptr RawTBox -> IO CShort

foreign import ccall interruptible
               "HROOTGrafTBox.h TBox_GetLineStyle" c_tbox_getlinestyle ::
               Ptr RawTBox -> IO CShort

foreign import ccall interruptible
               "HROOTGrafTBox.h TBox_GetLineWidth" c_tbox_getlinewidth ::
               Ptr RawTBox -> IO CShort

foreign import ccall interruptible
               "HROOTGrafTBox.h TBox_ResetAttLine" c_tbox_resetattline ::
               Ptr RawTBox -> CString -> IO ()

foreign import ccall interruptible
               "HROOTGrafTBox.h TBox_SetLineAttributes" c_tbox_setlineattributes
               :: Ptr RawTBox -> IO ()

foreign import ccall interruptible
               "HROOTGrafTBox.h TBox_SetLineColor" c_tbox_setlinecolor ::
               Ptr RawTBox -> CShort -> IO ()

foreign import ccall interruptible
               "HROOTGrafTBox.h TBox_SetLineStyle" c_tbox_setlinestyle ::
               Ptr RawTBox -> CShort -> IO ()

foreign import ccall interruptible
               "HROOTGrafTBox.h TBox_SetLineWidth" c_tbox_setlinewidth ::
               Ptr RawTBox -> CShort -> IO ()

foreign import ccall interruptible
               "HROOTGrafTBox.h TBox_SetFillColor" c_tbox_setfillcolor ::
               Ptr RawTBox -> CInt -> IO ()

foreign import ccall interruptible
               "HROOTGrafTBox.h TBox_SetFillStyle" c_tbox_setfillstyle ::
               Ptr RawTBox -> CInt -> IO ()

foreign import ccall interruptible "HROOTGrafTBox.h TBox_delete"
               c_tbox_delete :: Ptr RawTBox -> IO ()

foreign import ccall interruptible "HROOTGrafTBox.h TBox_newTBox"
               c_tbox_newtbox ::
               CDouble -> CDouble -> CDouble -> CDouble -> IO (Ptr RawTBox)
