{-# LANGUAGE EmptyDataDecls, ExistentialQuantification,
  FlexibleContexts, FlexibleInstances, ForeignFunctionInterface,
  MultiParamTypeClasses, ScopedTypeVariables, TypeFamilies,
  TypeSynonymInstances #-}
module HROOT.Graf.TArrow.Interface where
import Data.Word
import Data.Int
import Foreign.C
import Foreign.Ptr
import FFICXX.Runtime.Cast
import HROOT.Graf.TArrow.RawType
import HROOT.Graf.TLine.Interface
import HROOT.Core.TAttFill.Interface

class (ITLine a, ITAttFill a) => ITArrow a where

upcastTArrow :: forall a . (FPtr a, ITArrow a) => a -> TArrow
upcastTArrow h
  = let fh = get_fptr h
        fh2 :: Ptr RawTArrow = castPtr fh
      in cast_fptr_to_obj fh2

downcastTArrow :: forall a . (FPtr a, ITArrow a) => TArrow -> a
downcastTArrow h
  = let fh = get_fptr h
        fh2 = castPtr fh
      in cast_fptr_to_obj fh2
