{-# LANGUAGE EmptyDataDecls, FlexibleContexts, FlexibleInstances,
  ForeignFunctionInterface, IncoherentInstances,
  MultiParamTypeClasses, OverlappingInstances, TemplateHaskell,
  TypeFamilies, TypeSynonymInstances #-}
module HROOT.Graf.TArrow.Implementation where
import Data.Monoid
import Data.Word
import Data.Int
import Foreign.C
import Foreign.Ptr
import Language.Haskell.TH
import Language.Haskell.TH.Syntax
import System.IO.Unsafe
import FFICXX.Runtime.Cast
import FFICXX.Runtime.CodeGen.Cxx
import FFICXX.Runtime.TH
import HROOT.Graf.TArrow.RawType
import HROOT.Graf.TArrow.FFI
import HROOT.Graf.TArrow.Interface
import HROOT.Graf.TArrow.Cast
import HROOT.Graf.TArrow.RawType
import HROOT.Graf.TArrow.Cast
import HROOT.Graf.TArrow.Interface
import HROOT.Core.TClass.RawType
import HROOT.Core.TClass.Cast
import HROOT.Core.TClass.Interface
import HROOT.Graf.TLine.RawType
import HROOT.Graf.TLine.Cast
import HROOT.Graf.TLine.Interface
import HROOT.Core.TAttFill.RawType
import HROOT.Core.TAttFill.Cast
import HROOT.Core.TAttFill.Interface
import HROOT.Core.TObject.RawType
import HROOT.Core.TObject.Cast
import HROOT.Core.TObject.Interface
import HROOT.Core.TAttLine.RawType
import HROOT.Core.TAttLine.Cast
import HROOT.Core.TAttLine.Interface
import STD.Deletable.RawType
import STD.Deletable.Cast
import STD.Deletable.Interface

instance () => ITArrow (TArrow) where

instance () => ITLine (TArrow) where
        drawLine = xform4 c_tarrow_drawline
        drawLineNDC = xform4 c_tarrow_drawlinendc
        paintLine = xform4 c_tarrow_paintline
        paintLineNDC = xform4 c_tarrow_paintlinendc
        setX1 = xform1 c_tarrow_setx1
        setX2 = xform1 c_tarrow_setx2
        setY1 = xform1 c_tarrow_sety1
        setY2 = xform1 c_tarrow_sety2

instance () => ITAttFill (TArrow) where
        setFillColor = xform1 c_tarrow_setfillcolor
        setFillStyle = xform1 c_tarrow_setfillstyle

instance () => ITObject (TArrow) where
        clear = xform1 c_tarrow_clear
        draw = xform1 c_tarrow_draw
        findObject = xform1 c_tarrow_findobject
        getName = xform0 c_tarrow_getname
        isA = xform0 c_tarrow_isa
        paint = xform1 c_tarrow_paint
        printObj = xform1 c_tarrow_printobj
        saveAs = xform2 c_tarrow_saveas
        write = xform3 c_tarrow_write
        write_ = xform0 c_tarrow_write_

instance () => ITAttLine (TArrow) where
        getLineColor = xform0 c_tarrow_getlinecolor
        getLineStyle = xform0 c_tarrow_getlinestyle
        getLineWidth = xform0 c_tarrow_getlinewidth
        resetAttLine = xform1 c_tarrow_resetattline
        setLineAttributes = xform0 c_tarrow_setlineattributes
        setLineColor = xform1 c_tarrow_setlinecolor
        setLineStyle = xform1 c_tarrow_setlinestyle
        setLineWidth = xform1 c_tarrow_setlinewidth

instance () => IDeletable (TArrow) where
        delete = xform0 c_tarrow_delete

newTArrow ::
            (Castable c0 CString) =>
            CDouble ->
              CDouble -> CDouble -> CDouble -> CFloat -> c0 -> IO TArrow
newTArrow = xform5 c_tarrow_newtarrow
