{-# LANGUAGE EmptyDataDecls, FlexibleContexts, FlexibleInstances,
  ForeignFunctionInterface, IncoherentInstances,
  MultiParamTypeClasses, OverlappingInstances, TemplateHaskell,
  TypeFamilies, TypeSynonymInstances #-}
module HROOT.Graf.TArc.Implementation where
import Data.Monoid
import Data.Word
import Data.Int
import Foreign.C
import Foreign.Ptr
import Language.Haskell.TH
import Language.Haskell.TH.Syntax
import System.IO.Unsafe
import FFICXX.Runtime.Cast
import FFICXX.Runtime.CodeGen.Cxx
import FFICXX.Runtime.TH
import HROOT.Graf.TArc.RawType
import HROOT.Graf.TArc.FFI
import HROOT.Graf.TArc.Interface
import HROOT.Graf.TArc.Cast
import HROOT.Graf.TArc.RawType
import HROOT.Graf.TArc.Cast
import HROOT.Graf.TArc.Interface
import HROOT.Core.TClass.RawType
import HROOT.Core.TClass.Cast
import HROOT.Core.TClass.Interface
import HROOT.Graf.TEllipse.RawType
import HROOT.Graf.TEllipse.Cast
import HROOT.Graf.TEllipse.Interface
import HROOT.Core.TObject.RawType
import HROOT.Core.TObject.Cast
import HROOT.Core.TObject.Interface
import HROOT.Core.TAttLine.RawType
import HROOT.Core.TAttLine.Cast
import HROOT.Core.TAttLine.Interface
import HROOT.Core.TAttFill.RawType
import HROOT.Core.TAttFill.Cast
import HROOT.Core.TAttFill.Interface
import STD.Deletable.RawType
import STD.Deletable.Cast
import STD.Deletable.Interface

instance () => ITArc (TArc) where

instance () => ITEllipse (TArc) where

instance () => ITObject (TArc) where
        clear = xform1 c_tarc_clear
        draw = xform1 c_tarc_draw
        findObject = xform1 c_tarc_findobject
        getName = xform0 c_tarc_getname
        isA = xform0 c_tarc_isa
        paint = xform1 c_tarc_paint
        printObj = xform1 c_tarc_printobj
        saveAs = xform2 c_tarc_saveas
        write = xform3 c_tarc_write
        write_ = xform0 c_tarc_write_

instance () => ITAttLine (TArc) where
        getLineColor = xform0 c_tarc_getlinecolor
        getLineStyle = xform0 c_tarc_getlinestyle
        getLineWidth = xform0 c_tarc_getlinewidth
        resetAttLine = xform1 c_tarc_resetattline
        setLineAttributes = xform0 c_tarc_setlineattributes
        setLineColor = xform1 c_tarc_setlinecolor
        setLineStyle = xform1 c_tarc_setlinestyle
        setLineWidth = xform1 c_tarc_setlinewidth

instance () => ITAttFill (TArc) where
        setFillColor = xform1 c_tarc_setfillcolor
        setFillStyle = xform1 c_tarc_setfillstyle

instance () => IDeletable (TArc) where
        delete = xform0 c_tarc_delete

newTArc ::
          () =>
          CDouble -> CDouble -> CDouble -> CDouble -> CDouble -> IO TArc
newTArc = xform4 c_tarc_newtarc
