
#ifdef __cplusplus
extern "C" {
#endif

#pragma once


#include "HROOT-grafType.h"

#include "HROOTCoreTVirtualPad.h"

#include "HROOTCoreTObject.h"

#include "HROOTCoreTAttLine.h"

#include "HROOTCoreTAttFill.h"

#include "HROOTCoreTAttPad.h"

#include "HROOTCoreTQObject.h"

#include "STDDeletable.h"

#include "HROOT-histType.h"

#include "HROOT-coreType.h"


#define TPAD_DECL_VIRT(Type) \
TH1F_p Type##_DrawFrame ( Type##_p p, double xmin, double ymin, double xmax, double ymax, const char* title );\
TView_p Type##_GetView ( Type##_p p );\
void Type##_SetView0 ( Type##_p p );\
void Type##_SetView ( Type##_p p, TView_p view );


#define TPAD_DECL_NONVIRT(Type) \
Type##_p Type##_newTPad ( const char* name, const char* title, double xlow, double ylow, double xup, double yup );


#define TPAD_DECL_ACCESSOR(Type) \



#define TPAD_DEF_VIRT(Type) \
TH1F_p Type##_DrawFrame ( Type##_p p, double xmin, double ymin, double xmax, double ymax, const char* title ) {\
return from_nonconst_to_nonconst<TH1F_t, TH1F>((TH1F*)((TYPECASTMETHOD(Type, DrawFrame, TPad))(p))->DrawFrame(xmin, ymin, xmax, ymax, title));\
}\
\
TView_p Type##_GetView ( Type##_p p ) {\
return from_nonconst_to_nonconst<TView_t, TView>((TView*)((TYPECASTMETHOD(Type, GetView, TPad))(p))->GetView());\
}\
\
void Type##_SetView0 ( Type##_p p ) {\
((TYPECASTMETHOD(Type, SetView0, TPad))(p))->SetView();\
}\
\
void Type##_SetView ( Type##_p p, TView_p view ) {\
((TYPECASTMETHOD(Type, SetView, TPad))(p))->SetView(from_nonconst_to_nonconst<TView, TView_t>(view));\
}


#define TPAD_DEF_NONVIRT(Type) \
Type##_p Type##_newTPad ( const char* name, const char* title, double xlow, double ylow, double xup, double yup ) {\
Type* newp=new Type(name, title, xlow, ylow, xup, yup);return from_nonconst_to_nonconst<Type##_t, Type>(newp);\
}


#define TPAD_DEF_ACCESSOR(Type) \



TVIRTUALPAD_DECL_VIRT(TPad)
TOBJECT_DECL_VIRT(TPad)
TATTLINE_DECL_VIRT(TPad)
TATTFILL_DECL_VIRT(TPad)
TATTPAD_DECL_VIRT(TPad)
TQOBJECT_DECL_VIRT(TPad)
DELETABLE_DECL_VIRT(TPad)
TPAD_DECL_VIRT(TPad)
TPAD_DECL_NONVIRT(TPad)
TPAD_DECL_ACCESSOR(TPad)

#ifdef __cplusplus
}
#endif

